/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.generallimits.service;

import com.ur.math.Momentum;
import com.ur.math.Speed;
import com.ur.math.Time;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.RobotTool;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.safety.generallimits.domain.GeneralLimitsConstants;
import com.ur.safety.generallimits.domain.GeneralLimitsMode;
import com.ur.safety.generallimits.domain.SafetyPreset;
import com.ur.safety.generallimits.domain.SingleModePattern;
import com.ur.safety.generallimits.service.GeneralLimitsService;
import java.util.Arrays;
import java.util.Objects;
import javax.inject.Inject;

public class GeneralLimitsServiceImpl
implements GeneralLimitsService {
    private final RobotTool robotTool;

    @Inject
    public GeneralLimitsServiceImpl(RobotConfigurationProvider robot) {
        this.robotTool = robot.getRobotTool();
    }

    @Override
    public boolean isApplied(GeneralLimitsMode generalLimitsMode, SafetyLimitsComponent safetyLimits) {
        SafetyPreset preset = this.getPresetForMode(generalLimitsMode);
        return Objects.nonNull(preset) && preset.isApplied(safetyLimits);
    }

    @Override
    public void applyPreset(GeneralLimitsMode generalLimitsMode, SafetySetup safetySetup) {
        this.applyPreset(generalLimitsMode, (SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class));
    }

    @Override
    public void applyPreset(GeneralLimitsMode generalLimitsMode, SafetyLimitsComponent safetyLimits) {
        SafetyPreset preset = this.getPresetForMode(generalLimitsMode);
        if (Objects.isNull(preset)) {
            throw new IllegalStateException("No preset is associated with mode " + this);
        }
        preset.applyTo(safetyLimits);
    }

    @Override
    public GeneralLimitsMode getMode(SafetySetup safetySetup) {
        return this.getMode((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class));
    }

    @Override
    public GeneralLimitsMode getMode(SafetyLimitsComponent component) {
        return Arrays.stream(GeneralLimitsMode.values()).filter(mode -> this.isApplied((GeneralLimitsMode)((Object)mode), component)).findFirst().orElse(GeneralLimitsMode.CUSTOMIZED_MODE);
    }

    @Override
    public SingleModePattern getPattern(GeneralLimitsMode generalLimitsMode) {
        if (GeneralLimitsMode.LEAST_RESTRICTED_MODE == generalLimitsMode) {
            return this.getLeastRestrictedPattern();
        }
        if (GeneralLimitsMode.DEFAULT_MODE == generalLimitsMode) {
            return this.getDefaultPattern();
        }
        if (GeneralLimitsMode.RESTRICTED_MODE == generalLimitsMode) {
            return this.getRestrictedPattern();
        }
        if (GeneralLimitsMode.MOST_RESTRICTED_MODE == generalLimitsMode) {
            return this.getMostRestrictedPattern();
        }
        return null;
    }

    private SafetyPreset getPresetForMode(GeneralLimitsMode generalLimitsMode) {
        if (GeneralLimitsMode.LEAST_RESTRICTED_MODE == generalLimitsMode) {
            SingleModePattern normalMode = this.getLeastRestrictedPattern();
            SingleModePattern reducedMode = this.getDefaultPattern();
            return new SafetyPreset(normalMode, reducedMode);
        }
        if (GeneralLimitsMode.DEFAULT_MODE == generalLimitsMode) {
            SingleModePattern normalMode = this.getDefaultPattern();
            SingleModePattern reducedMode = this.getRestrictedPattern();
            return new SafetyPreset(normalMode, reducedMode);
        }
        if (GeneralLimitsMode.RESTRICTED_MODE == generalLimitsMode) {
            SingleModePattern normalMode = this.getRestrictedPattern();
            SingleModePattern reducedMode = this.getMostRestrictedPattern();
            return new SafetyPreset(normalMode, reducedMode);
        }
        if (GeneralLimitsMode.MOST_RESTRICTED_MODE == generalLimitsMode) {
            SingleModePattern normalMode = this.getMostRestrictedPattern();
            SingleModePattern reducedMode = this.getMostRestrictedPattern();
            return new SafetyPreset(normalMode, reducedMode);
        }
        return null;
    }

    private SingleModePattern getLeastRestrictedPattern() {
        Speed maxToolSpeed = Speed.from((double)this.robotTool.getMaximumToolSpeedValue(), (Speed.Unit)Speed.Unit.SI);
        Momentum maxMomentum = Momentum.create((double)this.robotTool.getMaximumMomentumValue(), (Momentum.Unit)Momentum.Unit.SI);
        Speed maxElbowSpeed = Speed.from((double)this.robotTool.getMaximumElbowSpeedValue(), (Speed.Unit)Speed.Unit.SI);
        Time maxStoppingTime = Time.from((double)this.robotTool.getMaximumStoppingTimeValue(), (Time.Unit)Time.Unit.SI);
        return new SingleModePattern(GeneralLimitsConstants.MAX_FORCE, GeneralLimitsConstants.MAX_POWER, maxToolSpeed, maxMomentum, GeneralLimitsConstants.MAX_ELBOW_FORCE, maxElbowSpeed, GeneralLimitsConstants.MAX_STOPPING_DISTANCE, maxStoppingTime);
    }

    private SingleModePattern getDefaultPattern() {
        return new SingleModePattern(GeneralLimitsConstants.DEFAULT_FORCE, GeneralLimitsConstants.DEFAULT_POWER, GeneralLimitsConstants.DEFAULT_SPEED, GeneralLimitsConstants.DEFAULT_MOMENTUM, GeneralLimitsConstants.DEFAULT_ELBOW_FORCE, GeneralLimitsConstants.DEFAULT_ELBOW_SPEED, GeneralLimitsConstants.DEFAULT_STOPPING_DISTANCE, GeneralLimitsConstants.DEFAULT_STOPPING_TIME);
    }

    private SingleModePattern getRestrictedPattern() {
        return new SingleModePattern(GeneralLimitsConstants.LOW_FORCE, GeneralLimitsConstants.LOW_POWER, GeneralLimitsConstants.LOW_SPEED, GeneralLimitsConstants.LOW_MOMENTUM, GeneralLimitsConstants.LOW_ELBOW_FORCE, GeneralLimitsConstants.LOW_ELBOW_SPEED, GeneralLimitsConstants.LOW_STOPPING_DISTANCE, GeneralLimitsConstants.LOW_STOPPING_TIME);
    }

    private SingleModePattern getMostRestrictedPattern() {
        return new SingleModePattern(GeneralLimitsConstants.VERY_LOW_FORCE, GeneralLimitsConstants.VERY_LOW_POWER, GeneralLimitsConstants.VERY_LOW_SPEED, GeneralLimitsConstants.VERY_LOW_MOMENTUM, GeneralLimitsConstants.VERY_LOW_ELBOW_FORCE, GeneralLimitsConstants.VERY_LOW_ELBOW_SPEED, GeneralLimitsConstants.VERY_LOW_STOPPING_DISTANCE, GeneralLimitsConstants.VERY_LOW_STOPPING_TIME);
    }
}

