/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.hardware;

import com.ur.polyscope.immi.ImmiSettings;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.hardware.CheckboxContribution;
import com.ur.safety.misc.core.SafetyMiscConfiguration;
import com.ur.view.constants.immi.ImmiType;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;

public class EuromapCheckboxContribution
implements CheckboxContribution {
    public static final String EUROMAP_67_CHECK = "euromap67Check.EuromapCheckboxContribution";
    private final SafetyMiscConfiguration safetyMiscConfiguration;
    private JCheckBox euromap67CheckBox;
    private final SafetyTextResource textResource;

    @Inject
    public EuromapCheckboxContribution(SafetySettingsLookupService provider, SafetyTextResource textResource) {
        this.textResource = textResource;
        this.safetyMiscConfiguration = (SafetyMiscConfiguration)provider.getSafetySetup().getComponent(SafetyMiscConfiguration.class);
        this.initCheckbox();
    }

    @Override
    public JCheckBox getCheckBox() {
        return this.euromap67CheckBox;
    }

    @Override
    public void onSaveAndRestart() {
        if (this.euromap67CheckBox.isSelected()) {
            ImmiSettings.enableEuromap67();
        } else {
            ImmiSettings.disableEuromap67();
        }
    }

    @Override
    public void setCheckboxSelectionToConfigurationValue() {
        this.euromap67CheckBox.setSelected(this.safetyMiscConfiguration.getImmiType().equals((Object)ImmiType.E67));
    }

    private void initCheckbox() {
        this.euromap67CheckBox = new JCheckBox();
        this.euromap67CheckBox.setName(EUROMAP_67_CHECK);
        this.euromap67CheckBox.setText(this.textResource.Euromap67());
        this.euromap67CheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.euromap67CheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EuromapCheckboxContribution.this.euromap67CheckBoxActionPerformed();
            }
        });
    }

    private void euromap67CheckBoxActionPerformed() {
        if (this.euromap67CheckBox.isSelected()) {
            this.safetyMiscConfiguration.setImmiType(ImmiType.E67);
        } else {
            this.safetyMiscConfiguration.setImmiType(ImmiType.NOT_PRESENT);
        }
    }
}

