/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.hardware;

import com.ur.polyscope.installation.menu.InstallationMenuCategory;
import com.ur.polyscope.installation.menu.InstallationMenuContribution;
import com.ur.polyscope.viewfacade.lang.Errorable;
import com.ur.polyscope.viewfacade.safety.SafetyTabNavigationEvent;
import com.ur.resources.ViewImageResource;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.hardware.HardwareCardPanel;
import com.ur.safety.hardware.HardwarePanel;
import com.ur.safety.hardware.HardwarePanelNavigationEvent;
import com.ur.swing.ShowScreenActionImpl;
import com.ur.swing.card.ShowIconListener;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.InformationMessage;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.MenuExtension;
import com.ur.util.event.EventManager;
import gui.tools.LanguagePack;
import gui.tools.LegacyURDialogCreator;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.Icon;

@Singleton
@Extension(value="InstallationMenu")
public class HardwareMenuExtension
extends ShowScreenActionImpl
implements MenuExtension {
    public static final int PRIORITY = 1005;

    @Inject
    public HardwareMenuExtension(SafetyTextResource textResource, EventManager eventManager) {
        super(HardwareCardPanel.class, null);
        this.putValue("Name", textResource.safetyTabHardware());
        this.putValue("HelpId", "gui:installation_safety_hardware");
        this.putValue("InternalName", HardwarePanel.SHOW_HARDWARE_SCREEN_ACTION);
        this.addIconListener(eventManager);
        this.registerHardwarePanelNavigationEvent(eventManager);
    }

    private void addIconListener(EventManager eventManager) {
        eventManager.addStrongListener(ShowIconListener.class, (forComponent, setIcon) -> {
            if (forComponent instanceof HardwarePanel) {
                this.putValue("SmallIcon", setIcon);
                HardwarePanel hardwarePanel = (HardwarePanel)forComponent;
                this.setHardwarePanelIcon(hardwarePanel, setIcon);
            }
        });
    }

    private void setHardwarePanelIcon(HardwarePanel hardwarePanel, Icon setIcon) {
        if (hardwarePanel.hasValidationError()) {
            this.putValue("SmallIcon", ViewImageResource.formError());
            return;
        }
        this.putValue("SmallIcon", setIcon);
    }

    public MenuExtension.MenuContribution create() {
        return MenuExtension.MenuContribution.locateAfter((int)1005, (MenuExtension.MenuContribution)new InstallationMenuContribution((Action)((Object)this), InstallationMenuCategory.SAFETY));
    }

    private void registerHardwarePanelNavigationEvent(EventManager eventManager) {
        HardwarePanelNavigationEvent hardwarePanelNavigationEvent = () -> this.sendNavigateToHardwarePanelEvent(eventManager);
        eventManager.addStrongListener(HardwarePanelNavigationEvent.class, (Object)hardwarePanelNavigationEvent);
    }

    private void sendNavigateToHardwarePanelEvent(EventManager eventManager) {
        if (!this.isHardwarePanelVisible()) {
            this.informUserToResolveErrors(eventManager);
        }
    }

    private boolean isHardwarePanelVisible() {
        return ((HardwareCardPanel)this.getFlipManager().getCardPanel(HardwareCardPanel.class)).isVisible();
    }

    private void informUserToResolveErrors(EventManager eventManager) {
        if (this.askUserToResolveSafetyErrors()) {
            eventManager.fireEvent(SafetyTabNavigationEvent.class, safetyTabNavigationEvent -> safetyTabNavigationEvent.navigateToTab((Errorable)this.getFlipManager().getCardPanel(HardwareCardPanel.class)));
        }
    }

    private boolean askUserToResolveSafetyErrors() {
        DialogReturnValue result = LegacyURDialogCreator.informMessageDialog((InformationMessage)LanguagePack.getConfirmationMessages().informUserToResolveSafetyErrors());
        return result != DialogReturnValue.CANCEL;
    }
}

