/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.hardware;

import com.ur.polyscope.installation.InstallationListener;
import com.ur.polyscope.viewfacade.lang.Errorable;
import com.ur.polyscope.viewfacade.lang.ShowIcon;
import com.ur.safety.Safety;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.Settings;
import com.ur.safety.hardware.HardwareChangeListener;
import com.ur.safety.impl.ReloadOnSafetyLoaded;
import com.ur.safety.misc.MiscSetupPanel;
import com.ur.safety.urcapequipment.ui.SafetyDevicePanel;
import com.ur.safety.util.domain.UpdateParentWithFormState;
import com.ur.safety.util.infrastructure.ActivatablePanel;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.event.EventManager;
import com.ur.util.event.EventNotificationService;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.UIManager;

public class HardwarePanel
extends ActivatablePanel
implements ReloadOnSafetyLoaded {
    public static final String SHOW_HARDWARE_SCREEN_ACTION = "showHardware." + MiscSetupPanel.class.getSimpleName();
    private static final int CARD_SPACING_HEIGHT = UIManager.getInt("CardPanel.space");
    private final MiscSetupPanel miscSetupPanel;
    private final SafetyDevicePanel safetyDevicePanel;
    private final UpdateParentWithFormState miscSetupPanelFormStatus;
    private final UpdateParentWithFormState safetyDevicePanelFormStatus;

    @Inject
    public HardwarePanel(MiscSetupPanel miscSetupPanel, SafetyDevicePanel safetyDevicePanel, @Safety ShowIcon showIconForParent, EventManager eventManager) {
        this.miscSetupPanel = miscSetupPanel;
        this.safetyDevicePanel = safetyDevicePanel;
        this.miscSetupPanelFormStatus = new UpdateParentWithFormState(showIconForParent, this);
        this.safetyDevicePanelFormStatus = new UpdateParentWithFormState(showIconForParent, this);
        this.setLayout();
        this.add(miscSetupPanel);
        this.add(Box.createRigidArea(new Dimension(0, CARD_SPACING_HEIGHT)));
        this.add(safetyDevicePanel);
        this.registerEventNotification();
        this.registerCreateInstallationListener(eventManager);
        this.featureToggleSafetyDevicePanel();
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
    }

    private void setLayout() {
        this.setLayout(new BoxLayout(this, 3));
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
    }

    private void registerEventNotification() {
        HardwareChangeListener hardwareChangeListener = new HardwareChangeListener(this);
        EventNotificationService.register((Object)this, SafetyChangeListener.class, (Object)hardwareChangeListener);
    }

    private void registerCreateInstallationListener(EventManager eventManager) {
        InstallationListener installationListener = this::handleInstallationEvent;
        eventManager.addStrongListener(InstallationListener.class, (Object)installationListener);
    }

    private void handleInstallationEvent(InstallationListener.Event event) {
        if (event.getType() == InstallationListener.EventType.RESET_INSTALLATION_URCAPS) {
            this.safetyDevicePanel.resetUI(this.safetyDevicePanelFormStatus);
        }
    }

    @Override
    public void reset() {
        this.resetSubPanels();
    }

    @Override
    public void activate() {
        this.resetSubPanels();
    }

    @Override
    public void deactivate() {
    }

    private void resetSubPanels() {
        this.miscSetupPanel.resetUI(this.miscSetupPanelFormStatus);
        this.safetyDevicePanel.resetUI(this.safetyDevicePanelFormStatus);
    }

    public void bindFormValidation() {
        this.miscSetupPanel.bindFormValidation(this.miscSetupPanelFormStatus);
        this.safetyDevicePanel.bindFormValidation(this.safetyDevicePanelFormStatus);
    }

    public boolean hasValidationError() {
        return this.getStatus() == Errorable.Status.ERROR;
    }

    @Override
    public Errorable.Status getStatus() {
        List<Errorable.Status> statusList = Arrays.asList(this.miscSetupPanelFormStatus.getOverallStatus(), this.safetyDevicePanelFormStatus.getOverallStatus());
        statusList.sort(Comparator.comparingInt(Enum::ordinal));
        return statusList.stream().findFirst().orElse(Errorable.Status.OK);
    }

    @Override
    public void addStatusListener(Errorable.StatusListener listener) {
        this.miscSetupPanelFormStatus.addStatusListener(listener);
        this.safetyDevicePanelFormStatus.addStatusListener(listener);
    }

    @Override
    public void removeStatusListener(Errorable.StatusListener listener) {
        this.miscSetupPanelFormStatus.removeStatusListener(listener);
        this.safetyDevicePanelFormStatus.removeStatusListener(listener);
    }

    private void featureToggleSafetyDevicePanel() {
        this.safetyDevicePanel.setVisible(Settings.isDynamicSafetyLimitsEnabled());
    }
}

