/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.hardware;

import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.persistence.OptionsSection;
import com.ur.polyscope.robot.configuration.teachpendent.TPCapable;
import com.ur.polyscope.robot.configuration.teachpendent.TPCapableProvider;
import com.ur.polyscope.safety.SafetySetupContribution;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.misc.core.SafetyMiscConfiguration;
import com.ur.view.constants.dev.TPType;
import com.ur.view.constants.immi.ImmiType;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class SafetyMiscContribution
implements SafetySetupContribution<SafetyMiscConfiguration> {
    private static final String MISC_SECTION_NAME = "MiscConfiguration";
    private static final String USE_TEACH_PENDANT_STR = "teach_pendant";
    private static final String USE_EUROMAP67_STR = "euromap67";
    private final TPCapableProvider tpCapableProvider;

    @Inject
    public SafetyMiscContribution(TPCapableProvider tpCapableProvider) {
        this.tpCapableProvider = tpCapableProvider;
    }

    private void updateTP(SafetyMiscConfiguration safetyMiscConfiguration) {
        Optional tpCapable = this.tpCapableProvider.getTPCapable();
        if (tpCapable.isPresent()) {
            safetyMiscConfiguration.setTeachPendant(((TPCapable)tpCapable.get()).getDefaultTeachPendent());
        } else {
            safetyMiscConfiguration.setTeachPendant(TPType.NONE);
        }
    }

    public Class<SafetyMiscConfiguration> getComponentType() {
        return SafetyMiscConfiguration.class;
    }

    public SafetyMiscConfiguration createDefaultComponent() {
        SafetyMiscConfiguration safetyMiscConfiguration = new SafetyMiscConfiguration();
        this.updateTP(safetyMiscConfiguration);
        return safetyMiscConfiguration;
    }

    public SafetyMiscConfiguration readFromOptions(ChecksumVersion version, Options options) {
        SafetyMiscConfiguration component = this.createDefaultComponent();
        this.setToOptionsValues(component, options);
        return component;
    }

    public void copyToOptions(ChecksumVersion checksumVersion, Options options, SafetyMiscConfiguration component) {
        this.setOptionValues(component, options);
    }

    public void copyControllerRepresentationTo(ChecksumVersion checksumVersion, Options options, SafetyMiscConfiguration component) {
        this.setOptionValues(component, options);
    }

    private void setToOptionsValues(SafetyMiscConfiguration component, Options options) {
        OptionsSection section = this.getMiscOptionsSection(options);
        component.setTeachPendant(TPType.byId((int)section.getInteger(USE_TEACH_PENDANT_STR, Integer.valueOf(component.getTeachPendant().getId()))));
        component.setImmiType(ImmiType.byId((int)section.getInteger(USE_EUROMAP67_STR, Integer.valueOf(SafetyMiscConfiguration.IMMI_TYPE_DEFAULT.getId()))));
    }

    private void setOptionValues(SafetyMiscConfiguration component, Options options) {
        OptionsSection section = this.getMiscOptionsSection(options);
        section.setInteger(USE_TEACH_PENDANT_STR, Integer.valueOf(component.getTeachPendant().getId()));
        section.setInteger(USE_EUROMAP67_STR, Integer.valueOf(component.getImmiType().getId()));
    }

    private OptionsSection getMiscOptionsSection(Options options) {
        String oldSectionName;
        if (!options.hasSection(MISC_SECTION_NAME) && options.hasSection(oldSectionName = "[MiscConfiguration]")) {
            return options.getSection(oldSectionName);
        }
        return options.getSection(MISC_SECTION_NAME);
    }

    public boolean isSupported(ChecksumVersion version) {
        return true;
    }
}

