/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.impl;

import com.ur.safety.impl.VisualErrorIndicator;
import com.ur.swing.BindingRegistration;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.validation.FormValidation;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class JTextFieldVisualErrorIndicator
implements VisualErrorIndicator<JTextField> {
    protected BindingRegistration registration = BindingRegistration.NULL_REGISTRATION;
    protected String currentMessage;

    @Override
    public void showErrorMessage(final JTextField field, final String message, final FormValidation.ValidationLevel validationLevel) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTextFieldVisualErrorIndicator.this.registration.removeRegistration();
                JTextFieldVisualErrorIndicator.this.registration = validationLevel == FormValidation.ValidationLevel.Error ? DisplayMessageFactory.error((JComponent)field, (String)message) : DisplayMessageFactory.warn((JComponent)field, (String)message);
            }
        });
        this.currentMessage = message;
    }

    @Override
    public void removeErrorMessage(final JTextField field) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTextFieldVisualErrorIndicator.this.removeErrorMessageSafely(field, JTextFieldVisualErrorIndicator.this.registration);
            }
        });
        this.currentMessage = null;
    }

    protected void removeErrorMessageSafely(JTextField field, BindingRegistration registration) {
        if (registration != null) {
            registration.removeRegistration();
        }
        field.setBackground(DisplayMessageFactory.OK_COLOR);
    }

    @Override
    public String getCurrentMessage() {
        return this.currentMessage;
    }

    @Override
    public void clear() {
        this.registration.removeRegistration();
        this.currentMessage = "";
    }
}

