/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.impl;

import com.ur.lang.EqualsUtil;
import com.ur.safety.impl.JTextFieldVisualErrorIndicator;
import com.ur.safety.impl.VisualErrorIndicator;
import com.ur.swing.BindingRegistration;
import com.ur.swing.number.NumberPicker;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextPicker;
import com.ur.swing.validation.FormValidation;
import com.ur.swing.validation.ValidationStrategy;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;

public abstract class JTextFieldWithErrorIndicator
implements FormValidation.Validator,
PropertyChangeListener {
    protected final JTextField field;
    protected final JTextField limitField;
    protected FormValidation.ValidationLevel validationLevel;
    protected boolean isValid = true;
    protected boolean oldValidState = true;
    protected String newMessage;
    protected VisualErrorIndicator<JTextField> errorIndicator;
    protected final boolean displayErrorStateWhenFieldNotSelected;
    protected final boolean displayMessageWhenFieldNotSelected;
    BindingRegistration fieldSelectionRegistration = BindingRegistration.NULL_REGISTRATION;

    public JTextFieldWithErrorIndicator(JTextField field, FormValidation.ValidationLevel validationLevel, boolean displayErrorStateWhenFieldNotSelected, boolean displayMessageWhenFieldNotSelected) {
        this(field, null, validationLevel, displayErrorStateWhenFieldNotSelected, displayMessageWhenFieldNotSelected);
    }

    public JTextFieldWithErrorIndicator(JTextField field, JTextField limitField, FormValidation.ValidationLevel validationLevel, boolean displayErrorStateWhenFieldNotSelected, boolean displayMessageWhenFieldNotSelected) {
        this.field = field;
        this.limitField = limitField;
        this.validationLevel = validationLevel;
        this.displayErrorStateWhenFieldNotSelected = displayErrorStateWhenFieldNotSelected;
        this.displayMessageWhenFieldNotSelected = displayMessageWhenFieldNotSelected;
        this.fieldSelectionRegistration = TextFieldUtils.bindPropertyChangeListenerToField((JTextField)field, (String)"border", (PropertyChangeListener)this);
        this.errorIndicator = new JTextFieldVisualErrorIndicator();
    }

    public void setVisualErrorIndicator(VisualErrorIndicator<JTextField> visualErrorIndicator) {
        this.errorIndicator = visualErrorIndicator;
    }

    public abstract void validate();

    public void updateVisualErrorIndicators() {
        if (this.isValid && !this.oldValidState) {
            this.errorIndicator.removeErrorMessage(this.field);
        }
        if (!this.isValid) {
            if (this.oldValidState) {
                this.errorIndicator.showErrorMessage(this.field, this.getNewErrorMessage(), this.validationLevel);
            } else if (!EqualsUtil.equals((Object)this.errorIndicator.getCurrentMessage(), (Object)this.getNewErrorMessage())) {
                this.errorIndicator.showErrorMessage(this.field, this.getNewErrorMessage(), this.validationLevel);
            }
        }
        this.oldValidState = this.isValid;
    }

    private String getNewErrorMessage() {
        if (this.isFieldSelected(this.field) || this.isFieldSelected(this.limitField) && this.displayMessageWhenFieldNotSelected) {
            return this.newMessage;
        }
        return "";
    }

    private boolean isCaretVisible(JTextField field) {
        if (field == null) {
            return false;
        }
        Caret caret = field.getCaret();
        return caret != null && caret.isVisible();
    }

    private boolean isFieldSelected(JTextField field) {
        if (field == null) {
            return false;
        }
        return NumberPicker.isSelected((Object)field.getBorder()) || TextPicker.isSelected((Object)field.getBorder()) || this.isCaretVisible(field);
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void clearValidation() {
        this.errorIndicator.clear();
        this.fieldSelectionRegistration.removeRegistration();
        this.isValid = true;
    }

    protected boolean validateTextField(ValidationStrategy strategy) {
        String text = TextFieldUtils.getValueOrText((JTextComponent)this.field);
        return this.validateText(strategy, text);
    }

    protected boolean validateText(ValidationStrategy strategy, String text) {
        if (strategy == null) {
            return true;
        }
        boolean isTextValid = strategy.isValid(text);
        this.newMessage = !isTextValid ? strategy.getErrorMessage(text) : null;
        return isTextValid;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.isValid) {
            return;
        }
        this.showErrorMessageWhenFieldSelected(event.getNewValue());
    }

    private void showErrorMessageWhenFieldSelected(Object newBorder) {
        if (TextPicker.isSelected((Object)newBorder)) {
            this.errorIndicator.showErrorMessage(this.field, this.newMessage, this.validationLevel);
        }
    }
}

