/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.impl;

import com.ur.polyscope.safety.checksum.ActiveSafetyChecksumEvent;
import com.ur.polyscope.safety.checksum.ActiveSafetyChecksumListener;
import com.ur.polyscope.safety.checksum.ChecksumService;
import com.ur.safety.SafetyActionFactory;
import com.ur.safety.ShowActiveSafetyLimitsAction;
import com.ur.safety.checksum.SafetyChecksumIcon;
import com.ur.swing.MouseEventActionWrapper;
import com.ur.swing.WidgetFactory;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.MenuExtension;
import com.ur.util.event.EventNotificationService;
import java.awt.Dimension;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;

@Singleton
@Extension(value="HeaderMenu")
public class SafetyButtonFactoryImpl
implements SafetyActionFactory,
MenuExtension,
ActiveSafetyChecksumListener {
    public static final int ICON_BORDER_WIDTH = 16;
    private Provider<ShowActiveSafetyLimitsAction> showActiveSafetyLimitsActionProvider;
    private WidgetFactory widgetFactory;
    private ChecksumService checksumService;
    private JButton checksumButton;

    @Inject
    private SafetyButtonFactoryImpl(Provider<ShowActiveSafetyLimitsAction> showActiveSafetyLimitsActionProvider, WidgetFactory widgetFactory, ChecksumService checksumService) {
        this.showActiveSafetyLimitsActionProvider = showActiveSafetyLimitsActionProvider;
        this.widgetFactory = widgetFactory;
        this.checksumService = checksumService;
        EventNotificationService.register((Object)this, ActiveSafetyChecksumListener.class, (Object)this);
    }

    @Override
    public Action createShowActiveSafetyLimitsAction(JComponent component) {
        return this.wrapActionWithMouseListener(component);
    }

    private Action wrapActionWithMouseListener(JComponent component) {
        ShowActiveSafetyLimitsAction action = (ShowActiveSafetyLimitsAction)this.showActiveSafetyLimitsActionProvider.get();
        action.setComponent(component);
        return new MouseEventActionWrapper((Action)action);
    }

    public MenuExtension.MenuContribution create() {
        final ShowActiveSafetyLimitsAction showActiveSafetyLimitsAction = (ShowActiveSafetyLimitsAction)this.showActiveSafetyLimitsActionProvider.get();
        return MenuExtension.MenuContribution.locateMiddle((MenuExtension.MenuContribution)new MenuExtension.MenuContribution(showActiveSafetyLimitsAction){

            public JComponent createComponent(Action action) {
                SafetyButtonFactoryImpl.this.checksumButton = SafetyButtonFactoryImpl.this.widgetFactory.createButton(action);
                showActiveSafetyLimitsAction.setComponent(SafetyButtonFactoryImpl.this.checksumButton);
                SafetyButtonFactoryImpl.this.checksumButton.setName("activeSafetyLimits.SafetyActionFactory");
                SafetyButtonFactoryImpl.this.checksumButton.setPreferredSize(new Dimension(SafetyButtonFactoryImpl.this.getChecksumWidth(), 64));
                return SafetyButtonFactoryImpl.this.widgetFactory.createButtonFunction((AbstractButton)SafetyButtonFactoryImpl.this.checksumButton);
            }
        });
    }

    public void activeSafetyChecksumChanged(ActiveSafetyChecksumEvent activeSafetyChecksumEvent) {
        this.checksumButton.setPreferredSize(new Dimension(this.getChecksumWidth(), 64));
    }

    private int getChecksumWidth() {
        return new SafetyChecksumIcon(this.checksumService.getActiveSafetyChecksum()).getIconWidth() + 16;
    }
}

