/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.impl;

import com.ur.polyscope.installation.InstallationComponentConversionStrategy;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.persistence.OptionsSection;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.checksum.VersionComponent;
import com.ur.safety.SafetySettingsLookupService;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;

public class SafetySettingsConversionStrategy
extends ConversionStrategyTemplate<SafetySetup>
implements InstallationComponentConversionStrategy<SafetySetup> {
    public static final String SAFETY_SETTINGS = "SafetySettings";
    private final SafetySettingsLookupService lookupService;
    private final Provider<SafetySetup> safetySetupProvider;

    @Inject
    public SafetySettingsConversionStrategy(SafetySettingsLookupService lookupService, Provider<SafetySetup> safetySetupProvider) {
        super(SafetySetup.class);
        this.lookupService = lookupService;
        this.safetySetupProvider = safetySetupProvider;
    }

    public void marshal(SafetySetup safetySetup, PersistWriter writer) {
        Options options = new Options();
        safetySetup.copyTo(options);
        OptionsSection safetyChecksum = options.getSection("Safety Checksum");
        safetyChecksum.setString("crc", this.lookupService.generateChecksum(safetySetup));
        safetyChecksum.setString("version", ((VersionComponent)safetySetup.getComponent(VersionComponent.class)).getChecksumVersion().toString());
        writer.addValue(options);
    }

    public SafetySetup unmarshal(PersistReader reader) {
        SafetySetup result = (SafetySetup)this.safetySetupProvider.get();
        Options safetyOptions = reader.getOptionsValue();
        result.readFrom(safetyOptions);
        return result;
    }

    public Map<String, Class<? extends SafetySetup>> getClassAliases(boolean forMarshalling) {
        return new HashMap<String, Class<? extends SafetySetup>>(){
            {
                this.put(SafetySettingsConversionStrategy.SAFETY_SETTINGS, SafetySetup.class);
            }
        };
    }
}

