/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.impl;

import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.SafetySetupContribution;
import com.ur.polyscope.safety.checksum.VersionComponent;
import com.ur.polyscope.safety.version.SafetyControlBoardVersionSite;
import com.ur.safety.Settings;
import com.ur.safety.misc.core.SafetyMiscConfiguration;
import com.ur.safety.threepositionenabling.application.ThreePositionEnablingConfiguration;
import com.ur.view.constants.dev.TPType;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;

public class SafetySetupProviderImpl
implements Provider<SafetySetup> {
    private final SafetyControlBoardVersionSite versionSite;
    private final Set<SafetySetupContribution> contributions;

    @Inject
    public SafetySetupProviderImpl(SafetyControlBoardVersionSite versionSite, Set<SafetySetupContribution> contributions) {
        this.versionSite = versionSite;
        this.contributions = contributions;
    }

    public SafetySetup get() {
        SafetySetup safetySetup = new SafetySetup(this.versionSite, this.contributions);
        SafetySetupProviderImpl.syncUseTP3PESafetySetting(safetySetup);
        ((VersionComponent)safetySetup.getComponent(VersionComponent.class)).setChecksumVersion(Settings.getLatestChecksumVersion());
        return safetySetup;
    }

    private static void syncUseTP3PESafetySetting(SafetySetup safetySetup) {
        ThreePositionEnablingConfiguration threePositionEnablingConfiguration = (ThreePositionEnablingConfiguration)safetySetup.getComponent(ThreePositionEnablingConfiguration.class);
        SafetyMiscConfiguration safetyMiscConfiguration = (SafetyMiscConfiguration)safetySetup.getComponent(SafetyMiscConfiguration.class);
        threePositionEnablingConfiguration.setUseTp3pe(safetyMiscConfiguration.getTeachPendant() == TPType.THREE_POSITION_ENABLING);
    }
}

