/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.impl;

import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.operationalmode.SafetyOperationalMode;
import com.ur.polyscope.security.AccessControlStateListener;
import com.ur.polyscope.security.OperationalModeSource;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.security.UserAccessState;
import com.ur.polyscope.viewfacade.safety.SafetyOperationalModeService;
import com.ur.safety.SafetyChangeListener;
import com.ur.util.event.EventManager;
import com.ur.view.constants.dev.OperationalMode;
import javax.inject.Inject;

public class SynchronizeWithSafetyOperationalMode {
    private final SafetyOperationalModeService safetyOperationalModeService;
    private final UserAccessControl userAccessControl;

    @Inject
    public SynchronizeWithSafetyOperationalMode(EventManager eventManager, SafetyOperationalModeService safetyOperationalModeService, UserAccessControl userAccessControl) {
        this.safetyOperationalModeService = safetyOperationalModeService;
        this.userAccessControl = userAccessControl;
        this.setupEventListeners(eventManager);
    }

    private void setupEventListeners(EventManager eventManager) {
        eventManager.addStrongListener(SafetyChangeListener.class, (Object)new SafetyChangeListener.Template(){

            @Override
            public void safetyRequestedToBeApplied(SafetySetup setup) {
                SynchronizeWithSafetyOperationalMode.this.safetyChanged();
            }

            @Override
            public void safetyOnControllerConfirmed(SafetySetup setup) {
                SynchronizeWithSafetyOperationalMode.this.safetyChanged();
            }
        });
        eventManager.addStrongListener(SafetyOperationalModeService.OperationalModeListener.class, (oldValue, newValue) -> this.updateAccessControlState(newValue));
        eventManager.addStrongListener(AccessControlStateListener.class, (oldState, currentState) -> this.updateSafetyOperationalMode(currentState));
    }

    private void safetyChanged() {
        if (this.safetyOperationalModeService.isUIDriven()) {
            this.userAccessControl.setActive(OperationalModeSource.SAFETY_UI);
            this.userAccessControl.setInactive(OperationalModeSource.SAFETY_IO);
            this.userAccessControl.setInactive(OperationalModeSource.SAFETY_PROFISAFE);
            this.updateSafetyOperationalMode(this.userAccessControl.getCurrentState());
        } else if (this.safetyOperationalModeService.isProfiSafeDriven() && this.safetyOperationalModeService.isThreePositionDeviceEnabled()) {
            this.userAccessControl.setActive(OperationalModeSource.SAFETY_PROFISAFE);
            this.userAccessControl.setActive(OperationalModeSource.SAFETY_UI);
            this.userAccessControl.setInactive(OperationalModeSource.SAFETY_IO);
            this.updateAccessControlState(this.safetyOperationalModeService.getSafetyOperationalMode());
        } else if (this.safetyOperationalModeService.isProfiSafeDriven()) {
            this.userAccessControl.setInactive(OperationalModeSource.SAFETY_UI);
            this.userAccessControl.setInactive(OperationalModeSource.SAFETY_IO);
            this.userAccessControl.setActive(OperationalModeSource.SAFETY_PROFISAFE);
            this.updateAccessControlState(this.safetyOperationalModeService.getSafetyOperationalMode());
        } else if (this.safetyOperationalModeService.isIODriven() && this.safetyOperationalModeService.isThreePositionDeviceEnabled()) {
            this.userAccessControl.setInactive(OperationalModeSource.SAFETY_PROFISAFE);
            this.userAccessControl.setActive(OperationalModeSource.SAFETY_UI);
            this.userAccessControl.setActive(OperationalModeSource.SAFETY_IO);
            this.updateAccessControlState(this.safetyOperationalModeService.getSafetyOperationalMode());
        } else if (this.safetyOperationalModeService.isIODriven()) {
            this.userAccessControl.setInactive(OperationalModeSource.SAFETY_UI);
            this.userAccessControl.setInactive(OperationalModeSource.SAFETY_PROFISAFE);
            this.userAccessControl.setActive(OperationalModeSource.SAFETY_IO);
            this.updateAccessControlState(this.safetyOperationalModeService.getSafetyOperationalMode());
        } else {
            this.userAccessControl.setInactive(OperationalModeSource.SAFETY_UI);
            this.userAccessControl.setInactive(OperationalModeSource.SAFETY_IO);
            this.userAccessControl.setInactive(OperationalModeSource.SAFETY_PROFISAFE);
        }
    }

    private void updateSafetyOperationalMode(UserAccessState currentState) {
        if (this.safetyOperationalModeService.isUIDriven()) {
            this.setUiDrivenSafetyOperationalMode(currentState.getOperationalMode());
        } else if (!this.safetyOperationalModeService.isIODriven() || !this.safetyOperationalModeService.isProfiSafeDriven()) {
            this.safetyOperationalModeService.setSafetyOperationalMode(SafetyOperationalMode.NONE);
        }
    }

    private void setUiDrivenSafetyOperationalMode(OperationalMode operationalMode) {
        if (OperationalMode.AUTOMATIC == operationalMode) {
            this.safetyOperationalModeService.setSafetyOperationalMode(SafetyOperationalMode.AUTOMATIC);
        } else if (OperationalMode.MANUAL == operationalMode) {
            this.safetyOperationalModeService.setSafetyOperationalMode(SafetyOperationalMode.MANUAL);
        }
    }

    private void updateAccessControlState(SafetyOperationalMode newValue) {
        if (this.safetyOperationalModeService.isIODriven()) {
            this.setOperationalMode(newValue, OperationalModeSource.SAFETY_IO);
        } else if (this.safetyOperationalModeService.isProfiSafeDriven()) {
            this.setOperationalMode(newValue, OperationalModeSource.SAFETY_PROFISAFE);
        }
    }

    private void setOperationalMode(SafetyOperationalMode newValue, OperationalModeSource operationalModeSource) {
        switch (newValue) {
            case AUTOMATIC: {
                this.userAccessControl.setOperationalMode(operationalModeSource, OperationalMode.AUTOMATIC);
                break;
            }
            case MANUAL: {
                this.userAccessControl.setOperationalMode(operationalModeSource, OperationalMode.MANUAL);
                break;
            }
        }
    }
}

