/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.installation;

import com.ur.injection.Builder;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.safety.SafetySettingsCaretaker;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.viewfacade.safety.InitializeRobotListener;
import com.ur.polyscope.viewfacade.safety.RobotInstallationPersistenceService;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.safety.installation.FinalizeCreationOfSafety;
import com.ur.safety.misc.core.SafetyMiscConfiguration;
import com.ur.view.constants.immi.ImmiType;
import javax.inject.Inject;
import javax.inject.Provider;

public class CreateDefaultSafetyOnInitializeRobotListener
implements InitializeRobotListener {
    private final RobotInstallationSite installationSite;
    private final Builder builder;
    private final Provider<JointConfigurationSettings> configurationSettingsProvider;
    private final SafetySettingsLookupService safetyLookupService;
    private final RobotInstallationPersistenceService persistenceService;

    @Inject
    private CreateDefaultSafetyOnInitializeRobotListener(RobotInstallationSite installationSite, Builder builder, Provider<JointConfigurationSettings> configurationSettingsProvider, SafetySettingsLookupService safetySettingsLookupService, RobotInstallationPersistenceService persistenceService) {
        this.installationSite = installationSite;
        this.builder = builder;
        this.configurationSettingsProvider = configurationSettingsProvider;
        this.safetyLookupService = safetySettingsLookupService;
        this.persistenceService = persistenceService;
    }

    public void initializeRobot(boolean euromapEnabled) {
        JointConfigurationSettings configurationSettings = (JointConfigurationSettings)this.configurationSettingsProvider.get();
        Installation newInstallation = (Installation)this.builder.get(Installation.class);
        SafetySetup safetySetup1 = (SafetySetup)newInstallation.getComponent(SafetySetup.class);
        ((SafetyLimitsComponent)safetySetup1.getComponent(SafetyLimitsComponent.class)).initJointsLimitstoDefaultValues(configurationSettings);
        ((SafetyMiscConfiguration)safetySetup1.getComponent(SafetyMiscConfiguration.class)).setImmiType(euromapEnabled ? ImmiType.E67 : ImmiType.NOT_PRESENT);
        new FinalizeCreationOfSafety(this.safetyLookupService).postCreate(newInstallation);
        this.persistenceService.save(newInstallation);
        this.installationSite.setInstallation(newInstallation);
        this.safetyLookupService.getCaretaker().applyChangesToController(SafetySettingsCaretaker.AskUserToApply.NO_CONFIRMATION, false);
    }
}

