/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.installation;

import com.ur.i18n.TextResource;
import com.ur.lang.EqualsUtil;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.installation.domain.SetInstallationValidator;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.RobotTool;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.generallimits.core.SafetyLimits;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.swing.dialog.ErrorMessage;
import gui.main.URGUI;
import javax.inject.Inject;

public class JointPositionRobotCompatibilityValidator
implements SetInstallationValidator {
    private static final String DEFAULT_INSTALLATION_BACKUP_FILE_NAME = "default.installation.problem";
    private static final double JOINT_POSITION_LIMIT_CHECK_TOLERANCE = Math.toRadians(0.5);
    private final RobotTool robotTool;
    private final JointConfigurationSettings jointSettings;
    private final TextResource textResource;

    @Inject
    JointPositionRobotCompatibilityValidator(RobotConfigurationProvider robot, JointConfigurationSettings jointSettings, TextResource textResource) {
        this.robotTool = robot.getRobotTool();
        this.jointSettings = jointSettings;
        this.textResource = textResource;
    }

    public SetInstallationValidator.Validity validate(Installation toValidate) {
        SafetySetup safetySetup = (SafetySetup)toValidate.getComponent(SafetySetup.class);
        if (!this.robotTool.isInfiniteRevolutionsWrist3Allowed() && !this.hasValidJoints(safetySetup)) {
            return SetInstallationValidator.Validity.ERROR;
        }
        return SetInstallationValidator.Validity.VALID;
    }

    private boolean hasValidJoints(SafetySetup safetySetup) {
        JointType[] jointTypeArray = JointType.values();
        int n = jointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JointType jointType = jointTypeArray[n2];
            if (!((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class)).getWithPositionLimits(jointType) || !this.isMinAndMaxJointLimitsValid(safetySetup, jointType)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isMinAndMaxJointLimitsValid(SafetySetup safetySetup, JointType jointType) {
        SafetyLimits normalLimits = ((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class)).getNormalLimits();
        SafetyLimits reducedLimits = ((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class)).getReducedLimits();
        double defaultMininumLimit = this.jointSettings.getMinimumJointLimit(jointType) - JOINT_POSITION_LIMIT_CHECK_TOLERANCE;
        double defaultMaximumLimit = this.jointSettings.getMaximumJointLimit(jointType) + JOINT_POSITION_LIMIT_CHECK_TOLERANCE;
        return normalLimits.getMinJointPosition(jointType).getTotalAngle() >= defaultMininumLimit && normalLimits.getMaxJointPosition(jointType).getTotalAngle() <= defaultMaximumLimit && reducedLimits.getMinJointPosition(jointType).getTotalAngle() >= defaultMininumLimit && reducedLimits.getMaxJointPosition(jointType).getTotalAngle() <= defaultMaximumLimit;
    }

    public ErrorMessage jointPositionLimitsIncompatibleWithRobotType() {
        return new ErrorMessage(this.textResource.jointPositionLimitsIncompatibleWithRobotTypeTitle(), this.textResource.jointPositionLimitsIncompatibleWithRobotTypeExplanation());
    }

    public ErrorMessage jointPositionLimitsIncompatibleWithRobotType(String fileName, String backupFileName) {
        return new ErrorMessage(this.textResource.jointPositionLimitsIncompatibleWithRobotTypeTitle(), this.textResource.jointPositionLimitsInDefaultInstallationIncompatibleWithRobotTypeExplanation(fileName, backupFileName));
    }

    public ErrorMessage getErrorMessage(Installation toValidate) {
        if (!URGUI.isInitialized() && EqualsUtil.equals((Object)((PersistanceMetaData)toValidate.getMetaData(PersistanceMetaData.class)).fileName(), (Object)"default")) {
            return this.jointPositionLimitsIncompatibleWithRobotType("default", DEFAULT_INSTALLATION_BACKUP_FILE_NAME);
        }
        return this.jointPositionLimitsIncompatibleWithRobotType();
    }
}

