/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.installation;

import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.domain.PostSetInstallation;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.polyscope.safety.SafetySettingsCaretaker;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.misc.core.SafetyMiscConfiguration;
import com.ur.util.event.EventManager;
import com.ur.util.event.NotificationStrategy;
import com.ur.view.constants.immi.ImmiType;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.inject.Inject;
import javax.inject.Provider;

public class NotifySafetyListenersOnPostSetInstallation
implements PostSetInstallation {
    private final EventManager manager;
    private final Provider<SafetySettingsCaretaker> caretaker;
    private final Provider<RobotIdentification> robotIdentificationSpecification;

    @Inject
    NotifySafetyListenersOnPostSetInstallation(EventManager manager, Provider<SafetySettingsCaretaker> caretaker, Provider<RobotIdentification> robotIdentificationSpecification) {
        this.manager = manager;
        this.caretaker = caretaker;
        this.robotIdentificationSpecification = robotIdentificationSpecification;
    }

    public void postLoad(final Installation newInstallation) {
        if (newInstallation != null) {
            SafetySetup safetySetup = (SafetySetup)newInstallation.getComponent(SafetySetup.class);
            safetySetup.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    NotifySafetyListenersOnPostSetInstallation.this.manager.fireEvent(InstallationStateListener.class, (NotificationStrategy)new NotificationStrategy<InstallationStateListener>(){

                        public void notify(InstallationStateListener listener) {
                            listener.installationModified();
                        }
                    });
                }
            });
        }
        this.manager.fireEvent(SafetyChangeListener.class, (NotificationStrategy)new NotificationStrategy<SafetyChangeListener>(){

            public void notify(SafetyChangeListener listener) {
                SafetySetup safetySetup = (SafetySetup)newInstallation.getComponent(SafetySetup.class);
                listener.safetyLoaded(safetySetup);
            }
        });
        if (((RobotIdentification)this.robotIdentificationSpecification.get()).isSpecified()) {
            ((SafetySettingsCaretaker)this.caretaker.get()).applyChangesToController(SafetySettingsCaretaker.AskUserToApply.NO_CONFIRMATION, false);
        }
    }

    protected boolean isImmiEnabled(SafetySetup safetySetup) {
        return !((SafetyMiscConfiguration)safetySetup.getComponent(SafetyMiscConfiguration.class)).getImmiType().equals((Object)ImmiType.NOT_PRESENT);
    }
}

