/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.installation;

import com.ur.i18n.TextResource;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.installation.domain.SetInstallationValidator;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.checksum.VersionComponent;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.installation.UpgradeStrategy;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.util.logging.Log;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;

public class UpgradeChainOnSetInstallationValidator
implements SetInstallationValidator {
    private final SortedSet<UpgradeStrategy> upgradeStrategies;
    private final SafetySettingsLookupService lookupService;
    private final TextResource textResource;

    @Inject
    UpgradeChainOnSetInstallationValidator(Set<UpgradeStrategy> strategies, SafetySettingsLookupService lookupService, TextResource textResource) {
        this.lookupService = lookupService;
        this.textResource = textResource;
        this.upgradeStrategies = new TreeSet<UpgradeStrategy>(new UpgradeStrategyComparator());
        this.upgradeStrategies.addAll(strategies);
    }

    public SetInstallationValidator.Validity validate(Installation toValidate) {
        SafetySetup safetySetup = (SafetySetup)toValidate.getComponent(SafetySetup.class);
        if (!this.isMatchingCRCs(toValidate)) {
            return SetInstallationValidator.Validity.ERROR;
        }
        for (UpgradeStrategy each : this.upgradeStrategies) {
            if (((VersionComponent)safetySetup.getComponent(VersionComponent.class)).getChecksumVersion().atLeast(each.getStrategyVersion()) || each.upgrade(safetySetup)) continue;
            return SetInstallationValidator.Validity.DECLINED;
        }
        return SetInstallationValidator.Validity.VALID;
    }

    private ErrorMessage checksumFailedWhenLoadingSafetySettings() {
        return new ErrorMessage(this.textResource.errorChecksumFailedWhenLoadingSafetySettingsTitle(), this.textResource.errorChecksumFailedWhenLoadingSafetySettingsExplanation());
    }

    public ErrorMessage getErrorMessage(Installation toValidate) {
        return this.checksumFailedWhenLoadingSafetySettings();
    }

    protected boolean isMatchingCRCs(Installation toValidate) {
        String generatedCRC;
        SafetySetup safetySetup = (SafetySetup)toValidate.getComponent(SafetySetup.class);
        String loadedCRC = ((VersionComponent)safetySetup.getComponent(VersionComponent.class)).getLoadedCRCValue();
        boolean result = EqualsUtil.equals((Object)loadedCRC, (Object)(generatedCRC = this.lookupService.generateChecksum(safetySetup)));
        if (!result) {
            Log.warning((String)("Failed loading installation " + ((PersistanceMetaData)toValidate.getMetaData(PersistanceMetaData.class)).fileName() + "\n   Expected CRC: '" + loadedCRC + "'" + "\n   but was:      '" + generatedCRC + "'"));
        }
        return result;
    }

    private static class UpgradeStrategyComparator
    implements Comparator<UpgradeStrategy> {
        private UpgradeStrategyComparator() {
        }

        @Override
        public int compare(UpgradeStrategy o1, UpgradeStrategy o2) {
            return o1.getStrategyVersion().compareTo((Enum)o2.getStrategyVersion());
        }
    }
}

