/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.installation.impl;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.polyscope.safety.checksum.VersionComponent;
import com.ur.polyscope.safety.version.SafetyControlBoardVersionSite;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.installation.UpgradeStrategy;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.OkDialogListener;
import javax.inject.Inject;

public class UpgradeTo3_2Strategy
implements UpgradeStrategy {
    private final SafetySettingsLookupService safetyLookup;
    private SafetyControlBoardVersionSite versionSite;
    private final SafetyTextResource textResource;
    private final ErrorDialogCreator dialogCreator;

    @Inject
    public UpgradeTo3_2Strategy(SafetySettingsLookupService safetyLookup, SafetyControlBoardVersionSite versionSite, SafetyTextResource textResource, ErrorDialogCreator dialogCreator) {
        this.safetyLookup = safetyLookup;
        this.versionSite = versionSite;
        this.textResource = textResource;
        this.dialogCreator = dialogCreator;
    }

    @Override
    public ChecksumVersion getStrategyVersion() {
        return ChecksumVersion.VERSION_3_2;
    }

    @Override
    public boolean upgrade(SafetySetup safetySetup) {
        String thisCrc;
        ChecksumVersion checksumVersion = ((VersionComponent)safetySetup.getComponent(VersionComponent.class)).getChecksumVersion();
        String loadedCRCValue = ((VersionComponent)safetySetup.getComponent(VersionComponent.class)).getLoadedCRCValue();
        boolean isValid = EqualsUtil.equals((Object)loadedCRCValue, (Object)(thisCrc = this.safetyLookup.generateChecksum(safetySetup)));
        if (isValid && checksumVersion.equals((Object)ChecksumVersion.VERSION_1_0)) {
            ((VersionComponent)safetySetup.getComponent(VersionComponent.class)).setChecksumVersion(this.versionSite.getSafetyFeatureSupport().latestChecksum());
            ((VersionComponent)safetySetup.getComponent(VersionComponent.class)).setCRCValue(this.safetyLookup.generateChecksum(safetySetup));
        }
        if (!isValid) {
            this.informUserOfCorruptedSafetySetup();
        }
        return isValid;
    }

    public ErrorMessage checksumFailedWhenLoadingSafetySettings() {
        return new ErrorMessage(this.textResource.errorChecksumFailedWhenLoadingSafetySettingsTitle(), this.textResource.errorChecksumFailedWhenLoadingSafetySettingsExplanation());
    }

    void informUserOfCorruptedSafetySetup() {
        this.dialogCreator.showErrorDialog(this.checksumFailedWhenLoadingSafetySettings(), new OkDialogListener());
    }
}

