/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.installation.impl;

import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.SafetySetupComponent;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.impl.SafetyConfirmationMessageProvider;
import com.ur.safety.installation.SafetySetupConverter;
import com.ur.safety.installation.UpgradeStrategy;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.InformationMessage;
import gui.tools.LegacyURDialogCreator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public class UpgradeToG5Strategy
implements UpgradeStrategy {
    private final SafetySettingsLookupService lookupService;
    private final SafetyConfirmationMessageProvider safetyConfirmationMessageProvider;
    private final Set<SafetySetupConverter> converters;
    private final SafetyTextResource safetyTextResource;

    @Inject
    private UpgradeToG5Strategy(SafetySettingsLookupService lookupService, SafetyConfirmationMessageProvider safetyConfirmationMessageProvider, Set<SafetySetupConverter> converters, SafetyTextResource safetyTextResource) {
        this.lookupService = lookupService;
        this.safetyConfirmationMessageProvider = safetyConfirmationMessageProvider;
        this.converters = converters;
        this.safetyTextResource = safetyTextResource;
    }

    @Override
    public ChecksumVersion getStrategyVersion() {
        return ChecksumVersion.VERSION_5_0;
    }

    @Override
    public boolean upgrade(SafetySetup safetySetup) {
        boolean performConversion = this.confirmConversionOfSafetyToG5(safetySetup);
        if (performConversion) {
            this.performConversionOfSafety(safetySetup);
        }
        return performConversion;
    }

    private boolean confirmConversionOfSafetyToG5(SafetySetup safetySetup) {
        if (!this.lookupService.getControllerSafetySetup().isPresent()) {
            InformationMessage message = this.safetyConfirmationMessageProvider.informConvertSafetyToG5OrUseLoaded(this.getAffectedG3SafetyItems(safetySetup));
            return LegacyURDialogCreator.informMessageDialog((InformationMessage)message) == DialogReturnValue.OK;
        }
        ConfirmationMessage message = this.safetyConfirmationMessageProvider.confirmConvertSafetyToG5OrUseLoaded(this.getAffectedG3SafetyItems(safetySetup));
        return LegacyURDialogCreator.confirmMessageDialog((ConfirmationMessage)message) == DialogReturnValue.OK;
    }

    private void performConversionOfSafety(SafetySetup safetySetup) {
        for (SafetySetupConverter each : this.converters) {
            each.convertToG5(safetySetup.getComponent(each.getComponentType()));
        }
    }

    private List<String> getAffectedG3SafetyItems(SafetySetup safetySetup) {
        ArrayList<String> unsupportedItems = new ArrayList<String>();
        for (SafetySetupConverter each : this.converters) {
            SafetySetupComponent component = safetySetup.getComponent(each.getComponentType());
            unsupportedItems.addAll(each.getAffectedG3SafetyItems(component, this.safetyTextResource));
        }
        return unsupportedItems;
    }
}

