/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io;

import com.ur.bean.URPropertyChangeSupport;
import com.ur.lang.EqualsBuilder;
import com.ur.lang.EqualsUtil;
import com.ur.lang.HashCodeBuilder;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.safety.io.IOActionPinUnassigner;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.io.SafetyIOInputFunction;
import com.ur.safety.io.SafetyIOOutputFunction;
import com.ur.util.logging.Log;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;

public abstract class AbstractSafetyIOConfiguration
implements SafetyIOConfiguration {
    private final transient URPropertyChangeSupport changeSupport;
    private final transient IOActionPinUnassigner ioActionUnassigner;
    private final IOPair[] inputs = new IOPair[SafetyIOInputFunction.values().length];
    private final IOPair[] outputs = new IOPair[SafetyIOOutputFunction.values().length];

    public AbstractSafetyIOConfiguration(IOActionPinUnassigner inputActionUnassigner) {
        this.changeSupport = new URPropertyChangeSupport((Object)this);
        this.ioActionUnassigner = inputActionUnassigner;
        this.initializeInputs();
        this.initializeOutputs();
    }

    private void setupSafeguardStopReset() {
        this.inputs[SafetyIOInputFunction.SAFEGUARD_STOP_RESET.ordinal()] = new IOPair(0, 1);
    }

    private void initializeOutputs() {
        int i = 0;
        while (i < SafetyIOOutputFunction.values().length) {
            this.outputs[i] = IOPair.UNASSIGNED;
            ++i;
        }
    }

    private void initializeInputs() {
        int i = 0;
        while (i < SafetyIOInputFunction.values().length) {
            this.inputs[i] = IOPair.UNASSIGNED;
            ++i;
        }
        this.setupSafeguardStopReset();
    }

    @Override
    public IOPair getInput(SafetyIOInputFunction option) {
        return this.inputs[option.ordinal()];
    }

    @Override
    public void setInput(IOPair newValue, SafetyIOInputFunction function) {
        if (function == SafetyIOInputFunction.UNASSIGNED) {
            this.removeInput(newValue);
            this.fireEvent(new PropertyChangeEvent(this, function.getProperty(), newValue, IOPair.UNASSIGNED));
        } else {
            IOPair oldValue = this.inputs[function.ordinal()];
            this.ioActionUnassigner.unassignInputActionPair(newValue);
            this.removeInput(newValue);
            Log.debug((String)newValue.toString());
            this.inputs[function.ordinal()] = newValue;
            this.fireEvent(new PropertyChangeEvent(this, function.getProperty(), oldValue, newValue));
        }
    }

    @Override
    public IOPair getOutput(SafetyIOOutputFunction option) {
        return this.outputs[option.ordinal()];
    }

    @Override
    public void setOutput(IOPair newValue, SafetyIOOutputFunction function) {
        if (function == SafetyIOOutputFunction.UNASSIGNED) {
            SafetyIOOutputFunction removeOutput = this.removeOutput(newValue);
            this.fireEvent(new PropertyChangeEvent(this, removeOutput.getProperty(), newValue, IOPair.UNASSIGNED));
        } else {
            IOPair oldValue = this.outputs[function.ordinal()];
            this.ioActionUnassigner.unassignOutputActionPair(newValue);
            this.removeOutput(newValue);
            Log.debug((String)newValue.toString());
            this.outputs[function.ordinal()] = newValue;
            this.fireEvent(new PropertyChangeEvent(this, function.getProperty(), oldValue, newValue));
        }
    }

    protected void removeSafeHome(Set<SafetyIOOutputFunction> result) {
        result.remove((Object)SafetyIOOutputFunction.SAFE_HOME);
    }

    @Override
    public IOPair getEmergencyStopInputs() {
        return this.inputs[SafetyIOInputFunction.EMERGENCY_STOP.ordinal()];
    }

    @Override
    public IOPair getReducedModeInputs() {
        return this.inputs[SafetyIOInputFunction.REDUCED_MODE.ordinal()];
    }

    @Override
    public IOPair getSafeguardStopResetInputs() {
        return this.inputs[SafetyIOInputFunction.SAFEGUARD_STOP_RESET.ordinal()];
    }

    @Override
    public IOPair getThreePositionEnablingInputs() {
        return this.inputs[SafetyIOInputFunction.THREE_POSITION_ENABLING_INPUT.ordinal()];
    }

    @Override
    public IOPair getOperationalModeInputs() {
        return this.inputs[SafetyIOInputFunction.OPERATIONAL_MODE_INPUT.ordinal()];
    }

    @Override
    public IOPair getAutomaticModeSafeguardStopInputs() {
        return this.inputs[SafetyIOInputFunction.AUTOMATIC_MODE_SAFEGUARD_STOP.ordinal()];
    }

    @Override
    public IOPair getAutomaticModeSafeguardStopResetInputs() {
        return this.inputs[SafetyIOInputFunction.AUTOMATIC_MODE_SAFEGUARD_STOP_RESET.ordinal()];
    }

    @Override
    public IOPair getFreedriveOnRobotInputs() {
        return this.inputs[SafetyIOInputFunction.FREEDRIVE_ON_ROBOT_INPUT.ordinal()];
    }

    @Override
    public IOPair getSystemEmergencyStopOutputs() {
        return this.outputs[SafetyIOOutputFunction.SYSTEM_EMERGENCY_STOP.ordinal()];
    }

    @Override
    public IOPair getNotReducedModeOutputs() {
        return this.outputs[SafetyIOOutputFunction.NOT_REDUCED_MODE.ordinal()];
    }

    @Override
    public IOPair getReducedModeOutputs() {
        return this.outputs[SafetyIOOutputFunction.REDUCED_MODE.ordinal()];
    }

    @Override
    public IOPair getRobotNotStoppingOutputs() {
        return this.outputs[SafetyIOOutputFunction.ROBOT_NOT_STOPPING.ordinal()];
    }

    @Override
    public IOPair getRobotMovingOutputs() {
        return this.outputs[SafetyIOOutputFunction.ROBOT_MOVING.ordinal()];
    }

    @Override
    public IOPair getSafeHomeOutputs() {
        return this.outputs[SafetyIOOutputFunction.SAFE_HOME.ordinal()];
    }

    @Override
    public IOPair getThreePositionEnablingStopOutputs() {
        return this.outputs[SafetyIOOutputFunction.THREE_POSITION_ENABLING_STOP.ordinal()];
    }

    @Override
    public IOPair getNoThreePositionEnablingStopOutputs() {
        return this.outputs[SafetyIOOutputFunction.NO_THREE_POSITION_ENABLING_STOP.ordinal()];
    }

    private SafetyIOInputFunction removeInput(IOPair toRemove) {
        int originalFunction = this.internalRemovePair(this.inputs, toRemove);
        return SafetyIOInputFunction.values()[originalFunction];
    }

    @Override
    public boolean isInputAssigned(int pin) {
        return this.internalIsAssigned(this.inputs, pin);
    }

    @Override
    public boolean isOutputAssigned(int pin) {
        return this.internalIsAssigned(this.outputs, pin);
    }

    private SafetyIOOutputFunction removeOutput(IOPair toRemove) {
        int originalFunction = this.internalRemovePair(this.outputs, toRemove);
        return SafetyIOOutputFunction.values()[originalFunction];
    }

    private int internalRemovePair(IOPair[] pairs, IOPair toRemove) {
        int i = 0;
        while (i < pairs.length) {
            if (pairs[i].hasPin(toRemove.getA())) {
                pairs[i] = IOPair.UNASSIGNED;
                return i;
            }
            ++i;
        }
        return 0;
    }

    private boolean internalIsAssigned(IOPair[] pairs, int pin) {
        IOPair[] iOPairArray = pairs;
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            IOPair pair = iOPairArray[n2];
            if (pair.hasPin(pin)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isReducedModeDefined() {
        return !this.getReducedModeInputs().isUnassigned();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void fireEvent(PropertyChangeEvent evt) {
        this.changeSupport.firePropertyChange(evt);
    }

    public int hashCode() {
        return new HashCodeBuilder(URMath.HASH_CODE_PRECISION).reflectHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return new EqualsBuilder(1.0E-5).isEquals((Object)this, obj);
    }

    public boolean completelyEquals(Object other) {
        return this.equals(other);
    }

    public static class IOPair {
        public static final IOPair UNASSIGNED = new IOPair(255, 255);
        private final int a;
        private final int b;

        public IOPair(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public IOPair(IOPair pairToClone) {
            this.a = pairToClone.getA();
            this.b = pairToClone.getB();
        }

        public boolean hasPin(int pin) {
            return this.a == pin || this.b == pin;
        }

        public int getA() {
            return this.a;
        }

        public int getB() {
            return this.b;
        }

        public String toString() {
            return "Pair [" + this.a + ", " + this.b + "]";
        }

        public int hashCode() {
            return (this.a * 3 + this.b * 7) / 11;
        }

        public boolean equals(Object obj) {
            if (obj == null || !EqualsUtil.equals(obj.getClass(), IOPair.class)) {
                return false;
            }
            IOPair other = (IOPair)obj;
            return this.a == other.a && this.b == other.b;
        }

        public boolean isUnassigned() {
            return this.getA() == 255 && this.getB() == 255;
        }

        public boolean isAssigned() {
            return !this.isUnassigned();
        }
    }
}

