/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io;

import com.ur.safety.SafetyTextResource;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.io.SafetyIOInputFunction;
import com.ur.swing.ComboBox;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.AggregateDialogCreator;
import com.ur.swing.dialog.WarningMessage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public final class AutomaticModeSafeguardStopSelectedListener
implements PropertyChangeListener {
    private final SafetyIOConfiguration configuration;
    private final SafetyTextResource textResource;
    private AggregateDialogCreator dialogCreator;
    private boolean isStopAssigned;
    private ComboBox[] inFunctionComboBoxes;

    AutomaticModeSafeguardStopSelectedListener(SafetyIOConfiguration configuration, AggregateDialogCreator dialogCreator, ViewContext viewContext, ComboBox[] inFunctionComboBoxes) {
        this.configuration = configuration;
        this.dialogCreator = dialogCreator;
        this.textResource = (SafetyTextResource)viewContext.getTextResource(SafetyTextResource.class);
        this.inFunctionComboBoxes = inFunctionComboBoxes;
        this.updateCurrentState(configuration);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.hasStopChanged() && this.isStopConfiguredWithoutReset()) {
            ComboBox unassignedInputComboBox = this.getUnassignedInputComboBoxOrNull();
            if (unassignedInputComboBox != null) {
                unassignedInputComboBox.setSelectedItem((Object)SafetyIOInputFunction.AUTOMATIC_MODE_SAFEGUARD_STOP_RESET);
                DisplayMessageFactory.messageWithTitle((JComponent)unassignedInputComboBox, (String)this.textResource.Info(), (String)this.textResource.automaticmodesafeguardstopresetAutomaticallyadded(), (int)350);
            } else {
                String title = this.textResource.automaticModeSafeguardStopResetInput();
                String message = this.textResource.AutomaticModeSafeguardResetWarning();
                WarningMessage warningMessage = new WarningMessage(title, message);
                this.dialogCreator.showWarningMessageDialog(warningMessage, null);
            }
        }
        this.updateCurrentState(this.configuration);
    }

    private boolean isStopConfiguredWithoutReset() {
        return this.configuration.getAutomaticModeSafeguardStopInputs().isAssigned() && this.configuration.getAutomaticModeSafeguardStopResetInputs().isUnassigned();
    }

    private void updateCurrentState(SafetyIOConfiguration configuration) {
        this.isStopAssigned = configuration.getAutomaticModeSafeguardStopInputs().isAssigned();
    }

    private boolean hasStopChanged() {
        return this.isStopAssigned ^ this.configuration.getAutomaticModeSafeguardStopInputs().isAssigned();
    }

    private ComboBox getUnassignedInputComboBoxOrNull() {
        ComboBox[] comboBoxArray = this.inFunctionComboBoxes;
        int n = this.inFunctionComboBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            ComboBox inFunctionComboBox = comboBoxArray[n2];
            if (this.isUnassigned(inFunctionComboBox)) {
                return inFunctionComboBox;
            }
            ++n2;
        }
        return null;
    }

    private boolean isUnassigned(ComboBox comboBox) {
        return comboBox.getSelectedItem() != null && comboBox.getSelectedItem() == SafetyIOInputFunction.UNASSIGNED;
    }
}

