/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io;

import com.ur.polyscope.installation.loading.InstallationLoadingContext;
import com.ur.polyscope.pin.ConfigurableIOPin;
import com.ur.polyscope.pin.InputActionPin;
import com.ur.polyscope.pin.PinAction;
import com.ur.polyscope.pin.actions.InputPinAction;
import com.ur.polyscope.pin.actions.InputPinActionLookupService;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.polyscope.pin.iotab.ControllerSocketSender;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.safety.io.AbstractSafetyIOConfiguration;
import javax.inject.Inject;

public class IOActionPinUnassigner {
    private final InputPinActionLookupService inputPinActionLookupService;
    private final IOService ioService;
    private final InstallationLoadingContext installationLoadingContext;

    @Inject
    public IOActionPinUnassigner(InputPinActionLookupService inputPinActionLookupService, IOService ioService, InstallationLoadingContext installationLoadingContext) {
        this.inputPinActionLookupService = inputPinActionLookupService;
        this.ioService = ioService;
        this.installationLoadingContext = installationLoadingContext;
    }

    public void unassignInputActionPair(AbstractSafetyIOConfiguration.IOPair ioPair) {
        if (!this.installationLoadingContext.isLoading()) {
            Pin[] configInputPins = this.ioService.getConfigurableDigitalInputPins();
            this.unassignConfigurableInput(this.getInputPinWithPinNumber(ioPair.getA(), configInputPins));
            this.unassignConfigurableInput(this.getInputPinWithPinNumber(ioPair.getB(), configInputPins));
            if (ioPair.getA() >= 200 && ioPair.getB() < 255) {
                Pin[] configToolInputPins = this.ioService.getToolDigitalInputPins();
                this.unassignConfigurableInput(this.getInputPinWithPinNumber(ioPair.getA() - 200, configToolInputPins));
                this.unassignConfigurableInput(this.getInputPinWithPinNumber(ioPair.getB() - 200, configToolInputPins));
            }
        }
    }

    private void unassignConfigurableInput(InputActionPin pin) {
        PinAction noneInputAction = this.inputPinActionLookupService.getPinAction(InputPinAction.NONE);
        if (pin == null || pin.getIOPinAction() == noneInputAction) {
            return;
        }
        pin.setIOPinAction(noneInputAction);
        String script = pin.generateInputActionScriptCode();
        ControllerSocketSender.sendAsSecondaryProgram((String)script);
    }

    public void unassignOutputActionPair(AbstractSafetyIOConfiguration.IOPair ioPair) {
        if (!this.installationLoadingContext.isLoading()) {
            Pin[] configOutputPins = this.ioService.getConfigurableDigitalOutputPins();
            this.unassignConfigurableOutput(this.getConfigurableIOPinWithPinNumber(ioPair.getA(), configOutputPins));
            this.unassignConfigurableOutput(this.getConfigurableIOPinWithPinNumber(ioPair.getB(), configOutputPins));
        }
    }

    private void unassignConfigurableOutput(ConfigurableIOPin configurableIOPin) {
        if (configurableIOPin != null && configurableIOPin.getOutputAction() != OutputPinAction.NONE) {
            configurableIOPin.setOutputAction(OutputPinAction.NONE);
            configurableIOPin.setModificationChoice(0);
            String script = configurableIOPin.generateInputActionScriptCode();
            ControllerSocketSender.sendAsSecondaryProgram((String)script);
        }
    }

    private InputActionPin getInputPinWithPinNumber(int pinNr, Pin<?>[] pins) {
        Pin<?>[] pinArray = pins;
        int n = pins.length;
        int n2 = 0;
        while (n2 < n) {
            Pin<?> pin = pinArray[n2];
            if (pin.getPin() == pinNr) {
                return (InputActionPin)pin;
            }
            ++n2;
        }
        return null;
    }

    private ConfigurableIOPin getConfigurableIOPinWithPinNumber(int pinNr, Pin<?>[] pins) {
        Pin<?>[] pinArray = pins;
        int n = pins.length;
        int n2 = 0;
        while (n2 < n) {
            Pin<?> pin = pinArray[n2];
            if (pin.getPin() == pinNr) {
                return (ConfigurableIOPin)pin;
            }
            ++n2;
        }
        return null;
    }
}

