/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io;

import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.persistence.OptionsSection;
import com.ur.polyscope.persistence.PrimitiveDictionary;
import com.ur.polyscope.safety.SafetySetupContribution;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.io.AbstractSafetyIOConfiguration;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.io.SafetyIOInputFunction;
import com.ur.safety.io.SafetyIOOutputFunction;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.BooleanUtils;

@Singleton
public class IOContribution
implements SafetySetupContribution<SafetyIOConfiguration> {
    static final String SAFETY_IO_CONFIGURATION_OUTPUTS = "SafetyIOConfiguration Outputs";
    static final String SAFETY_IO_CONFIGURATION_INPUTS = "SafetyIOConfiguration Inputs";
    static final String SAFETY_IO_CONFIGURATION = "SafetyIOConfiguration";
    private final Provider<SafetyIOConfiguration> safetyIOConfigurationProvider;

    @Inject
    public IOContribution(Provider<SafetyIOConfiguration> safetyIOConfigurationProvider) {
        this.safetyIOConfigurationProvider = safetyIOConfigurationProvider;
    }

    public Class getComponentType() {
        return SafetyIOConfiguration.class;
    }

    public SafetyIOConfiguration createDefaultComponent() {
        return (SafetyIOConfiguration)this.safetyIOConfigurationProvider.get();
    }

    public SafetyIOConfiguration readFromOptions(ChecksumVersion checksumVersion, Options options) {
        SafetyIOConfiguration safetyIOConfiguration = this.createDefaultComponent();
        this.applyInputSectionToConfiguration(options, safetyIOConfiguration);
        this.applyOutputSectionToConfiguration(checksumVersion, options, safetyIOConfiguration);
        return safetyIOConfiguration;
    }

    public void copyToOptions(ChecksumVersion checksumVersion, Options options, SafetyIOConfiguration safetyIOConfiguration) {
        this.applyInputSectionToOptions(options, safetyIOConfiguration);
        this.applyOutputSectionToOptions(checksumVersion, options, safetyIOConfiguration);
    }

    public void copyControllerRepresentationTo(ChecksumVersion checksumVersion, Options options, SafetyIOConfiguration component) {
        OptionsSection safetyIOSection = options.getSection(SAFETY_IO_CONFIGURATION);
        this.applyInputFunctionsToOptions(checksumVersion, component, safetyIOSection);
        this.applyOutputFunctionsToOptions(checksumVersion, component, safetyIOSection);
    }

    public boolean isSupported(ChecksumVersion version) {
        return true;
    }

    private void applyOutputFunctionsToOptions(ChecksumVersion checksumVersion, SafetyIOConfiguration component, OptionsSection safetyIOSection) {
        for (SafetyIOOutputFunction eachFunction : SafetyIOOutputFunction.valuesToPersist()) {
            if (!eachFunction.isSupported(checksumVersion)) continue;
            AbstractSafetyIOConfiguration.IOPair eachValue = component.getOutput(eachFunction);
            safetyIOSection.setInteger(eachFunction.getPropertyForA(), Integer.valueOf(eachValue.getA()));
            safetyIOSection.setInteger(eachFunction.getPropertyForB(), Integer.valueOf(eachValue.getB()));
        }
        this.applyOssdsToOptions(checksumVersion, component, safetyIOSection);
    }

    private void applyInputFunctionsToOptions(ChecksumVersion checksumVersion, SafetyIOConfiguration component, OptionsSection safetyIOSection) {
        for (SafetyIOInputFunction eachFunction : SafetyIOInputFunction.valuesToPersist()) {
            if (!eachFunction.isSupported(checksumVersion)) continue;
            AbstractSafetyIOConfiguration.IOPair eachValue = component.getInput(eachFunction);
            safetyIOSection.setInteger(eachFunction.getPropertyForA(), Integer.valueOf(eachValue.getA()));
            safetyIOSection.setInteger(eachFunction.getPropertyForB(), Integer.valueOf(eachValue.getB()));
        }
    }

    private void applyOssdsToOptions(ChecksumVersion checksumVersion, SafetyIOConfiguration component, OptionsSection safetyIOSection) {
        if (checksumVersion.atLeast(ChecksumVersion.VERSION_5_5)) {
            int i = 0;
            while (i < component.sizeOfOSSDs()) {
                safetyIOSection.setInteger("configOut" + this.intPair(i) + "_OSSD", Integer.valueOf(BooleanUtils.toInteger((boolean)component.hasOSSD(i))));
                ++i;
            }
        }
    }

    private void applyOutputSectionToConfiguration(ChecksumVersion checksumVersion, Options options, SafetyIOConfiguration safetyIOConfiguration) {
        OptionsSection outputsSection = options.getSection(SAFETY_IO_CONFIGURATION_OUTPUTS);
        for (SafetyIOOutputFunction eachFunction : SafetyIOOutputFunction.valuesToPersist()) {
            AbstractSafetyIOConfiguration.IOPair currentValue = safetyIOConfiguration.getOutput(eachFunction);
            int signalForA = outputsSection.getInteger(eachFunction.getPropertyForA(), Integer.valueOf(currentValue.getA()));
            int signalForB = outputsSection.getInteger(eachFunction.getPropertyForB(), Integer.valueOf(currentValue.getB()));
            AbstractSafetyIOConfiguration.IOPair pair = new AbstractSafetyIOConfiguration.IOPair(signalForA, signalForB);
            safetyIOConfiguration.setOutput(pair, eachFunction);
        }
        this.applyOssdSectionToConfiguration(checksumVersion, safetyIOConfiguration, (PrimitiveDictionary)outputsSection);
    }

    private void applyOssdSectionToConfiguration(ChecksumVersion checksumVersion, SafetyIOConfiguration safetyIOConfiguration, PrimitiveDictionary outputsSection) {
        if (checksumVersion.atLeast(ChecksumVersion.VERSION_5_5)) {
            boolean[] ossdConfiguration = new boolean[safetyIOConfiguration.sizeOfOSSDs()];
            int i = 0;
            while (i < ossdConfiguration.length) {
                ossdConfiguration[i] = BooleanUtils.toBoolean((int)outputsSection.getInteger("configOut" + this.intPair(i) + "_OSSD", Integer.valueOf(0)));
                safetyIOConfiguration.setOSSDs(ossdConfiguration);
                ++i;
            }
        }
    }

    private void applyInputSectionToConfiguration(Options options, SafetyIOConfiguration safetyIOConfiguration) {
        OptionsSection inputsSection = options.getSection(SAFETY_IO_CONFIGURATION_INPUTS);
        for (SafetyIOInputFunction eachFunction : SafetyIOInputFunction.valuesToPersist()) {
            AbstractSafetyIOConfiguration.IOPair currentValue = safetyIOConfiguration.getInput(eachFunction);
            int signalForA = inputsSection.getInteger(eachFunction.getPropertyForA(), Integer.valueOf(currentValue.getA()));
            int signalForB = inputsSection.getInteger(eachFunction.getPropertyForB(), Integer.valueOf(currentValue.getB()));
            AbstractSafetyIOConfiguration.IOPair pair = new AbstractSafetyIOConfiguration.IOPair(signalForA, signalForB);
            safetyIOConfiguration.setInput(pair, eachFunction);
        }
    }

    private String intPair(int i) {
        return String.valueOf(i * 2) + "and" + (i * 2 + 1);
    }

    private void applyOutputSectionToOptions(ChecksumVersion checksumVersion, Options options, SafetyIOConfiguration safetyIOConfiguration) {
        OptionsSection outputsSection = options.getSection(SAFETY_IO_CONFIGURATION_OUTPUTS);
        for (SafetyIOOutputFunction eachFunction : SafetyIOOutputFunction.valuesToPersist()) {
            if (!eachFunction.isSupported(checksumVersion)) continue;
            AbstractSafetyIOConfiguration.IOPair eachValue = safetyIOConfiguration.getOutput(eachFunction);
            outputsSection.setInteger(eachFunction.getPropertyForA(), Integer.valueOf(eachValue.getA()));
            outputsSection.setInteger(eachFunction.getPropertyForB(), Integer.valueOf(eachValue.getB()));
        }
        this.applyOssdSectionToOptions(checksumVersion, safetyIOConfiguration, (PrimitiveDictionary)outputsSection);
    }

    private void applyOssdSectionToOptions(ChecksumVersion checksumVersion, SafetyIOConfiguration safetyIOConfiguration, PrimitiveDictionary outputsSection) {
        if (checksumVersion.atLeast(ChecksumVersion.VERSION_5_5)) {
            int i = 0;
            while (i < safetyIOConfiguration.sizeOfOSSDs()) {
                outputsSection.setInteger("configOut" + this.intPair(i) + "_OSSD", Integer.valueOf(BooleanUtils.toInteger((boolean)safetyIOConfiguration.hasOSSD(i))));
                ++i;
            }
        }
    }

    private void applyInputSectionToOptions(Options options, SafetyIOConfiguration safetyIOConfiguration) {
        OptionsSection inputsSection = options.getSection(SAFETY_IO_CONFIGURATION_INPUTS);
        for (SafetyIOInputFunction eachFunction : SafetyIOInputFunction.valuesToPersist()) {
            AbstractSafetyIOConfiguration.IOPair eachValue = safetyIOConfiguration.getInput(eachFunction);
            inputsSection.setInteger(eachFunction.getPropertyForA(), Integer.valueOf(eachValue.getA()));
            inputsSection.setInteger(eachFunction.getPropertyForB(), Integer.valueOf(eachValue.getB()));
        }
    }
}

