/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io;

import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.polyscope.safety.checksum.VersionComponent;
import com.ur.polyscope.safety.version.SafetyControlBoardVersionSite;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.io.SafetyIOConfigurationImpl;
import com.ur.safety.io.SafetyIOInputFunction;
import com.ur.safety.misc.core.SafetyMiscConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

class InputFunctionOptionsUpdater
implements PropertyChangeListener {
    private final JComboBox[] comboBoxes;
    protected final SafetySettingsLookupService provider;
    private SafetyControlBoardVersionSite versionSite;

    InputFunctionOptionsUpdater(SafetySettingsLookupService provider, SafetyControlBoardVersionSite versionSite, JComboBox ... comboBoxes) {
        this.comboBoxes = comboBoxes;
        this.provider = provider;
        this.versionSite = versionSite;
        this.doUpdateOptions();
    }

    protected SafetyIOInputFunction[] getInputFunctions() {
        SafetyMiscConfiguration miscConfiguration = this.provider.getSafetyComponent(SafetyMiscConfiguration.class);
        SafetyIOConfigurationImpl safetyIOConfiguration = (SafetyIOConfigurationImpl)this.provider.getSafetyComponent(SafetyIOConfiguration.class);
        ChecksumVersion checksumVersion = ((VersionComponent)this.provider.getSafetySetup().getComponent(VersionComponent.class)).getChecksumVersion();
        return safetyIOConfiguration.getSafetyInputDropdownOptions(this.versionSite, miscConfiguration, checksumVersion);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.doUpdateOptions();
    }

    protected void doUpdateOptions() {
        SafetyIOInputFunction[] safetyInputs = this.getInputFunctions();
        JComboBox[] jComboBoxArray = this.comboBoxes;
        int n = this.comboBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            JComboBox each = jComboBoxArray[n2];
            if (each.getModel().getSize() != safetyInputs.length) {
                each.setModel(new DefaultComboBoxModel<SafetyIOInputFunction>(safetyInputs));
            }
            ++n2;
        }
    }
}

