/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io;

import com.ur.safety.io.AbstractSafetyIOConfiguration;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.io.SafetyIOInputFunction;
import com.ur.safety.util.domain.ComboBoxUtils;
import java.beans.PropertyChangeListener;

public class InputPinSafetyConfiguration
implements ComboBoxUtils.GetSetModel<SafetyIOInputFunction> {
    private final int pinA;
    private final int pinB;
    private final SafetyIOConfiguration configuration;

    public InputPinSafetyConfiguration(int pinA, SafetyIOConfiguration configuration) {
        this.pinA = pinA;
        this.pinB = pinA + 1;
        this.configuration = configuration;
    }

    @Override
    public void set(SafetyIOInputFunction inputFunction) {
        this.configuration.setInput(new AbstractSafetyIOConfiguration.IOPair(this.pinA, this.pinB), inputFunction);
    }

    @Override
    public SafetyIOInputFunction get() {
        SafetyIOInputFunction[] safetyIOInputFunctionArray = SafetyIOInputFunction.values();
        int n = safetyIOInputFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            SafetyIOInputFunction each = safetyIOInputFunctionArray[n2];
            if (this.configuration.getInput(each).getA() == this.pinA) {
                return each;
            }
            ++n2;
        }
        return SafetyIOInputFunction.UNASSIGNED;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.configuration.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.configuration.removePropertyChangeListener(listener);
    }
}

