/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io;

import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.io.SafetyIOInputFunction;
import com.ur.safety.profisafe.ProfisafeConfiguration;
import com.ur.swing.dialog.AggregateDialogCreator;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class OperationalModeInputSelectedListener
implements PropertyChangeListener {
    private final SafetySettingsLookupService provider;
    private final AggregateDialogCreator dialogCreator;
    private final SafetyTextResource textResource;
    protected final ProfisafeDialogListener profisafeDialogListener;

    public OperationalModeInputSelectedListener(SafetyIOConfiguration configuration, SafetySettingsLookupService provider, AggregateDialogCreator dialogCreator, SafetyTextResource textResource) {
        this.provider = provider;
        this.dialogCreator = dialogCreator;
        this.textResource = textResource;
        this.profisafeDialogListener = new ProfisafeDialogListener(configuration);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.operationalModeInputSelected(evt.getPropertyName()) && this.isProfisafeOperationalModeEnabled()) {
            this.showDialogToConfirmOperationalModeSelection();
        }
    }

    private boolean operationalModeInputSelected(String propertyName) {
        return SafetyIOInputFunction.OPERATIONAL_MODE_INPUT.getProperty().equals(propertyName);
    }

    private void showDialogToConfirmOperationalModeSelection() {
        this.dialogCreator.showConfirmationDialog(new ConfirmationMessage(this.textResource.operationalModeInput(), this.textResource.modeSelectorDescription(), this.textResource.Yes(), this.textResource.No()), (ConfirmationDialogListener)this.profisafeDialogListener);
    }

    private boolean isProfisafeOperationalModeEnabled() {
        return this.provider.getSafetyComponent(ProfisafeConfiguration.class).isOperationalModeEnabled();
    }

    final class ProfisafeDialogListener
    extends ConfirmationDialogListener {
        private final SafetyIOConfiguration configuration;

        public ProfisafeDialogListener(SafetyIOConfiguration configuration) {
            this.configuration = configuration;
        }

        public void onOkClicked() {
            OperationalModeInputSelectedListener.this.provider.getSafetyComponent(ProfisafeConfiguration.class).setOperationalModeEnabled(false);
        }

        public void onCancelClicked() {
            this.configuration.setInput(this.configuration.getOperationalModeInputs(), SafetyIOInputFunction.UNASSIGNED);
        }
    }
}

