/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io;

import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.io.SafetyIOConfigurationImpl;
import com.ur.safety.io.SafetyIOOutputFunction;
import com.ur.safety.safehome.SafeHomeConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

class OutputFunctionOptionsUpdater
implements PropertyChangeListener {
    protected final JComboBox[] comboBoxes;
    private final SafetySettingsLookupService provider;

    OutputFunctionOptionsUpdater(SafetySettingsLookupService provider, JComboBox ... comboBoxes) {
        this.comboBoxes = comboBoxes;
        this.provider = provider;
        this.doUpdateOptions();
    }

    protected SafetyIOOutputFunction[] getOutputFunctions() {
        SafeHomeConfiguration safeHomeConfiguration = this.provider.getSafetyComponent(SafeHomeConfiguration.class);
        SafetyIOConfigurationImpl safetyIOConfiguration = (SafetyIOConfigurationImpl)this.provider.getSafetyComponent(SafetyIOConfiguration.class);
        return safetyIOConfiguration.getSafetyOutputDropdownOptions(safeHomeConfiguration);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.doUpdateOptions();
    }

    protected void doUpdateOptions() {
        SafetyIOOutputFunction[] safetyOutputs = this.getOutputFunctions();
        JComboBox[] jComboBoxArray = this.comboBoxes;
        int n = this.comboBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            JComboBox each = jComboBoxArray[n2];
            if (each.getModel().getSize() != safetyOutputs.length) {
                each.setModel(new DefaultComboBoxModel<SafetyIOOutputFunction>(safetyOutputs));
            }
            ++n2;
        }
    }
}

