/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io;

import com.ur.safety.io.AbstractSafetyIOConfiguration;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.io.SafetyIOOutputFunction;
import com.ur.safety.util.domain.ComboBoxUtils;
import java.beans.PropertyChangeListener;

public class OutputPinSafetyConfiguration
implements ComboBoxUtils.GetSetModel<SafetyIOOutputFunction> {
    private final int pinA;
    private final int pinB;
    private final SafetyIOConfiguration configuration;

    public OutputPinSafetyConfiguration(int pinA, SafetyIOConfiguration configuration) {
        this.pinA = pinA;
        this.pinB = pinA + 1;
        this.configuration = configuration;
    }

    @Override
    public void set(SafetyIOOutputFunction outputFunction) {
        this.configuration.setOutput(new AbstractSafetyIOConfiguration.IOPair(this.pinA, this.pinB), outputFunction);
    }

    @Override
    public SafetyIOOutputFunction get() {
        SafetyIOOutputFunction[] safetyIOOutputFunctionArray = SafetyIOOutputFunction.values();
        int n = safetyIOOutputFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            SafetyIOOutputFunction each = safetyIOOutputFunctionArray[n2];
            if (this.configuration.getOutput(each).getA() == this.pinA) {
                return each;
            }
            ++n2;
        }
        return SafetyIOOutputFunction.UNASSIGNED;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.configuration.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.configuration.removePropertyChangeListener(listener);
    }
}

