/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io;

import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentificationProvider;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.polyscope.safety.version.SafetyControlBoardVersionSite;
import com.ur.safety.io.AbstractSafetyIOConfiguration;
import com.ur.safety.io.IOActionPinUnassigner;
import com.ur.safety.io.SafetyIOInputFunction;
import com.ur.safety.io.SafetyIOOutputFunction;
import com.ur.safety.misc.core.SafetyMiscConfiguration;
import com.ur.safety.safehome.SafeHomeConfiguration;
import com.ur.view.constants.dev.TPType;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import javax.inject.Inject;

public class SafetyIOConfigurationImpl
extends AbstractSafetyIOConfiguration {
    private static final String[] ALLOWED_TOOL_SAFETY_INPUT = new String[]{"UR8_LONG"};
    private static final String OSSD_STR = "OSSD";
    private final transient RobotIdentificationProvider robotIdentificationProvider;
    private boolean[] ossds = new boolean[4];

    @Inject
    public SafetyIOConfigurationImpl(IOActionPinUnassigner ioActionUnassigner, RobotIdentificationProvider robotIdentificationProvider) {
        super(ioActionUnassigner);
        this.robotIdentificationProvider = robotIdentificationProvider;
    }

    @Override
    public SafetyIOInputFunction[] getSafetyInputDropdownOptions(ChecksumVersion checksumVersion) {
        EnumSet<SafetyIOInputFunction> result = EnumSet.allOf(SafetyIOInputFunction.class);
        return result.toArray(new SafetyIOInputFunction[0]);
    }

    @Override
    public SafetyIOInputFunction[] getToolSafetyInputDropdownOptions(ChecksumVersion checksumVersion) {
        EnumSet<SafetyIOInputFunction> result = EnumSet.of(SafetyIOInputFunction.UNASSIGNED);
        if (this.isToolSafetyInputAvailable()) {
            result = EnumSet.of(SafetyIOInputFunction.UNASSIGNED, SafetyIOInputFunction.THREE_POSITION_ENABLING_INPUT, SafetyIOInputFunction.FREEDRIVE_ON_ROBOT_INPUT);
        }
        return result.toArray(new SafetyIOInputFunction[0]);
    }

    private boolean isToolSafetyInputAvailable() {
        RobotIdentification robotIdentification = (RobotIdentification)this.robotIdentificationProvider.get();
        String robotTypeName = robotIdentification.getRobotTypeId().getRobotTypeName();
        return Arrays.asList(ALLOWED_TOOL_SAFETY_INPUT).contains(robotTypeName);
    }

    @Override
    public SafetyIOOutputFunction[] getSafetyOutputDropdownOptions() {
        EnumSet<SafetyIOOutputFunction> result = EnumSet.allOf(SafetyIOOutputFunction.class);
        return result.toArray(new SafetyIOOutputFunction[0]);
    }

    @Override
    public SafetyIOInputFunction[] getSafetyInputDropdownOptions(SafetyControlBoardVersionSite versionSite, SafetyMiscConfiguration miscConfiguration, ChecksumVersion checksumVersion) {
        EnumSet<SafetyIOInputFunction> result = EnumSet.allOf(SafetyIOInputFunction.class);
        if (this.is3PENotConfigured(miscConfiguration)) {
            this.removeAutomaticModeSafeguardFunctions(result);
        }
        return result.toArray(new SafetyIOInputFunction[0]);
    }

    private boolean is3PENotConfigured(SafetyMiscConfiguration miscConfiguration) {
        return this.getThreePositionEnablingInputs().isUnassigned() && miscConfiguration.getTeachPendant() != TPType.THREE_POSITION_ENABLING;
    }

    @Override
    public SafetyIOOutputFunction[] getSafetyOutputDropdownOptions(SafeHomeConfiguration safeHomeConfiguration) {
        EnumSet<SafetyIOOutputFunction> result = EnumSet.allOf(SafetyIOOutputFunction.class);
        if (safeHomeConfiguration == null || !safeHomeConfiguration.isEnabled()) {
            this.removeSafeHome(result);
        }
        return result.toArray(new SafetyIOOutputFunction[0]);
    }

    private void removeAutomaticModeSafeguardFunctions(Set<SafetyIOInputFunction> result) {
        result.remove((Object)SafetyIOInputFunction.AUTOMATIC_MODE_SAFEGUARD_STOP);
        result.remove((Object)SafetyIOInputFunction.AUTOMATIC_MODE_SAFEGUARD_STOP_RESET);
    }

    @Override
    public int sizeOfOSSDs() {
        return this.ossds.length;
    }

    @Override
    public boolean[] getOSSDs() {
        return Arrays.copyOf(this.ossds, this.ossds.length);
    }

    @Override
    public void setOSSDs(boolean[] values) {
        boolean[] oldValues = this.ossds;
        this.ossds = Arrays.copyOf(values, values.length);
        this.fireEvent(new PropertyChangeEvent(this, OSSD_STR, oldValues, this.ossds));
    }

    @Override
    public boolean hasOSSD(int index) {
        return this.ossds[index];
    }

    @Override
    public void setOSSD(int index, boolean value) {
        boolean oldValue = this.ossds[index];
        this.ossds[index] = value;
        this.fireEvent(new PropertyChangeEvent(this, OSSD_STR, oldValue, value));
    }

    @Override
    public boolean isOSSDEnabled(AbstractSafetyIOConfiguration.IOPair ioPair) {
        if (ioPair.isAssigned()) {
            return this.ossds[ioPair.getA() / 2];
        }
        return false;
    }
}

