/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io;

import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.controllerinterface.SafetyConfigurationParser;
import com.ur.safety.io.AbstractSafetyIOConfiguration;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.io.SafetyIOInputFunction;
import com.ur.safety.io.SafetyIOOutputFunction;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Provider;

public class SafetyIOConfigurationParser
extends SafetyConfigurationParser.ActiveParserTemplate<SafetyIOConfiguration> {
    private final Provider<SafetyIOConfiguration> safetyIOConfigurationProvider;
    private SafetyIOConfiguration safetyIO;
    private SafetyConfigurationParser ossdConfigurationParser;

    @Inject
    public SafetyIOConfigurationParser(Provider<SafetyIOConfiguration> safetyIOConfigurationProvider) {
        this.safetyIOConfigurationProvider = safetyIOConfigurationProvider;
        this.ossdConfigurationParser = new OSSDConfigurationParser();
    }

    @Override
    public void parse(DataInput stream, ChecksumVersion version) throws IOException {
        AbstractSafetyIOConfiguration.IOPair value;
        this.safetyIO = (SafetyIOConfiguration)this.safetyIOConfigurationProvider.get();
        for (SafetyIOInputFunction safetyIOInputFunction : SafetyIOInputFunction.valuesToPersist()) {
            if (!safetyIOInputFunction.isSupported(version)) continue;
            value = new AbstractSafetyIOConfiguration.IOPair(stream.readUnsignedByte(), stream.readUnsignedByte());
            this.safetyIO.setInput(value, safetyIOInputFunction);
        }
        for (SafetyIOOutputFunction safetyIOOutputFunction : SafetyIOOutputFunction.valuesToPersist()) {
            if (!safetyIOOutputFunction.isSupported(version)) continue;
            value = new AbstractSafetyIOConfiguration.IOPair(stream.readUnsignedByte(), stream.readUnsignedByte());
            this.safetyIO.setOutput(value, safetyIOOutputFunction);
        }
    }

    @Override
    public Class<SafetyIOConfiguration> getType() {
        return SafetyIOConfiguration.class;
    }

    @Override
    public SafetyIOConfiguration getResult() {
        return this.safetyIO;
    }

    public SafetyConfigurationParser getOSSDConfigurationParser() {
        return this.ossdConfigurationParser;
    }

    private class OSSDConfigurationParser
    extends SafetyConfigurationParser.ActiveParserTemplate<SafetyIOConfiguration> {
        private OSSDConfigurationParser() {
        }

        @Override
        public void parse(DataInput input, ChecksumVersion version) throws IOException {
            if (version.atLeast(ChecksumVersion.VERSION_5_5)) {
                if (SafetyIOConfigurationParser.this.safetyIO == null) {
                    SafetyIOConfigurationParser.this.safetyIO = (SafetyIOConfiguration)SafetyIOConfigurationParser.this.safetyIOConfigurationProvider.get();
                }
                boolean[] ossds = new boolean[SafetyIOConfigurationParser.this.safetyIO.sizeOfOSSDs()];
                byte b = input.readByte();
                int i = 0;
                while (i < ossds.length) {
                    ossds[i] = (b >> i & 1) != 0;
                    ++i;
                }
                SafetyIOConfigurationParser.this.safetyIO.setOSSDs(ossds);
            }
        }

        @Override
        public Class<SafetyIOConfiguration> getType() {
            return SafetyIOConfiguration.class;
        }

        @Override
        public SafetyIOConfiguration getResult() {
            return SafetyIOConfigurationParser.this.safetyIO;
        }
    }
}

