/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io;

import com.ur.polyscope.safety.checksum.ChecksumVersion;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;

public enum SafetyIOInputFunction {
    UNASSIGNED("unassigned"),
    EMERGENCY_STOP("emergencyStopInput"),
    REDUCED_MODE("reducedModeInput"),
    SAFEGUARD_STOP_RESET("safeguardStopResetInput"),
    THREE_POSITION_ENABLING_INPUT("threePositionEnablingInput"),
    OPERATIONAL_MODE_INPUT("operationalModeInput"),
    AUTOMATIC_MODE_SAFEGUARD_STOP("automaticModeSafeguardStopInput"),
    AUTOMATIC_MODE_SAFEGUARD_STOP_RESET("automaticModeSafeguardStopResetInput"),
    FREEDRIVE_ON_ROBOT_INPUT("freedriveOnRobotInput");

    private final String property;

    private SafetyIOInputFunction(String property) {
        this.property = property;
    }

    public static String[] getPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        SafetyIOInputFunction[] safetyIOInputFunctionArray = SafetyIOInputFunction.values();
        int n = safetyIOInputFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            SafetyIOInputFunction each = safetyIOInputFunctionArray[n2];
            result.add(each.getProperty());
            ++n2;
        }
        return result.toArray(new String[0]);
    }

    public String getProperty() {
        return this.property;
    }

    public String getPropertyForA() {
        return String.valueOf(this.property) + "A";
    }

    public String getPropertyForB() {
        return String.valueOf(this.property) + "B";
    }

    public boolean isSupported(ChecksumVersion version) {
        switch (this) {
            case UNASSIGNED: 
            case EMERGENCY_STOP: 
            case REDUCED_MODE: 
            case SAFEGUARD_STOP_RESET: {
                return true;
            }
            case THREE_POSITION_ENABLING_INPUT: 
            case OPERATIONAL_MODE_INPUT: {
                return version.atLeast(ChecksumVersion.VERSION_3_2);
            }
            case AUTOMATIC_MODE_SAFEGUARD_STOP: 
            case AUTOMATIC_MODE_SAFEGUARD_STOP_RESET: {
                return version.atLeast(ChecksumVersion.VERSION_5_4);
            }
            case FREEDRIVE_ON_ROBOT_INPUT: {
                return version.atLeast(ChecksumVersion.VERSION_5_8);
            }
        }
        return false;
    }

    public static Set<SafetyIOInputFunction> valuesToPersist() {
        EnumSet<SafetyIOInputFunction> result = EnumSet.allOf(SafetyIOInputFunction.class);
        result.remove((Object)UNASSIGNED);
        return result;
    }
}

