/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io;

import com.ur.polyscope.safety.checksum.ChecksumVersion;
import java.util.EnumSet;
import java.util.Set;

public enum SafetyIOOutputFunction {
    UNASSIGNED("unassigned"),
    SYSTEM_EMERGENCY_STOP("systemEmergencyStopOutput"),
    ROBOT_MOVING("robotMovingOutput"),
    ROBOT_NOT_STOPPING("robotNotStoppingOutput"),
    REDUCED_MODE("reducedModeOutput"),
    NOT_REDUCED_MODE("notReducedModeOutput"),
    SAFE_HOME("safeHomeOutput"),
    THREE_POSITION_ENABLING_STOP("threePositionEnablingOutput"),
    NO_THREE_POSITION_ENABLING_STOP("notThreePositionEnablingOutput");

    private final String property;

    private SafetyIOOutputFunction(String property) {
        this.property = property;
    }

    public String getProperty() {
        return this.property;
    }

    public String getPropertyForA() {
        return String.valueOf(this.property) + "A";
    }

    public String getPropertyForB() {
        return String.valueOf(this.property) + "B";
    }

    public static Set<SafetyIOOutputFunction> valuesToPersist() {
        EnumSet<SafetyIOOutputFunction> result = EnumSet.allOf(SafetyIOOutputFunction.class);
        result.remove((Object)UNASSIGNED);
        return result;
    }

    public boolean isSupported(ChecksumVersion version) {
        switch (this) {
            case UNASSIGNED: 
            case SYSTEM_EMERGENCY_STOP: 
            case ROBOT_MOVING: 
            case ROBOT_NOT_STOPPING: 
            case REDUCED_MODE: 
            case NOT_REDUCED_MODE: {
                return true;
            }
            case SAFE_HOME: {
                return version.atLeast(ChecksumVersion.VERSION_5_2);
            }
            case THREE_POSITION_ENABLING_STOP: 
            case NO_THREE_POSITION_ENABLING_STOP: {
                return version.atLeast(ChecksumVersion.VERSION_5_11);
            }
        }
        return false;
    }
}

