/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io;

import com.ur.bean.PropertyChangeSite;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.polyscope.safety.checksum.VersionComponent;
import com.ur.polyscope.viewfacade.lang.Errorable;
import com.ur.polyscope.viewfacade.lang.ShowIcon;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.resources.ViewImageResource;
import com.ur.safety.DefaultSafetyLockListener;
import com.ur.safety.Safety;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.impl.ValidationBindingUtils;
import com.ur.safety.io.AutomaticModeSafeguardStopSelectedListener;
import com.ur.safety.io.FreedriveOnRobotArmSelectedListener;
import com.ur.safety.io.InputOptionsProvider;
import com.ur.safety.io.InputPinSafetyConfiguration;
import com.ur.safety.io.OperationalModeInputSelectedListener;
import com.ur.safety.io.OutputOptionsProvider;
import com.ur.safety.io.OutputPinSafetyConfiguration;
import com.ur.safety.io.SafeguardResetDisabledListener;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.io.SafetyIOInputFunction;
import com.ur.safety.io.SafetyIOOutputFunction;
import com.ur.safety.io.ThreePositionEnablingStopSelectedListener;
import com.ur.safety.io.ToolSafetyInputComboBox;
import com.ur.safety.io.validator.ErrorOnUnsupportedToolSafetyInput;
import com.ur.safety.misc.core.SafetyMiscConfiguration;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.tolerances.SafetyComplianceTolerances;
import com.ur.safety.util.domain.ComboBoxUtils;
import com.ur.safety.util.domain.UpdateParentWithFormState;
import com.ur.safety.util.infrastructure.ActivatablePanel;
import com.ur.swing.BindingRegistration;
import com.ur.swing.ComboBox;
import com.ur.swing.CompoundRegistration;
import com.ur.swing.FontFactory;
import com.ur.swing.LabelProvider;
import com.ur.swing.SwingUtil;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.dialog.AggregateDialogCreator;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.validation.FormValidation;
import com.ur.swing.validation.SwingFormValidation;
import com.ur.util.event.EventNotificationService;
import java.awt.Color;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang.ArrayUtils;
import org.jdesktop.swingx.JXLabel;

public abstract class SafetyIOPanel
extends ActivatablePanel {
    public static final String SHOW_SAFETY_IO_ACTION = "showSafetyIOAction" + SafetyIOPanel.class.getSimpleName();
    private static final String GUI_INPUTS = "gui:installation_safety_safety_io_inputs";
    private static final String GUI_OUTPUTS = "gui:installation_safety_safety_io_outputs";
    protected static final Color SEPARATOR_COLOR = new Color(160, 160, 160);
    public static final String INPUT_0_AND_1 = "input0And1.SafetyIOPanel";
    public static final String INPUT_2_AND_3 = "input2And3.SafetyIOPanel";
    public static final String INPUT_4_AND_5 = "input4And5.SafetyIOPanel";
    public static final String INPUT_6_AND_7 = "input6And7.SafetyIOPanel";
    public static final String INPUT_200_AND_201 = "input200And201.SafetyIOPanel";
    public static final String OUTPUT_0_AND_1 = "output0And1.SafetyIOPanel";
    public static final String OUTPUT_2_AND_3 = "output2And3.SafetyIOPanel";
    public static final String OUTPUT_4_AND_5 = "output4And5.SafetyIOPanel";
    public static final String OUTPUT_6_AND_7 = "output6And7.SafetyIOPanel";
    protected final SafetySettingsLookupService provider;
    protected final ViewContext viewContext;
    protected final SwingFormValidation safetyFormValidation = new SwingFormValidation();
    protected final HelpIdAssigner helpIdAssigner;
    protected final SafetyTextResource textResource;
    private final IOService ioService;
    private final UpdateParentWithFormState formStatus;
    protected final SafetyLock lock;
    protected ComboBox<SafetyIOInputFunction>[] inFunctionComboBoxes;
    protected ComboBox<SafetyIOOutputFunction>[] outFunctionComboBoxes;
    private CompoundRegistration registrations;
    private final AggregateDialogCreator dialogCreator;
    protected JXLabel no3PEErrorLabel;

    public SafetyIOPanel(SafetyLock lock, ViewContext viewContext, @Safety ShowIcon showIconForParent, SafetySettingsLookupService provider, IOService ioService, AggregateDialogCreator dialogCreator) {
        this.formStatus = new UpdateParentWithFormState(showIconForParent, this);
        this.provider = provider;
        this.ioService = ioService;
        this.viewContext = viewContext;
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
        this.textResource = (SafetyTextResource)viewContext.getTextResource(SafetyTextResource.class);
        this.lock = lock;
        this.dialogCreator = dialogCreator;
        this.initComponents();
        this.initHelpIds();
        this.setIOSignalNames();
        DefaultSafetyLockListener safetyLockListener = new DefaultSafetyLockListener(lock, provider, new JComponent[0]);
        this.addComponentsToSafetyLockListener(safetyLockListener);
        lock.addSafetyLockListener(safetyLockListener);
        EventNotificationService.register((Object)this, SafetyChangeListener.class, (Object)new SafetyIOChangeListener());
    }

    private void addComponentsToSafetyLockListener(DefaultSafetyLockListener safetyLockListener) {
        Object[] objectArray = this.inFunctionComboBoxes;
        int n = this.inFunctionComboBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            ComboBox<SafetyIOInputFunction> inFunctionComboBox = objectArray[n2];
            safetyLockListener.addComponent((JComponent)inFunctionComboBox);
            ++n2;
        }
        objectArray = this.outFunctionComboBoxes;
        n = this.outFunctionComboBoxes.length;
        n2 = 0;
        while (n2 < n) {
            ComboBox<SafetyIOInputFunction> outFunctionComboBox = objectArray[n2];
            safetyLockListener.addComponent((JComponent)outFunctionComboBox);
            ++n2;
        }
    }

    private void initHelpIds() {
        Object[] objectArray = this.inFunctionComboBoxes;
        int n = this.inFunctionComboBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            ComboBox<SafetyIOInputFunction> inFunctionComboBox = objectArray[n2];
            this.helpIdAssigner.assignHelpId(inFunctionComboBox, GUI_INPUTS);
            ++n2;
        }
        objectArray = this.outFunctionComboBoxes;
        n = this.outFunctionComboBoxes.length;
        n2 = 0;
        while (n2 < n) {
            ComboBox<SafetyIOInputFunction> outFunctionComboBox = objectArray[n2];
            this.helpIdAssigner.assignHelpId(outFunctionComboBox, GUI_OUTPUTS);
            ++n2;
        }
    }

    private void setIOSignalNames() {
        this.inFunctionComboBoxes[0].setName(INPUT_0_AND_1);
        this.inFunctionComboBoxes[1].setName(INPUT_2_AND_3);
        this.inFunctionComboBoxes[2].setName(INPUT_4_AND_5);
        this.inFunctionComboBoxes[3].setName(INPUT_6_AND_7);
        this.inFunctionComboBoxes[4].setName(INPUT_200_AND_201);
        this.outFunctionComboBoxes[0].setName(OUTPUT_0_AND_1);
        this.outFunctionComboBoxes[1].setName(OUTPUT_2_AND_3);
        this.outFunctionComboBoxes[2].setName(OUTPUT_4_AND_5);
        this.outFunctionComboBoxes[3].setName(OUTPUT_6_AND_7);
    }

    @Override
    public void activate() {
        this.bindFormValidation();
    }

    @Override
    public void deactivate() {
        this.removeFormValidation();
    }

    @Override
    public Errorable.Status getStatus() {
        return this.formStatus.getOverallStatus();
    }

    @Override
    public void addStatusListener(Errorable.StatusListener listener) {
        this.formStatus.addStatusListener(listener);
    }

    @Override
    public void removeStatusListener(Errorable.StatusListener listener) {
        this.formStatus.removeStatusListener(listener);
    }

    protected SafetyIOConfiguration getSafetyIOConfiguration() {
        return this.provider.getSafetyComponent(SafetyIOConfiguration.class);
    }

    private void bindFormValidation() {
        this.addSelectedSafetyFunctionIfUnsupported((ToolSafetyInputComboBox)this.inFunctionComboBoxes[4]);
        this.removeFormValidation();
        SafetyIOConfiguration configuration = this.getSafetyIOConfiguration();
        BindingRegistration informUserWhenSafeguardResetDisabledRegistration = this.createInformUserWhenSafeguardResetDisabled(configuration);
        BindingRegistration updateInputFunctionOptionsRegistration = this.createAndBindInputFunctionOptionsUpdater(configuration);
        BindingRegistration updateOutputFunctionOptionsRegistration = this.createAndBindOutputFunctionOptionsUpdater(configuration);
        BindingRegistration automaticModeSafeguardStopSelectedListener = this.bindAutomaticModeSafeguardStopSelectedListener(configuration, this.dialogCreator);
        BindingRegistration operationalModeInputSelectedListener = this.bindOperationalModeInputSelectedListener(configuration);
        BindingRegistration informUserWhenFreedriveOnRobotArmSelected = this.createInformUserWhenFreedriveOnRobotArmSelected(configuration);
        BindingRegistration threePositionEnablingStopSelectedListener = this.bindThreePositionEnablingStopSelectedListener(configuration);
        BindingRegistration noThreePositionEnablingStopSelectedListener = this.bindNoThreePositionEnablingStopSelectedListener(configuration);
        this.registrations = new CompoundRegistration(new BindingRegistration[]{informUserWhenSafeguardResetDisabledRegistration, updateInputFunctionOptionsRegistration, updateOutputFunctionOptionsRegistration, automaticModeSafeguardStopSelectedListener, operationalModeInputSelectedListener, informUserWhenFreedriveOnRobotArmSelected, threePositionEnablingStopSelectedListener, noThreePositionEnablingStopSelectedListener, ComboBoxUtils.bindToField(this.inFunctionComboBoxes[0], new InputPinSafetyConfiguration(0, configuration)), ComboBoxUtils.bindToField(this.inFunctionComboBoxes[1], new InputPinSafetyConfiguration(2, configuration)), ComboBoxUtils.bindToField(this.inFunctionComboBoxes[2], new InputPinSafetyConfiguration(4, configuration)), ComboBoxUtils.bindToField(this.inFunctionComboBoxes[3], new InputPinSafetyConfiguration(6, configuration)), ComboBoxUtils.bindToField(this.inFunctionComboBoxes[4], new InputPinSafetyConfiguration(200, configuration)), ValidationBindingUtils.bindToFormValidators(this.safetyFormValidation, new PropertyChangeSite[]{configuration}), ComboBoxUtils.bindToField(this.outFunctionComboBoxes[0], new OutputPinSafetyConfiguration(0, configuration)), ComboBoxUtils.bindToField(this.outFunctionComboBoxes[1], new OutputPinSafetyConfiguration(2, configuration)), ComboBoxUtils.bindToField(this.outFunctionComboBoxes[2], new OutputPinSafetyConfiguration(4, configuration)), ComboBoxUtils.bindToField(this.outFunctionComboBoxes[3], new OutputPinSafetyConfiguration(6, configuration))});
        this.safetyFormValidation.clearForm();
        this.safetyFormValidation.addFormListener((FormValidation.FormListener)this.formStatus);
        this.addAdditionalFormValidation();
        this.addToolSafetyInputValidation();
        this.safetyFormValidation.validate();
    }

    private void addToolSafetyInputValidation() {
        ErrorOnUnsupportedToolSafetyInput toolSafetyInputValidator = new ErrorOnUnsupportedToolSafetyInput(this.inFunctionComboBoxes[4], this.textResource, this.getSafetyIOConfiguration(), this.getChecksumVersion());
        this.safetyFormValidation.addErrorValidation(this.inFunctionComboBoxes[4], (FormValidation.Validator)toolSafetyInputValidator);
    }

    private void addSelectedSafetyFunctionIfUnsupported(ToolSafetyInputComboBox inFunctionComboBox) {
        SafetyIOConfiguration configuration = this.getSafetyIOConfiguration();
        SafetyIOInputFunction[] dropdownOptions = configuration.getToolSafetyInputDropdownOptions(this.getChecksumVersion());
        inFunctionComboBox.setModel(new DefaultComboBoxModel<SafetyIOInputFunction>(dropdownOptions));
        InputPinSafetyConfiguration toolSafetyInput = new InputPinSafetyConfiguration(200, configuration);
        SafetyIOInputFunction assignedInputFunction = toolSafetyInput.get();
        DefaultComboBoxModel comboBoxModel = (DefaultComboBoxModel)inFunctionComboBox.getModel();
        if (comboBoxModel.getIndexOf((Object)assignedInputFunction) == -1) {
            comboBoxModel.addElement(assignedInputFunction);
        }
        inFunctionComboBox.setComboboxEnabled(comboBoxModel.getSize() > 1);
    }

    abstract void addAdditionalFormValidation();

    private void removeFormValidation() {
        if (this.registrations != null) {
            this.registrations.removeRegistration();
            this.registrations = null;
        }
    }

    private BindingRegistration bindAutomaticModeSafeguardStopSelectedListener(SafetyIOConfiguration configuration, AggregateDialogCreator dialogCreator) {
        AutomaticModeSafeguardStopSelectedListener automaticModeSafeguardStopSelectedListener = new AutomaticModeSafeguardStopSelectedListener(configuration, dialogCreator, this.viewContext, this.inFunctionComboBoxes);
        configuration.addPropertyChangeListener(automaticModeSafeguardStopSelectedListener);
        return () -> configuration.removePropertyChangeListener(automaticModeSafeguardStopSelectedListener);
    }

    private BindingRegistration createInformUserWhenSafeguardResetDisabled(SafetyIOConfiguration configuration) {
        SafeguardResetDisabledListener informUserWhenSafeguardResetDisabled = new SafeguardResetDisabledListener(configuration, this.inFunctionComboBoxes, this.outFunctionComboBoxes, this.viewContext);
        configuration.addPropertyChangeListener(informUserWhenSafeguardResetDisabled);
        return () -> configuration.removePropertyChangeListener(informUserWhenSafeguardResetDisabled);
    }

    private BindingRegistration createInformUserWhenFreedriveOnRobotArmSelected(SafetyIOConfiguration safetyIOConfiguration) {
        FreedriveOnRobotArmSelectedListener freedriveOnRobotArmSelectedListener = new FreedriveOnRobotArmSelectedListener(safetyIOConfiguration, this.inFunctionComboBoxes, this.viewContext);
        safetyIOConfiguration.addPropertyChangeListener(freedriveOnRobotArmSelectedListener);
        return () -> safetyIOConfiguration.removePropertyChangeListener(freedriveOnRobotArmSelectedListener);
    }

    private BindingRegistration bindOperationalModeInputSelectedListener(SafetyIOConfiguration configuration) {
        OperationalModeInputSelectedListener operationalModeInputSelectedListener = new OperationalModeInputSelectedListener(configuration, this.provider, this.dialogCreator, this.textResource);
        configuration.addPropertyChangeListener(operationalModeInputSelectedListener);
        return () -> configuration.removePropertyChangeListener(operationalModeInputSelectedListener);
    }

    private BindingRegistration bindThreePositionEnablingStopSelectedListener(SafetyIOConfiguration configuration) {
        ThreePositionEnablingStopSelectedListener threePositionEnablingStopSelectedListener = new ThreePositionEnablingStopSelectedListener(SafetyIOOutputFunction.THREE_POSITION_ENABLING_STOP, configuration, this.provider.getSafetyComponent(SafetyMiscConfiguration.class), this.outFunctionComboBoxes, this.viewContext);
        configuration.addPropertyChangeListener(threePositionEnablingStopSelectedListener);
        return () -> configuration.removePropertyChangeListener(threePositionEnablingStopSelectedListener);
    }

    private BindingRegistration bindNoThreePositionEnablingStopSelectedListener(SafetyIOConfiguration configuration) {
        ThreePositionEnablingStopSelectedListener threePositionEnablingStopSelectedListener = new ThreePositionEnablingStopSelectedListener(SafetyIOOutputFunction.NO_THREE_POSITION_ENABLING_STOP, configuration, this.provider.getSafetyComponent(SafetyMiscConfiguration.class), this.outFunctionComboBoxes, this.viewContext);
        configuration.addPropertyChangeListener(threePositionEnablingStopSelectedListener);
        return () -> configuration.removePropertyChangeListener(threePositionEnablingStopSelectedListener);
    }

    protected abstract BindingRegistration createAndBindInputFunctionOptionsUpdater(SafetyIOConfiguration var1);

    protected abstract BindingRegistration createAndBindOutputFunctionOptionsUpdater(SafetyIOConfiguration var1);

    private void initInputComponents(WidgetFactory factory, SafetyTextResource text) {
        this.initInputComboBoxes(factory, text);
        this.initNo3PEWhenRequiredLabel();
    }

    private void initInputComboBoxes(WidgetFactory factory, SafetyTextResource text) {
        SafetyIOConfiguration configuration = this.provider.getSafetyComponent(SafetyIOConfiguration.class);
        ChecksumVersion checksumVersion = this.getChecksumVersion();
        InputOptionsProvider inputOptionsProvider = new InputOptionsProvider(text);
        this.inFunctionComboBoxes = new ComboBox[]{factory.createComboBoxWithErrorBorder((LabelProvider)inputOptionsProvider, (Object[])configuration.getSafetyInputDropdownOptions(checksumVersion)), factory.createComboBoxWithErrorBorder((LabelProvider)inputOptionsProvider, (Object[])configuration.getSafetyInputDropdownOptions(checksumVersion)), factory.createComboBoxWithErrorBorder((LabelProvider)inputOptionsProvider, (Object[])configuration.getSafetyInputDropdownOptions(checksumVersion)), factory.createComboBoxWithErrorBorder((LabelProvider)inputOptionsProvider, (Object[])configuration.getSafetyInputDropdownOptions(checksumVersion)), new ToolSafetyInputComboBox(inputOptionsProvider, configuration.getToolSafetyInputDropdownOptions(checksumVersion))};
    }

    private void initNo3PEWhenRequiredLabel() {
        this.no3PEErrorLabel = new JXLabel(this.textResource.no3PEWhenRequiredErrorMessage());
        this.no3PEErrorLabel.setIcon(ViewImageResource.formError());
        this.no3PEErrorLabel.setLineWrap(true);
        this.no3PEErrorLabel.setFont(new FontFactory().getRelativeFont(URFontFactory.Style.ITALIC));
        this.hideNo3PEError();
    }

    public void showNo3PEError() {
        this.no3PEErrorLabel.setVisible(true);
    }

    public void hideNo3PEError() {
        this.no3PEErrorLabel.setVisible(false);
    }

    protected void initOutputComponents(WidgetFactory factory, SafetyTextResource text) {
        SafetyIOConfiguration safetyIOConfiguration = this.provider.getSafetyComponent(SafetyIOConfiguration.class);
        OutputOptionsProvider outputOptionsProvider = new OutputOptionsProvider(text);
        this.outFunctionComboBoxes = new ComboBox[]{factory.createComboBox((LabelProvider)outputOptionsProvider, (Object[])safetyIOConfiguration.getSafetyOutputDropdownOptions()), factory.createComboBox((LabelProvider)outputOptionsProvider, (Object[])safetyIOConfiguration.getSafetyOutputDropdownOptions()), factory.createComboBox((LabelProvider)outputOptionsProvider, (Object[])safetyIOConfiguration.getSafetyOutputDropdownOptions()), factory.createComboBox((LabelProvider)outputOptionsProvider, (Object[])safetyIOConfiguration.getSafetyOutputDropdownOptions())};
    }

    private String createSignalPairLabel(Pin<?> pinA, Pin<?> pinB) {
        return String.valueOf(pinA.getDefaultName()) + ", " + pinB.getDefaultName();
    }

    private ChecksumVersion getChecksumVersion() {
        return ((VersionComponent)this.provider.getSafetySetup().getComponent(VersionComponent.class)).getChecksumVersion();
    }

    private void initComponents() {
        WidgetFactory factory = this.viewContext.createWidgetFactory();
        SafetyTextResource text = (SafetyTextResource)this.viewContext.getTextResource(SafetyTextResource.class);
        Pin[] inSignalNames = this.ioService.getConfigurableDigitalInputPins();
        Pin[] toolInSignalNames = this.ioService.getToolDigitalInputPins();
        JLabel[] inputLabels = new JLabel[]{factory.createLabel(this.createSignalPairLabel(inSignalNames[0], inSignalNames[1])), factory.createLabel(this.createSignalPairLabel(inSignalNames[2], inSignalNames[3])), factory.createLabel(this.createSignalPairLabel(inSignalNames[4], inSignalNames[5])), factory.createLabel(this.createSignalPairLabel(inSignalNames[6], inSignalNames[7])), factory.createLabel(this.createSignalPairLabel(toolInSignalNames[0], toolInSignalNames[1]))};
        this.initInputComponents(factory, text);
        Pin[] outSignalNames = this.ioService.getConfigurableDigitalOutputPins();
        JLabel[] outputLabels = new JLabel[]{factory.createLabel(this.createSignalPairLabel(outSignalNames[0], outSignalNames[1])), factory.createLabel(this.createSignalPairLabel(outSignalNames[2], outSignalNames[3])), factory.createLabel(this.createSignalPairLabel(outSignalNames[4], outSignalNames[5])), factory.createLabel(this.createSignalPairLabel(outSignalNames[6], outSignalNames[7]))};
        this.initOutputComponents(factory, text);
        this.setLayout(new BoxLayout(this, 2));
        this.setAlignmentX(0.0f);
        this.add(this.createIOContent(factory, text, inputLabels, outputLabels));
    }

    protected abstract JPanel createIOContent(WidgetFactory var1, SafetyTextResource var2, JLabel[] var3, JLabel[] var4);

    Object getComboBoxSelectedItemByName(String componentName) {
        Object[] objectArray = ArrayUtils.addAll((Object[])this.inFunctionComboBoxes, (Object[])this.outFunctionComboBoxes);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object comboBox = objectArray[n2];
            if (((JComboBox)comboBox).getName().equals(componentName)) {
                return ((JComboBox)comboBox).getSelectedItem();
            }
            ++n2;
        }
        return null;
    }

    static /* synthetic */ void access$0(SafetyIOPanel safetyIOPanel) {
        safetyIOPanel.bindFormValidation();
    }

    private class SafetyIOChangeListener
    extends SafetyChangeListener.Template {
        private SafetyIOChangeListener() {
        }

        @Override
        public void safetyModified(SafetySetup setup) {
            this.updateFormValidation();
        }

        @Override
        public void safetyLoaded(SafetySetup setup) {
            this.updateFormValidation();
        }

        private void updateFormValidation() {
            SafetyIOPanel.this.deactivate();
            SafetyIOPanel.this.activate();
            if (!SafetyIOPanel.this.isShowing()) {
                SafetyIOPanel.this.deactivate();
            }
        }

        @Override
        public void safetyTolerancesReceived(SafetyComplianceTolerances tolerances) {
            SwingUtil.invokeLater(() -> SafetyIOPanel.access$0(SafetyIOPanel.this));
        }
    }
}

