/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io;

import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.robot.configuration.teachpendent.TPCapable;
import com.ur.polyscope.robot.configuration.teachpendent.TPCapableProvider;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.version.SafetyControlBoardVersionSite;
import com.ur.polyscope.viewfacade.lang.ShowIcon;
import com.ur.safety.Safety;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.io.InputFunctionOptionsUpdater;
import com.ur.safety.io.OutputFunctionOptionsUpdater;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.io.SafetyIOOutputFunction;
import com.ur.safety.io.SafetyIOPanel;
import com.ur.safety.io.ToolInputFunctionOptionsUpdater;
import com.ur.safety.io.validator.ErrorOnAutomaticModeSafeguardWithout3PE;
import com.ur.safety.io.validator.ErrorOnNo3PEWhenRequired;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.security.SafetyLockListener;
import com.ur.swing.BindingRegistration;
import com.ur.swing.ComboBox;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.dialog.AggregateDialogCreator;
import com.ur.swing.validation.FormValidation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SafetyIOPanelImpl
extends SafetyIOPanel {
    private JCheckBox[] ossdCheckBoxes;
    private SafetyControlBoardVersionSite versionSite;
    private final TPCapableProvider tpCapableProvider;
    private SafetyIOConfiguration bindedSafetyIOConfiguration;

    @Inject
    public SafetyIOPanelImpl(SafetyLock lock, ViewContext viewContext, @Safety ShowIcon showIconForParent, SafetySettingsLookupService provider, IOService ioService, SafetyControlBoardVersionSite versionSite, AggregateDialogCreator dialogCreator, TPCapableProvider tpCapableProvider) {
        super(lock, viewContext, showIconForParent, provider, ioService, dialogCreator);
        this.versionSite = versionSite;
        this.tpCapableProvider = tpCapableProvider;
        this.addLockListenerToOssdCheckboxes();
    }

    private void addLockListenerToOssdCheckboxes() {
        class OssdSafetyLockListener
        implements SafetyLockListener {
            OssdSafetyLockListener() {
            }

            @Override
            public void doUnlock() {
                int i = 0;
                while (i != SafetyIOPanelImpl.this.ossdCheckBoxes.length) {
                    SafetyIOPanelImpl.this.ossdCheckBoxes[i].setEnabled(SafetyIOPanelImpl.this.enableOssdSetting(SafetyIOPanelImpl.this.outFunctionComboBoxes[i].getSelectedItem()));
                    ++i;
                }
            }

            @Override
            public void doLock() {
                int i = 0;
                while (i != SafetyIOPanelImpl.this.ossdCheckBoxes.length) {
                    SafetyIOPanelImpl.this.ossdCheckBoxes[i].setEnabled(false);
                    ++i;
                }
            }
        }
        this.lock.addSafetyLockListener(new OssdSafetyLockListener());
    }

    @Override
    protected JPanel createIOContent(WidgetFactory factory, SafetyTextResource text, JLabel[] inputLabels, JLabel[] outputLabels) {
        FormBuilder formBuilder = this.viewContext.createFormBuilder().end();
        this.createSafetyInputLayout(factory, formBuilder, text, inputLabels);
        this.createSafetyOutputLayout(factory, formBuilder, text, outputLabels);
        JPanel panel = formBuilder.getPanel();
        panel.setBorder(new EmptyBorder(15, 75, 15, 75));
        return panel;
    }

    private void createSafetyInputLayout(WidgetFactory widgetFactory, FormBuilder formBuilder, SafetyTextResource text, JLabel[] inputLabels) {
        formBuilder.columnTitle(text.safetyHeaderInputSignal(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).columnTitle(text.safetyHeaderFunction(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).spacer(2).end().component(widgetFactory.createSeparator(SafetyIOPanel.SEPARATOR_COLOR), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_9_COLUMNS}).end().component((JComponent)inputLabels[0], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.inFunctionComboBoxes[0], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).spacer(2).end().component((JComponent)inputLabels[1], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.inFunctionComboBoxes[1], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).spacer(2).end().component((JComponent)inputLabels[2], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.inFunctionComboBoxes[2], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).spacer(2).end().component((JComponent)inputLabels[3], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.inFunctionComboBoxes[3], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).spacer(2).end().component((JComponent)inputLabels[4], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.inFunctionComboBoxes[4], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).spacer(2).end().component((JComponent)this.no3PEErrorLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_9_COLUMNS, FormBuilder.PanelConstraints.SPAN_3_ROWS}).end().end().end();
    }

    private void createSafetyOutputLayout(WidgetFactory widgetFactory, FormBuilder formBuilder, SafetyTextResource text, JLabel[] outputLabels) {
        formBuilder.columnTitle(text.safetyHeaderOutputSignal(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).columnTitle(text.safetyHeaderFunction(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).spacer().columnTitle(text.ossd(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).end().component(widgetFactory.createSeparator(SafetyIOPanel.SEPARATOR_COLOR), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_9_COLUMNS}).end().component((JComponent)outputLabels[0], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outFunctionComboBoxes[0], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).spacer().component((JComponent)this.ossdCheckBoxes[0], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).end().component((JComponent)outputLabels[1], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outFunctionComboBoxes[1], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).spacer().component((JComponent)this.ossdCheckBoxes[1], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).end().component((JComponent)outputLabels[2], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outFunctionComboBoxes[2], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).spacer().component((JComponent)this.ossdCheckBoxes[2], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).end().component((JComponent)outputLabels[3], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outFunctionComboBoxes[3], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).spacer().component((JComponent)this.ossdCheckBoxes[3], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).end();
    }

    @Override
    protected BindingRegistration createAndBindOutputFunctionOptionsUpdater(SafetyIOConfiguration configuration) {
        OutputFunctionOptionsUpdater updateOutputFunctionOptions = new OutputFunctionOptionsUpdater(this.provider, (JComboBox[])this.outFunctionComboBoxes);
        configuration.addPropertyChangeListener(updateOutputFunctionOptions);
        return () -> configuration.removePropertyChangeListener(updateOutputFunctionOptions);
    }

    @Override
    protected BindingRegistration createAndBindInputFunctionOptionsUpdater(SafetyIOConfiguration configuration) {
        ComboBox[] configurableInputPins = new ComboBox[]{this.inFunctionComboBoxes[0], this.inFunctionComboBoxes[1], this.inFunctionComboBoxes[2], this.inFunctionComboBoxes[3]};
        ComboBox[] toolInputPins = new ComboBox[]{this.inFunctionComboBoxes[4]};
        InputFunctionOptionsUpdater updateInputFunctionOptions = new InputFunctionOptionsUpdater(this.provider, this.versionSite, (JComboBox[])configurableInputPins);
        ToolInputFunctionOptionsUpdater updateToolInputFunctionOptions = new ToolInputFunctionOptionsUpdater(this.provider, this.versionSite, (JComboBox[])toolInputPins);
        configuration.addPropertyChangeListener(updateInputFunctionOptions);
        configuration.addPropertyChangeListener(updateToolInputFunctionOptions);
        return () -> {
            configuration.removePropertyChangeListener(updateInputFunctionOptions);
            configuration.removePropertyChangeListener(updateToolInputFunctionOptions);
        };
    }

    @Override
    void addAdditionalFormValidation() {
        this.initiateOssdComponents();
        this.validateAutomaticModeSafeguard(this.provider);
        this.validate3PERequired(this.provider);
    }

    private void initiateOssdComponents() {
        this.bindedSafetyIOConfiguration = this.getSafetyIOConfiguration();
        int i = 0;
        while (i != this.outFunctionComboBoxes.length) {
            this.ossdCheckBoxes[i].setEnabled(this.enableOssdSetting(this.outFunctionComboBoxes[i].getSelectedItem()));
            this.ossdCheckBoxes[i].setSelected(this.bindedSafetyIOConfiguration.hasOSSD(i));
            ++i;
        }
    }

    private void validateAutomaticModeSafeguard(SafetySettingsLookupService provider) {
        ComboBox[] comboBoxArray = this.inFunctionComboBoxes;
        int n = this.inFunctionComboBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            ComboBox inFunctionComboBox = comboBoxArray[n2];
            this.safetyFormValidation.addErrorValidation((JComponent)inFunctionComboBox, (FormValidation.Validator)new ErrorOnAutomaticModeSafeguardWithout3PE(provider.getSafetySetup(), inFunctionComboBox, this.textResource));
            ++n2;
        }
    }

    private void validate3PERequired(SafetySettingsLookupService provider) {
        SafetySetup safetySetup = provider.getSafetySetup();
        this.tpCapableProvider.getTPCapable().ifPresent(tpCapable -> this.safetyFormValidation.addErrorValidation((JComponent)this, (FormValidation.Validator)new ErrorOnNo3PEWhenRequired(safetySetup, (TPCapable)tpCapable, this)));
    }

    @Override
    protected void initOutputComponents(WidgetFactory factory, SafetyTextResource text) {
        super.initOutputComponents(factory, text);
        this.initOssdComponents();
    }

    private void initOssdComponents() {
        this.ossdCheckBoxes = new JCheckBox[]{new JCheckBox(), new JCheckBox(), new JCheckBox(), new JCheckBox()};
        int i = 0;
        while (i != this.ossdCheckBoxes.length) {
            ComboBox ioComboBox = this.outFunctionComboBoxes[i];
            JCheckBox ossdCheckbox = this.ossdCheckBoxes[i];
            new OssdListener((JComboBox)ioComboBox, ossdCheckbox, i);
            ++i;
        }
    }

    JCheckBox[] getOssdCheckBoxes() {
        return (JCheckBox[])this.ossdCheckBoxes.clone();
    }

    private boolean enableOssdSetting(Object o) {
        return o instanceof SafetyIOOutputFunction && this.enableOssdSetting((SafetyIOOutputFunction)((Object)o));
    }

    private boolean enableOssdSetting(SafetyIOOutputFunction function) {
        return !this.lock.isLocked() && function != SafetyIOOutputFunction.UNASSIGNED;
    }

    private class OssdListener
    implements ActionListener {
        private final int index;
        private final JComboBox comboBox;
        private final JCheckBox checkbox;

        OssdListener(JComboBox comboBox, JCheckBox checkbox, int index) {
            this.comboBox = comboBox;
            this.checkbox = checkbox;
            this.index = index;
            this.addListener();
        }

        private void addListener() {
            this.comboBox.addActionListener(this);
            this.checkbox.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SafetyIOPanelImpl.this.enableOssdSetting(this.comboBox.getSelectedItem())) {
                this.checkbox.setEnabled(true);
            } else {
                this.checkbox.setEnabled(false);
                this.checkbox.setSelected(false);
            }
            this.updateModel();
        }

        private void updateModel() {
            if (SafetyIOPanelImpl.this.bindedSafetyIOConfiguration != null) {
                boolean oldValue = SafetyIOPanelImpl.this.bindedSafetyIOConfiguration.hasOSSD(this.index);
                boolean newValue = this.checkbox.isSelected();
                if (newValue != oldValue) {
                    SafetyIOPanelImpl.this.bindedSafetyIOConfiguration.setOSSD(this.index, newValue);
                }
            }
        }
    }
}

