/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io;

import com.ur.i18n.TextResource;
import com.ur.polyscope.pin.ConfigurableIOPin;
import com.ur.polyscope.pin.ConfigurableName;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.util.Optional;
import javax.inject.Inject;

public class SafetyNameProvider
implements ConfigurableName {
    private TextResource resource;
    private SafetySettingsLookupService lookupService;

    @Inject
    public SafetyNameProvider(TextResource textResource, SafetySettingsLookupService lookupService) {
        this.resource = textResource;
        this.lookupService = lookupService;
    }

    public boolean isNamed(ConfigurableIOPin pin) {
        if (pin.isInput()) {
            return this.ioConfiguration().isInputAssigned(pin.getPin());
        }
        return this.ioConfiguration().isOutputAssigned(pin.getPin());
    }

    public String getShortFunctionName(ConfigurableIOPin pin) {
        if (pin.isUnassigned()) {
            return "";
        }
        SafetyIOConfiguration ioConfiguration = this.ioConfiguration();
        if (pin.isInput()) {
            return this.getShortFunctionNameForInput(ioConfiguration, pin);
        }
        return this.getShortFunctionNameForOutput(ioConfiguration, pin);
    }

    private String getShortFunctionNameForInput(SafetyIOConfiguration ioConfiguration, ConfigurableIOPin pin) {
        if (ioConfiguration.getEmergencyStopInputs().hasPin(pin.getPin())) {
            return "E-Stop";
        }
        if (ioConfiguration.getReducedModeInputs().hasPin(pin.getPin())) {
            return "Reduced";
        }
        if (ioConfiguration.getSafeguardStopResetInputs().hasPin(pin.getPin())) {
            return "S-Guard Reset";
        }
        if (ioConfiguration.getThreePositionEnablingInputs().hasPin(pin.getPin())) {
            return "3-Position";
        }
        if (ioConfiguration.getOperationalModeInputs().hasPin(pin.getPin())) {
            return "Mode-Select";
        }
        if (ioConfiguration.getAutomaticModeSafeguardStopInputs().hasPin(pin.getPin())) {
            return "Auto S-Guard Stop";
        }
        if (ioConfiguration.getAutomaticModeSafeguardStopResetInputs().hasPin(pin.getPin())) {
            return "Auto S-Guard Reset";
        }
        if (ioConfiguration.getFreedriveOnRobotInputs().hasPin(pin.getPin())) {
            return "Freedrive";
        }
        return "";
    }

    private String getShortFunctionNameForOutput(SafetyIOConfiguration ioConfiguration, ConfigurableIOPin pin) {
        if (ioConfiguration.getRobotMovingOutputs().hasPin(pin.getPin())) {
            return "Moving";
        }
        if (ioConfiguration.getRobotNotStoppingOutputs().hasPin(pin.getPin())) {
            return "Not Stopping";
        }
        if (this.ioConfiguration().getSystemEmergencyStopOutputs().hasPin(pin.getPin())) {
            return "E-Stop";
        }
        if (this.ioConfiguration().getReducedModeOutputs().hasPin(pin.getPin())) {
            return "Reduced";
        }
        if (this.ioConfiguration().getNotReducedModeOutputs().hasPin(pin.getPin())) {
            return "Not Reduced";
        }
        if (ioConfiguration.getSafeHomeOutputs().hasPin(pin.getPin())) {
            return "Safe Home";
        }
        if (ioConfiguration.getThreePositionEnablingStopOutputs().hasPin(pin.getPin())) {
            return "3PE Stop";
        }
        if (ioConfiguration.getNoThreePositionEnablingStopOutputs().hasPin(pin.getPin())) {
            return "No 3PE Stop";
        }
        return "";
    }

    public String getFunctionName(ConfigurableIOPin pin) {
        if (pin.isUnassigned()) {
            return "";
        }
        SafetyIOConfiguration ioConfiguration = this.ioConfiguration();
        if (pin.isInput()) {
            return this.getFunctionNameForInput(ioConfiguration, pin);
        }
        return this.getFunctionNameForOutput(ioConfiguration, pin);
    }

    private String getFunctionNameForInput(SafetyIOConfiguration ioConfiguration, ConfigurableIOPin pin) {
        if (ioConfiguration.getEmergencyStopInputs().hasPin(pin.getPin())) {
            return this.resource.emergencyStop();
        }
        if (ioConfiguration.getReducedModeInputs().hasPin(pin.getPin())) {
            return this.resource.reducedMode();
        }
        if (ioConfiguration.getSafeguardStopResetInputs().hasPin(pin.getPin())) {
            return this.resource.safeGuardReset();
        }
        if (ioConfiguration.getThreePositionEnablingInputs().hasPin(pin.getPin())) {
            return this.resource.threePositionEnablingInput();
        }
        if (ioConfiguration.getOperationalModeInputs().hasPin(pin.getPin())) {
            return this.resource.operationalModeInput();
        }
        if (ioConfiguration.getAutomaticModeSafeguardStopInputs().hasPin(pin.getPin())) {
            return this.resource.automaticModeSafeguardStopInput();
        }
        if (ioConfiguration.getAutomaticModeSafeguardStopResetInputs().hasPin(pin.getPin())) {
            return this.resource.automaticModeSafeguardStopResetInput();
        }
        if (ioConfiguration.getFreedriveOnRobotInputs().hasPin(pin.getPin())) {
            return this.resource.freedriveOnRobotInput();
        }
        return "";
    }

    private String getFunctionNameForOutput(SafetyIOConfiguration ioConfiguration, ConfigurableIOPin pin) {
        if (ioConfiguration.getRobotMovingOutputs().hasPin(pin.getPin())) {
            return this.resource.robotMoving();
        }
        if (ioConfiguration.getRobotNotStoppingOutputs().hasPin(pin.getPin())) {
            return this.resource.robotNotStopping();
        }
        if (this.ioConfiguration().getSystemEmergencyStopOutputs().hasPin(pin.getPin())) {
            return this.resource.systemEmergencyStop();
        }
        if (this.ioConfiguration().getReducedModeOutputs().hasPin(pin.getPin())) {
            return this.resource.reducedMode();
        }
        if (this.ioConfiguration().getNotReducedModeOutputs().hasPin(pin.getPin())) {
            return this.resource.notReducedMode();
        }
        if (ioConfiguration.getSafeHomeOutputs().hasPin(pin.getPin())) {
            return this.resource.safeHome();
        }
        if (ioConfiguration.getThreePositionEnablingStopOutputs().hasPin(pin.getPin())) {
            return this.resource.threePositionEnablingStop();
        }
        if (ioConfiguration.getNoThreePositionEnablingStopOutputs().hasPin(pin.getPin())) {
            return this.resource.noThreePositionEnablingStop();
        }
        return "";
    }

    private SafetyIOConfiguration ioConfiguration() {
        return (SafetyIOConfiguration)this.getSafetySetup().getComponent(SafetyIOConfiguration.class);
    }

    private SafetySetup getSafetySetup() {
        Optional<SafetySetup> controllerSafetySetup = this.lookupService.getControllerSafetySetup();
        if (controllerSafetySetup.isPresent()) {
            return (SafetySetup)controllerSafetySetup.get();
        }
        return this.lookupService.getSafetySetup();
    }
}

