/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io;

import com.ur.safety.SafetyTextResource;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.io.SafetyIOOutputFunction;
import com.ur.safety.misc.core.SafetyMiscConfiguration;
import com.ur.swing.ComboBox;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.ViewContext;
import com.ur.view.constants.dev.TPType;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class ThreePositionEnablingStopSelectedListener
implements PropertyChangeListener {
    private final SafetyIOConfiguration safetyIOConfiguration;
    private final SafetyMiscConfiguration safetyMiscConfiguration;
    private final ComboBox[] outputFunctionComboBoxes;
    private final SafetyTextResource textResource;
    private final SafetyIOOutputFunction function;
    private boolean is3PEStopSelected;

    public ThreePositionEnablingStopSelectedListener(SafetyIOOutputFunction function, SafetyIOConfiguration safetyIOConfiguration, SafetyMiscConfiguration safetyMiscConfiguration, ComboBox[] outputFunctionComboBoxes, ViewContext viewContext) {
        this.function = function;
        ThreePositionEnablingStopSelectedListener.validateFunction(function);
        this.safetyIOConfiguration = safetyIOConfiguration;
        this.safetyMiscConfiguration = safetyMiscConfiguration;
        this.outputFunctionComboBoxes = outputFunctionComboBoxes;
        this.textResource = (SafetyTextResource)viewContext.getTextResource(SafetyTextResource.class);
        this.is3PEStopSelected = this.isAssigned();
    }

    private boolean isAssigned() {
        return this.function == SafetyIOOutputFunction.THREE_POSITION_ENABLING_STOP ? this.safetyIOConfiguration.getThreePositionEnablingStopOutputs().isAssigned() : this.safetyIOConfiguration.getNoThreePositionEnablingStopOutputs().isAssigned();
    }

    private static void validateFunction(SafetyIOOutputFunction function) {
        if (function != SafetyIOOutputFunction.THREE_POSITION_ENABLING_STOP && function != SafetyIOOutputFunction.NO_THREE_POSITION_ENABLING_STOP) {
            throw new IllegalArgumentException("Invalid function for ThreePositionEnablingStopSelectedListener: " + (Object)((Object)function));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.hasSelectionChangedFromUnassignedToAssigned() && this.is3PEDeviceConfigMissing()) {
            this.showThreePositionEnablingStopWarning();
        }
        this.is3PEStopSelected = this.isAssigned();
    }

    private boolean is3PEDeviceConfigMissing() {
        return !this.safetyIOConfiguration.getThreePositionEnablingInputs().isAssigned() && !this.safetyMiscConfiguration.getTeachPendant().equals((Object)TPType.THREE_POSITION_ENABLING);
    }

    private boolean hasSelectionChangedFromUnassignedToAssigned() {
        return !this.is3PEStopSelected && this.isAssigned();
    }

    private void showThreePositionEnablingStopWarning() {
        DisplayMessageFactory.messageWithTitle((JComponent)this.getComboBoxWithFocus(), (String)this.textResource.Warning(), (String)this.textResource.threePositionEnablingStopWarning(), (int)350);
    }

    private JComboBox getComboBoxWithFocus() {
        return Arrays.stream(this.outputFunctionComboBoxes).filter(Component::hasFocus).findFirst().orElse(null);
    }
}

