/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io.validator;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.io.SafetyIOInputFunction;
import com.ur.safety.misc.core.SafetyMiscConfiguration;
import com.ur.swing.ComboBox;
import com.ur.swing.validation.FormValidation;
import com.ur.view.constants.dev.TPType;

public class ErrorOnAutomaticModeSafeguardWithout3PE
implements FormValidation.Validator {
    private SafetySetup safetySetup;
    private final ComboBox comboBox;
    private SafetyTextResource textResource;

    public ErrorOnAutomaticModeSafeguardWithout3PE(SafetySetup safetySetup, ComboBox comboBox, SafetyTextResource textResource) {
        this.safetySetup = safetySetup;
        this.comboBox = comboBox;
        this.textResource = textResource;
    }

    public void validate() {
        if (this.isAutomaticModeSafeguardSelected()) {
            if (this.isAutomaticModeSafeguardAssignedWithout3PEAssigned()) {
                this.comboBox.setError(this.textResource.automaticModeSafeguardWithout3PEError());
            } else {
                this.comboBox.clearError();
            }
        } else {
            this.comboBox.clearError();
        }
    }

    protected boolean isAutomaticModeSafeguardSelected() {
        return EqualsUtil.equalsOneOf((Object)this.comboBox.getSelectedItem(), (Object[])new SafetyIOInputFunction[]{SafetyIOInputFunction.AUTOMATIC_MODE_SAFEGUARD_STOP, SafetyIOInputFunction.AUTOMATIC_MODE_SAFEGUARD_STOP_RESET});
    }

    protected boolean isAutomaticModeSafeguardAssignedWithout3PEAssigned() {
        return this.isAutomaticModeSafeguardInputsConfigured() && this.isExternal3PENotConfigured() && this.is3PETeachPendantNotConfigured();
    }

    private boolean isAutomaticModeSafeguardInputsConfigured() {
        SafetyIOConfiguration ioConfiguration = (SafetyIOConfiguration)this.safetySetup.getComponent(SafetyIOConfiguration.class);
        return ioConfiguration.getAutomaticModeSafeguardStopInputs().isAssigned() || ioConfiguration.getAutomaticModeSafeguardStopResetInputs().isAssigned();
    }

    private boolean isExternal3PENotConfigured() {
        SafetyIOConfiguration ioConfiguration = (SafetyIOConfiguration)this.safetySetup.getComponent(SafetyIOConfiguration.class);
        return ioConfiguration.getThreePositionEnablingInputs().isUnassigned();
    }

    private boolean is3PETeachPendantNotConfigured() {
        SafetyMiscConfiguration miscConfiguration = (SafetyMiscConfiguration)this.safetySetup.getComponent(SafetyMiscConfiguration.class);
        return miscConfiguration.getTeachPendant() != TPType.THREE_POSITION_ENABLING;
    }

    public boolean isValid() {
        return !this.comboBox.hasError();
    }

    public void clearValidation() {
        this.comboBox.clearError();
    }
}

