/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io.validator;

import com.ur.polyscope.robot.configuration.teachpendent.TPCapable;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.io.SafetyIOPanel;
import com.ur.safety.misc.core.SafetyMiscConfiguration;
import com.ur.swing.validation.FormValidation;
import com.ur.view.constants.dev.TPType;

public class ErrorOnNo3PEWhenRequired
implements FormValidation.Validator {
    private final SafetySetup safetySetup;
    private final TPCapable tpCapable;
    private final SafetyIOPanel safetyIOPanel;
    private boolean isValid;

    public ErrorOnNo3PEWhenRequired(SafetySetup safetySetup, TPCapable tpCapable, SafetyIOPanel safetyIOPanel) {
        this.safetySetup = safetySetup;
        this.tpCapable = tpCapable;
        this.safetyIOPanel = safetyIOPanel;
        this.isValid = true;
    }

    public void validate() {
        if (this.tpCapable.requires3PEConfigured() && this.isNoneSelected() && this.isExternal3PENotConfigured()) {
            this.isValid = false;
            this.safetyIOPanel.showNo3PEError();
        } else {
            this.clearValidation();
        }
    }

    private boolean isExternal3PENotConfigured() {
        SafetyIOConfiguration ioConfiguration = (SafetyIOConfiguration)this.safetySetup.getComponent(SafetyIOConfiguration.class);
        return ioConfiguration.getThreePositionEnablingInputs().isUnassigned();
    }

    private boolean isNoneSelected() {
        SafetyMiscConfiguration miscConfiguration = (SafetyMiscConfiguration)this.safetySetup.getComponent(SafetyMiscConfiguration.class);
        return TPType.NONE.equals((Object)miscConfiguration.getTeachPendant());
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void clearValidation() {
        this.isValid = true;
        this.safetyIOPanel.hideNo3PEError();
    }
}

