/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.io.validator;

import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.io.SafetyIOInputFunction;
import com.ur.swing.ComboBox;
import com.ur.swing.validation.FormValidation;
import java.util.Arrays;

public class ErrorOnUnsupportedToolSafetyInput
implements FormValidation.Validator {
    private final ComboBox<SafetyIOInputFunction> comboBox;
    private final SafetyTextResource textResource;
    private final SafetyIOConfiguration configuration;
    private final ChecksumVersion checksumVersion;

    public ErrorOnUnsupportedToolSafetyInput(ComboBox<SafetyIOInputFunction> comboBox, SafetyTextResource textResource, SafetyIOConfiguration configuration, ChecksumVersion checksumVersion) {
        this.comboBox = comboBox;
        this.textResource = textResource;
        this.configuration = configuration;
        this.checksumVersion = checksumVersion;
    }

    public void validate() {
        SafetyIOInputFunction[] supportedOptions = this.configuration.getToolSafetyInputDropdownOptions(this.checksumVersion);
        SafetyIOInputFunction selectedItem = (SafetyIOInputFunction)((Object)this.comboBox.getSelectedItem());
        if (Arrays.asList(supportedOptions).contains((Object)selectedItem)) {
            this.comboBox.clearError();
        } else {
            this.comboBox.setError(this.textResource.unsupportedEoASafetyInputFunction());
        }
    }

    public boolean isValid() {
        return !this.comboBox.hasError();
    }

    public void clearValidation() {
        this.comboBox.clearError();
    }
}

