/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.jointlimits;

import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.RobotTool;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.viewfacade.lang.Errorable;
import com.ur.polyscope.viewfacade.lang.ShowIcon;
import com.ur.resources.ViewImageResource;
import com.ur.safety.RebindWhenReducedAndNonReducedModeAvailable;
import com.ur.safety.Safety;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.jointlimits.JointLimitsPanel;
import com.ur.safety.jointlimits.JointPositionRangePanel;
import com.ur.safety.jointlimits.JointSpeedLimitsPanel;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.tolerances.SafetyComplianceTolerances;
import com.ur.safety.util.domain.UpdateParentWithFormState;
import com.ur.swing.SwingUtil;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.validation.FormValidation;
import com.ur.util.event.EventNotificationService;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.jdesktop.swingx.VerticalLayout;

public class JointLimitsPanelImpl
extends JointLimitsPanel
implements Errorable {
    private final RebindWhenReducedAndNonReducedModeAvailable reducedModeAvailablelistener;
    private final UpdateParentWithCombinedFormState statusOfForm;
    private final UpdateParentWithFormState statusOfPositionLimits;
    private final UpdateParentWithFormState statusOfSpeedLimits;
    private final SafetyLock safetyLock;
    private ViewContext viewContext;
    private final SafetyTextResource textResource;
    private final SafetySettingsLookupService safetySettingsLookupService;
    private JLabel explanationOfJointLimits;
    private JLabel maxSpeedStateLabel;
    private JointSpeedLimitsPanel maxSpeedTable;
    private JointPositionRangePanel rangePositionTable;
    private JLabel postionRangeStateLabel;
    private final RobotTool robotTool;
    private final HelpIdAssigner helpIdAssigner;
    private final JointConfigurationSettings jointConfigurationSettings;

    @Inject
    public JointLimitsPanelImpl(SafetyLock lock, ViewContext viewContext, @Safety ShowIcon showIconForParent, SafetySettingsLookupService safetySettingsProvider, RobotConfigurationProvider robot, JointConfigurationSettings jointConfigurationSettings) {
        this.safetyLock = lock;
        this.viewContext = viewContext;
        this.textResource = (SafetyTextResource)viewContext.getTextResource(SafetyTextResource.class);
        this.safetySettingsLookupService = safetySettingsProvider;
        this.jointConfigurationSettings = jointConfigurationSettings;
        viewContext.getFontFactory();
        this.robotTool = robot.getRobotTool();
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
        this.reducedModeAvailablelistener = new BindAgainWhenReducedModeStateHasChanged(this.safetySettingsLookupService);
        ShowIcon showIconForSubPanel = new ShowIcon(){

            public void show(Icon thisIcon, Component forChildComponent) {
                this.setIcon(forChildComponent, thisIcon);
            }

            public void clearIcon(Component forChildComponent) {
                this.setIcon(forChildComponent, ViewImageResource.blank());
            }

            private void setIcon(Component forChildComponent, Icon thisIcon) {
                ((JLabel)forChildComponent).setIcon(thisIcon);
            }
        };
        EventNotificationService.register((Object)this, SafetyChangeListener.class, (Object)new JointLimitsChangeListener());
        this.initComponents();
        this.statusOfForm = new UpdateParentWithCombinedFormState(showIconForParent, this);
        this.statusOfPositionLimits = new UpdateParentWithFormState(showIconForSubPanel, this.postionRangeStateLabel);
        this.statusOfSpeedLimits = new UpdateParentWithFormState(showIconForSubPanel, this.maxSpeedStateLabel);
        this.initHelpIds();
        this.bindFormValidation();
    }

    private void initHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this.explanationOfJointLimits, "gui:installation_safety_joint_limits");
        this.helpIdAssigner.assignHelpId((JComponent)this.maxSpeedTable, "gui:installation_safety_joint_limits_maximum_speed");
        this.helpIdAssigner.assignHelpId((JComponent)this.rangePositionTable, "gui:installation_safety_joint_limits_position_range");
    }

    @Override
    public void activate() {
        this.bindFormValidation();
        this.maxSpeedTable.activate();
        this.rangePositionTable.activate();
    }

    @Override
    public void deactivate() {
        this.maxSpeedTable.deactivate();
        this.rangePositionTable.deactivate();
    }

    protected synchronized void bindFormValidation() {
        SafetySetup safetySetup = this.safetySettingsLookupService.getSafetySetup();
        if (safetySetup != null) {
            this.maxSpeedTable.bindFormValidation(this.statusOfForm, this.statusOfSpeedLimits);
            this.rangePositionTable.bindFormValidation(this.statusOfForm, this.statusOfPositionLimits);
            safetySetup.addPropertyChangeListener((PropertyChangeListener)this.reducedModeAvailablelistener);
        }
    }

    @Override
    public Errorable.Status getStatus() {
        return this.statusOfForm.getOverallStatus();
    }

    @Override
    public void addStatusListener(Errorable.StatusListener listener) {
        this.statusOfForm.addStatusListener(listener);
    }

    @Override
    public void removeStatusListener(Errorable.StatusListener listener) {
        this.statusOfForm.removeStatusListener(listener);
    }

    private void initComponents() {
        this.maxSpeedStateLabel = new JLabel();
        this.postionRangeStateLabel = new JLabel();
        this.maxSpeedTable = this.fixCompoundBorder(new JointSpeedLimitsPanel(this.viewContext, this.safetySettingsLookupService, this.safetyLock, this.jointConfigurationSettings));
        this.rangePositionTable = this.fixCompoundBorder(new JointPositionRangePanel(this, this.viewContext, this.safetySettingsLookupService, this.safetyLock, this.robotTool, this.jointConfigurationSettings));
        this.setLayout((LayoutManager)new VerticalLayout(5));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.maxSpeedStateLabel.setText(" ");
        this.postionRangeStateLabel.setText(" ");
        this.explanationOfJointLimits = new JLabel(this.textResource.safetyLimitsExplainJointLimits());
        this.add(this.rangePositionTable);
        this.add(this.maxSpeedTable);
    }

    private <T extends JPanel> T fixCompoundBorder(T panel) {
        CompoundBorder border = (CompoundBorder)panel.getBorder();
        panel.setBorder(new CompoundBorder(border.getOutsideBorder(), new EmptyBorder(8, 10, 4, 10)));
        return panel;
    }

    private class BindAgainWhenReducedModeStateHasChanged
    extends RebindWhenReducedAndNonReducedModeAvailable {
        BindAgainWhenReducedModeStateHasChanged(SafetySettingsLookupService safetySettingsLookupService) {
            super(safetySettingsLookupService);
        }

        @Override
        protected void rebindFormValidation() {
            JointLimitsPanelImpl.this.bindFormValidation();
        }
    }

    private class JointLimitsChangeListener
    extends SafetyChangeListener.Template {
        private JointLimitsChangeListener() {
        }

        @Override
        public void safetyLoaded(SafetySetup setup) {
            SwingUtil.invokeLater(() -> {
                JointLimitsPanelImpl.this.reducedModeAvailablelistener.initReducedModeCapable();
                JointLimitsPanelImpl.this.activate();
            });
        }

        @Override
        public void safetyTolerancesReceived(SafetyComplianceTolerances tolerances) {
            SwingUtil.invokeLater(() -> JointLimitsPanelImpl.this.bindFormValidation());
        }
    }

    private static class UpdateParentWithCombinedFormState
    implements FormValidation.FormListener<JComponent> {
        private final ShowIcon showIconForParent;
        private final JointLimitsPanelImpl panel;
        private final List<Errorable.StatusListener> statusListeners = new ArrayList<Errorable.StatusListener>();
        private final List<FormValidation<JComponent>> validations = new ArrayList<FormValidation<JComponent>>();
        private final Errorable.Status[] status = new Errorable.Status[]{Errorable.Status.OK, Errorable.Status.OK, Errorable.Status.OK};

        UpdateParentWithCombinedFormState(ShowIcon showIconForParent, JointLimitsPanelImpl panel) {
            this.showIconForParent = showIconForParent;
            this.panel = panel;
        }

        public void formHasError(FormValidation<JComponent> validation) {
            if (!this.validations.contains(validation)) {
                this.validations.add(validation);
            }
            this.status[this.validations.indexOf(validation)] = Errorable.Status.ERROR;
            this.updatePanel();
        }

        public void formHasWarning(FormValidation<JComponent> validation) {
            if (!this.validations.contains(validation)) {
                this.validations.add(validation);
            }
            this.status[this.validations.indexOf(validation)] = Errorable.Status.WARNING;
            this.updatePanel();
        }

        public void formIsOK(FormValidation<JComponent> validation) {
            if (!this.validations.contains(validation)) {
                this.validations.add(validation);
            }
            this.status[this.validations.indexOf(validation)] = Errorable.Status.OK;
            this.updatePanel();
        }

        private void updatePanel() {
            Errorable.Status overallStatus = this.getOverallStatus();
            this.showActiveStatus(overallStatus);
            for (Errorable.StatusListener each : this.statusListeners) {
                each.statusChanged(overallStatus);
            }
        }

        Errorable.Status getOverallStatus() {
            Errorable.Status overallStatus = Errorable.Status.OK;
            Errorable.Status[] statusArray = this.status;
            int n = this.status.length;
            int n2 = 0;
            while (n2 < n) {
                Errorable.Status each = statusArray[n2];
                if (each == Errorable.Status.ERROR) {
                    overallStatus = Errorable.Status.ERROR;
                    break;
                }
                if (each == Errorable.Status.WARNING) {
                    overallStatus = Errorable.Status.WARNING;
                }
                ++n2;
            }
            return overallStatus;
        }

        private void showActiveStatus(Errorable.Status overallStatus) {
            switch (overallStatus) {
                case OK: {
                    this.showIconForParent.clearIcon((Component)this.panel);
                    break;
                }
                case WARNING: {
                    this.showIconForParent.show(ViewImageResource.formWarning(), (Component)this.panel);
                    break;
                }
                case ERROR: {
                    this.showIconForParent.show(ViewImageResource.formError(), (Component)this.panel);
                }
            }
        }

        public void addStatusListener(Errorable.StatusListener listener) {
            if (!this.statusListeners.contains(listener)) {
                this.statusListeners.add(listener);
            }
        }

        public void removeStatusListener(Errorable.StatusListener listener) {
            this.statusListeners.remove(listener);
        }
    }
}

