/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.jointlimits;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.HTMLPage;
import com.ur.safety.SafetySetupPanesLookAndFeel;
import com.ur.safety.SafetySetupToHtmlContribution;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.generallimits.core.SafetyLimits;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.safety.util.domain.AlternatingBackgroundRowGenerator;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.util.swing.HTML;
import java.text.DecimalFormat;
import javax.inject.Inject;

public class JointLimitsToHtmlRenderer
implements SafetySetupToHtmlContribution {
    private final SafetyTextResource translation;
    private final SafetySetupPanesLookAndFeel lookAndFeel;
    private UnitsConverter jointSpeedConverter;
    private UnitsConverter jointPositionConverter;
    private DecimalFormat degFormat;
    private AlternatingBackgroundRowGenerator rowGenerator;

    @Inject
    public JointLimitsToHtmlRenderer(SafetyTextResource translation, SafetySetupPanesLookAndFeel lookAndFeel) {
        this.translation = translation;
        this.lookAndFeel = lookAndFeel;
    }

    @Override
    public HTMLPage createContributedPage(SafetySetup safetySetup, boolean useSIUnits) {
        this.degFormat = useSIUnits ? DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.0000") : PrimitiveUtils.WHOLE_NUMBER_FORMAT;
        this.jointSpeedConverter = useSIUnits ? Units.getRadiansPerSecondConverterSI() : Units.getDegreesPerSecondConverter();
        this.jointPositionConverter = useSIUnits ? Units.getRadiansConverter() : Units.getDegreesConverter();
        this.rowGenerator = new AlternatingBackgroundRowGenerator();
        SafetyLimits normalMode = ((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class)).getNormalLimits();
        SafetyLimits reducedMode = ((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class)).getReducedLimits();
        if (safetySetup.isReducedModeDefined() || useSIUnits) {
            return new HTMLPage(this.translation.safetyTabJointLimits(), this.generateJointLimits(normalMode, reducedMode));
        }
        return new HTMLPage(this.translation.safetyTabJointLimits(), this.generateJointLimits(normalMode));
    }

    private String generateJointLimits(SafetyLimits normalMode, SafetyLimits reducedMode) {
        return HTML.table((int)this.lookAndFeel.panelWidth, (String[])new String[]{HTML.tableRow((String[])new String[]{HTML.tableHeaderSpacer(), HTML.tableHeaderWithProperties((String)"align=center colspan=3", (String)this.translation.maxSpeed()), HTML.tableHeaderWithProperties((String)"align=center colspan=3", (String)this.translation.position())}), HTML.tableRow((String[])new String[]{HTML.tableHeaderWithProperties((String)"align=left", (String)this.translation.jointColumnHeader()), HTML.tableHeaderWithProperties((String)"align=center", (String)this.translation.normalModeColumnHeader()), HTML.tableHeaderWithProperties((String)"align=center colspan=2", (String)this.translation.reducedModeColumnHeader()), HTML.tableHeaderWithProperties((String)"align=center", (String)this.translation.normalModeColumnHeader()), HTML.tableHeaderWithProperties((String)"align=center colspan=2", (String)this.translation.reducedModeColumnHeader())}), this.jointLimitRow(this.translation.joint0Name(), normalMode, reducedMode, 0, this.translation), this.jointLimitRow(this.translation.joint1Name(), normalMode, reducedMode, 1, this.translation), this.jointLimitRow(this.translation.joint2Name(), normalMode, reducedMode, 2, this.translation), this.jointLimitRow(this.translation.joint3Name(), normalMode, reducedMode, 3, this.translation), this.jointLimitRow(this.translation.joint4Name(), normalMode, reducedMode, 4, this.translation), this.jointLimitRow(this.translation.joint5Name(), normalMode, reducedMode, 5, this.translation)});
    }

    private String generateJointLimits(SafetyLimits normalMode) {
        return HTML.table((int)this.lookAndFeel.panelWidth, (String[])new String[]{HTML.tableRow((String[])new String[]{HTML.tableHeaderWithProperties((String)"align=left", (String)this.translation.jointColumnHeader()), HTML.tableHeaderWithProperties((String)"align=right", (String)this.translation.maxSpeed()), HTML.tableHeaderWithProperties((String)"align=right", (String)this.translation.position())}), this.jointLimitRow(this.translation.joint0Name(), normalMode, 0, this.translation), this.jointLimitRow(this.translation.joint1Name(), normalMode, 1, this.translation), this.jointLimitRow(this.translation.joint2Name(), normalMode, 2, this.translation), this.jointLimitRow(this.translation.joint3Name(), normalMode, 3, this.translation), this.jointLimitRow(this.translation.joint4Name(), normalMode, 4, this.translation), this.jointLimitRow(this.translation.joint5Name(), normalMode, 5, this.translation)});
    }

    private boolean isInfinite(int i) {
        return i == Integer.MAX_VALUE || i == Integer.MIN_VALUE;
    }

    private String jointLimitRow(String jointName, SafetyLimits normalMode, int jointId, SafetyTextResource safetyTextResource) {
        JointType j = JointType.fromJointNumber((int)jointId);
        String maxSpeedFormatted = this.degFormat.format(this.jointSpeedConverter.convertFrom(normalMode.getMaxJointSpeeds()[jointId]));
        String minPositionFormatted = this.degFormat.format(this.jointPositionConverter.convertFrom(normalMode.getMinJointPosition(j).getTotalAngle()));
        String maxPositionFormatted = this.degFormat.format(this.jointPositionConverter.convertFrom(normalMode.getMaxJointPosition(j).getTotalAngle()));
        String maxSpeed = String.format("%s&nbsp;%s", maxSpeedFormatted, this.jointSpeedConverter.getUnit());
        String positionRange = String.format("[%s:%s]&nbsp;%s", minPositionFormatted, maxPositionFormatted, this.jointPositionConverter.getUnit());
        if (this.isInfinite(normalMode.getMinJointPosition(j).getRevolutions()) && this.isInfinite(normalMode.getMaxJointPosition(j).getRevolutions())) {
            positionRange = safetyTextResource.unlimitedLimits();
        }
        return this.rowGenerator.generate(HTML.tableCell((String)jointName), HTML.tableCellNumber((String)maxSpeed), HTML.tableCellNumber((String)positionRange));
    }

    private String jointLimitRow(String jointName, SafetyLimits normalMode, SafetyLimits reducedMode, int jointId, SafetyTextResource tr) {
        JointType j = JointType.fromJointNumber((int)jointId);
        String maxSpeedNormalFormatted = this.degFormat.format(this.jointSpeedConverter.convertFrom(normalMode.getMaxJointSpeeds()[jointId]));
        String minPositionNormalFormatted = this.degFormat.format(this.jointPositionConverter.convertFrom(normalMode.getMinJointPosition(j).getTotalAngle()));
        String maxPositionNormalFormatted = this.degFormat.format(this.jointPositionConverter.convertFrom(normalMode.getMaxJointPosition(j).getTotalAngle()));
        String maxSpeedReducedFormatted = this.degFormat.format(this.jointSpeedConverter.convertFrom(reducedMode.getMaxJointSpeeds()[jointId]));
        String minPositionReducedFormatted = this.degFormat.format(this.jointPositionConverter.convertFrom(reducedMode.getMinJointPosition(j).getTotalAngle()));
        String maxPositionReducedFormatted = this.degFormat.format(this.jointPositionConverter.convertFrom(reducedMode.getMaxJointPosition(j).getTotalAngle()));
        String normalMaxSpeed = String.format("%s", maxSpeedNormalFormatted);
        String reducedMaxSpeed = String.format("%s", maxSpeedReducedFormatted);
        String normalPositionRange = String.format(" [%s&nbsp;:&nbsp;%s]", minPositionNormalFormatted, maxPositionNormalFormatted);
        String reducedPositionRange = String.format("[%s&nbsp;:&nbsp;%s]", minPositionReducedFormatted, maxPositionReducedFormatted);
        if (this.isInfinite(normalMode.getMinJointPosition(j).getRevolutions()) && this.isInfinite(normalMode.getMaxJointPosition(j).getRevolutions())) {
            normalPositionRange = tr.unlimitedLimits();
        }
        if (this.isInfinite(reducedMode.getMinJointPosition(j).getRevolutions()) && this.isInfinite(reducedMode.getMaxJointPosition(j).getRevolutions())) {
            reducedPositionRange = tr.unlimitedLimits();
        }
        return this.rowGenerator.generate(HTML.tableCell((String)jointName), HTML.tableCellWithProperties((String)"align=center", (String)normalMaxSpeed), HTML.tableCellNumber((String)reducedMaxSpeed), HTML.tableCell((String)this.jointSpeedConverter.getUnit()), HTML.tableCellWithProperties((String)"align=center", (String)normalPositionRange), HTML.tableCellNumber((String)reducedPositionRange), HTML.tableCell((String)this.jointPositionConverter.getUnit()));
    }
}

