/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.jointlimits;

import com.ur.lang.Defense;
import com.ur.lang.EqualsUtil;
import com.ur.lang.PrimitiveUtils;
import com.ur.lang.adt.Pair;
import com.ur.math.Revolution;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.robot.configuration.RobotTool;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.EnableJointPositionLimitLockListener;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.generallimits.core.SafetyLimits;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.safety.impl.JTextFieldValidatorWithStrategy;
import com.ur.safety.impl.JTtextFieldValidationWithPreConditions;
import com.ur.safety.jointlimits.JointLimitsPanel;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.util.domain.Activatable;
import com.ur.safety.util.domain.Q;
import com.ur.swing.BindingRegistration;
import com.ur.swing.CompoundRegistration;
import com.ur.swing.DocumentUpdateListener;
import com.ur.swing.URFontFactory;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberFieldUtils;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.units.ValueConverter;
import com.ur.swing.validation.FormValidation;
import com.ur.swing.validation.SwingFormValidation;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.logging.Log;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

public class JointPositionLimitsPanel
extends JPanel
implements Activatable {
    private static final UnitsConverter DEG_CONVERTER = Units.getDegreesConverter();
    private static final double WRIST3_LIMIT = 1.3493037697238832E10;
    private final URFontFactory fontFactory;
    private final List<JLabel> rangeLabels = new ArrayList<JLabel>();
    private final List<JTextField> minNormalFields = new ArrayList<JTextField>();
    private final List<JTextField> maxNormalFields = new ArrayList<JTextField>();
    private final List<JTextField> minReducedFields = new ArrayList<JTextField>();
    private final List<JTextField> maxReducedFields = new ArrayList<JTextField>();
    private final List<JLabel> toleranceFields = new ArrayList<JLabel>();
    private final SwingFormValidation formValidation = new SwingFormValidation();
    private final CompoundRegistration compoundRegistration = new CompoundRegistration();
    private final ChangeListener changeListener = new ChangeListener();
    private final SafetyTextResource textResource;
    private final SafetySettingsLookupService safetySettingsLookupService;
    private final EnableJointPositionLimitLockListener safetyLockListener;
    private final SafetyLock safetyLock;
    private final RobotTool robotTool;
    private ArrayList<BindingRegistration> validatorBindingRegistrations = new ArrayList();
    private JLabel defaultValueHeader;
    private JLabel jointsHeader;
    private JLabel maxPositionJointName0;
    private JLabel maxPositionJointName1;
    private JLabel maxPositionJointName2;
    private JLabel maxPositionJointName3;
    private JLabel maxPositionJointName4;
    private JLabel maxPositionJointName5;
    private JTextField maxPositionNormalMode0;
    private JTextField maxPositionNormalMode1;
    private JTextField maxPositionNormalMode2;
    private JTextField maxPositionNormalMode3;
    private JTextField maxPositionNormalMode4;
    private JTextField maxPositionNormalMode5;
    private JTextField maxPositionReducedMode0;
    private JTextField maxPositionReducedMode1;
    private JTextField maxPositionReducedMode2;
    private JTextField maxPositionReducedMode3;
    private JTextField maxPositionReducedMode4;
    private JTextField maxPositionReducedMode5;
    private JLabel maxPositionUnitLabel0;
    private JLabel maxPositionUnitLabel1;
    private JLabel maxPositionUnitLabel2;
    private JLabel maxPositionUnitLabel3;
    private JLabel maxPositionUnitLabel4;
    private JLabel maxPositionUnitLabel5;
    private JLabel maximumForNormalMode;
    private JLabel maximumForReducedMode;
    private JTextField minPositionNormalMode0;
    private JTextField minPositionNormalMode1;
    private JTextField minPositionNormalMode2;
    private JTextField minPositionNormalMode3;
    private JTextField minPositionNormalMode4;
    private JTextField minPositionNormalMode5;
    private JTextField minPositionReducedMode0;
    private JTextField minPositionReducedMode1;
    private JTextField minPositionReducedMode2;
    private JTextField minPositionReducedMode3;
    private JTextField minPositionReducedMode4;
    private JTextField minPositionReducedMode5;
    private JLabel minimumForNormalMode;
    private JLabel minimumForReducedMode;
    private JLabel normalModeHeader;
    private JLabel reducedModeHeader;
    private JLabel tolerance1;
    private JLabel tolerance2;
    private JLabel tolerance3;
    private JLabel tolerance4;
    private JLabel tolerance5;
    private JLabel tolerance6;
    private JointConfigurationSettings jointConfigurationSettings;

    public JointPositionLimitsPanel(URFontFactory fontFactory, SafetyTextResource textResource, SafetySettingsLookupService safetySettingsLookupService, SafetyLock lock, RobotTool robotTool, JointConfigurationSettings jointConfigurationSettings) {
        this.fontFactory = fontFactory;
        this.textResource = textResource;
        this.safetySettingsLookupService = safetySettingsLookupService;
        this.safetyLock = lock;
        this.safetyLockListener = new EnableJointPositionLimitLockListener(this.safetyLock, safetySettingsLookupService);
        this.jointConfigurationSettings = jointConfigurationSettings;
        this.safetyLock.addSafetyLockListener(this.safetyLockListener);
        this.robotTool = robotTool;
        this.initComponents();
        this.translateGUILabels();
        this.createLists();
        this.initTable();
        this.bindNames();
        this.ghostReducedModeWhenReducedModeUnavailable();
    }

    private void bindNames() {
        this.minPositionNormalMode0.setName(JointLimitsPanel.BASE_NORMAL_MODE[1]);
        this.minPositionNormalMode1.setName(JointLimitsPanel.SHOULDER_NORMAL_MODE[1]);
        this.minPositionNormalMode2.setName(JointLimitsPanel.ELBOW_NORMAL_MODE[1]);
        this.minPositionNormalMode3.setName(JointLimitsPanel.WRIST_1_NORMAL_MODE[1]);
        this.minPositionNormalMode4.setName(JointLimitsPanel.WRIST_2_NORMAL_MODE[1]);
        this.minPositionNormalMode5.setName(JointLimitsPanel.WRIST_3_NORMAL_MODE[1]);
        this.maxPositionNormalMode0.setName(JointLimitsPanel.BASE_NORMAL_MODE[2]);
        this.maxPositionNormalMode1.setName(JointLimitsPanel.SHOULDER_NORMAL_MODE[2]);
        this.maxPositionNormalMode2.setName(JointLimitsPanel.ELBOW_NORMAL_MODE[2]);
        this.maxPositionNormalMode3.setName(JointLimitsPanel.WRIST_1_NORMAL_MODE[2]);
        this.maxPositionNormalMode4.setName(JointLimitsPanel.WRIST_2_NORMAL_MODE[2]);
        this.maxPositionNormalMode5.setName(JointLimitsPanel.WRIST_3_NORMAL_MODE[2]);
        this.minPositionReducedMode0.setName(JointLimitsPanel.BASE_REDUCED_MODE[1]);
        this.minPositionReducedMode1.setName(JointLimitsPanel.SHOULDER_REDUCED_MODE[1]);
        this.minPositionReducedMode2.setName(JointLimitsPanel.ELBOW_REDUCED_MODE[1]);
        this.minPositionReducedMode3.setName(JointLimitsPanel.WRIST_1_REDUCED_MODE[1]);
        this.minPositionReducedMode4.setName(JointLimitsPanel.WRIST_2_REDUCED_MODE[1]);
        this.minPositionReducedMode5.setName(JointLimitsPanel.WRIST_3_REDUCED_MODE[1]);
        this.maxPositionReducedMode0.setName(JointLimitsPanel.BASE_REDUCED_MODE[2]);
        this.maxPositionReducedMode1.setName(JointLimitsPanel.SHOULDER_REDUCED_MODE[2]);
        this.maxPositionReducedMode2.setName(JointLimitsPanel.ELBOW_REDUCED_MODE[2]);
        this.maxPositionReducedMode3.setName(JointLimitsPanel.WRIST_1_REDUCED_MODE[2]);
        this.maxPositionReducedMode4.setName(JointLimitsPanel.WRIST_2_REDUCED_MODE[2]);
        this.maxPositionReducedMode5.setName(JointLimitsPanel.WRIST_3_REDUCED_MODE[2]);
    }

    private void createLists() {
        this.rangeLabels.add(this.maxPositionUnitLabel0);
        this.rangeLabels.add(this.maxPositionUnitLabel1);
        this.rangeLabels.add(this.maxPositionUnitLabel2);
        this.rangeLabels.add(this.maxPositionUnitLabel3);
        this.rangeLabels.add(this.maxPositionUnitLabel4);
        this.rangeLabels.add(this.maxPositionUnitLabel5);
        this.minNormalFields.add(this.minPositionNormalMode0);
        this.minNormalFields.add(this.minPositionNormalMode1);
        this.minNormalFields.add(this.minPositionNormalMode2);
        this.minNormalFields.add(this.minPositionNormalMode3);
        this.minNormalFields.add(this.minPositionNormalMode4);
        this.minNormalFields.add(this.minPositionNormalMode5);
        this.maxNormalFields.add(this.maxPositionNormalMode0);
        this.maxNormalFields.add(this.maxPositionNormalMode1);
        this.maxNormalFields.add(this.maxPositionNormalMode2);
        this.maxNormalFields.add(this.maxPositionNormalMode3);
        this.maxNormalFields.add(this.maxPositionNormalMode4);
        this.maxNormalFields.add(this.maxPositionNormalMode5);
        this.minReducedFields.add(this.minPositionReducedMode0);
        this.minReducedFields.add(this.minPositionReducedMode1);
        this.minReducedFields.add(this.minPositionReducedMode2);
        this.minReducedFields.add(this.minPositionReducedMode3);
        this.minReducedFields.add(this.minPositionReducedMode4);
        this.minReducedFields.add(this.minPositionReducedMode5);
        this.maxReducedFields.add(this.maxPositionReducedMode0);
        this.maxReducedFields.add(this.maxPositionReducedMode1);
        this.maxReducedFields.add(this.maxPositionReducedMode2);
        this.maxReducedFields.add(this.maxPositionReducedMode3);
        this.maxReducedFields.add(this.maxPositionReducedMode4);
        this.maxReducedFields.add(this.maxPositionReducedMode5);
        this.toleranceFields.add(this.tolerance1);
        this.toleranceFields.add(this.tolerance2);
        this.toleranceFields.add(this.tolerance3);
        this.toleranceFields.add(this.tolerance4);
        this.toleranceFields.add(this.tolerance5);
        this.toleranceFields.add(this.tolerance6);
    }

    private void translateGUILabels() {
        this.jointsHeader.setText(this.textResource.jointColumnHeader());
        this.defaultValueHeader.setText(this.textResource.rangeColumnHeader());
        this.normalModeHeader.setText(this.textResource.normalModeColumnHeader());
        this.reducedModeHeader.setText(this.textResource.reducedModeColumnHeader());
        this.maximumForNormalMode.setText(this.textResource.maximumColumnHeader());
        this.maximumForReducedMode.setText(this.textResource.maximumColumnHeader());
        this.minimumForNormalMode.setText(this.textResource.minimumColumnHeader());
        this.minimumForReducedMode.setText(this.textResource.minimumColumnHeader());
        this.maxPositionJointName0.setText(this.textResource.joint0Name());
        this.maxPositionJointName1.setText(this.textResource.joint1Name());
        this.maxPositionJointName2.setText(this.textResource.joint2Name());
        this.maxPositionJointName3.setText(this.textResource.joint3Name());
        this.maxPositionJointName4.setText(this.textResource.joint4Name());
        this.maxPositionJointName5.setText(this.textResource.joint5Name());
    }

    private void initTable() {
        int i = 0;
        while (i < this.minNormalFields.size()) {
            JTextField minNormalField = this.minNormalFields.get(i);
            JTextField maxNormalField = this.maxNormalFields.get(i);
            JTextField minReducedField = this.minReducedFields.get(i);
            JTextField maxReducedField = this.maxReducedFields.get(i);
            this.safetyLockListener.addComponent(minNormalField, JointType.fromJointNumber((int)i));
            this.safetyLockListener.addComponent(maxNormalField, JointType.fromJointNumber((int)i));
            this.safetyLockListener.addReducedModeComponent(minReducedField, JointType.fromJointNumber((int)i));
            this.safetyLockListener.addReducedModeComponent(maxReducedField, JointType.fromJointNumber((int)i));
            NumberFieldUtils.bindNumberPicker((JTextField)minNormalField, (Mode)Mode.WholeNumbers);
            NumberFieldUtils.bindNumberPicker((JTextField)maxNormalField, (Mode)Mode.WholeNumbers);
            NumberFieldUtils.bindNumberPicker((JTextField)minReducedField, (Mode)Mode.WholeNumbers);
            NumberFieldUtils.bindNumberPicker((JTextField)maxReducedField, (Mode)Mode.WholeNumbers);
            ++i;
        }
        this.updateMinAndMax();
    }

    private Pair getVerificationBoundsInDegrees() {
        double[] minimum = this.jointConfigurationSettings.getJointMinLimit();
        double[] maximum = this.jointConfigurationSettings.getJointMaxLimit();
        double[] minimumConverted = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] maximumConverted = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        JointType[] jointTypeArray = JointType.values();
        int n = jointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JointType jointType = jointTypeArray[n2];
            int j = jointType.getJointNumber();
            if (this.robotTool.isInfiniteRevolutionsWrist3Allowed() && jointType == JointType.WRIST3) {
                double wristLimit = PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)DEG_CONVERTER.convertFrom(1.3493037697238832E10));
                minimumConverted[j] = -wristLimit;
                maximumConverted[j] = wristLimit;
            } else {
                minimumConverted[j] = PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)DEG_CONVERTER.convertFrom(minimum[j]));
                maximumConverted[j] = PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)DEG_CONVERTER.convertFrom(maximum[j]));
            }
            ++n2;
        }
        return new Pair((Object)minimumConverted, (Object)maximumConverted);
    }

    private void updateMinAndMax() {
        Pair bounds = this.getVerificationBoundsInDegrees();
        double[] minimumConverted = (double[])bounds.getFirst();
        double[] maximumConverted = (double[])bounds.getSecond();
        double[] tolerances = this.safetySettingsLookupService.getSafetyComplianceTolerances().getJointPositionTolerance();
        JointType[] jointTypeArray = JointType.values();
        int n = jointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JointType jointType = jointTypeArray[n2];
            int j = jointType.getJointNumber();
            double toleranceConverted = PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)DEG_CONVERTER.convertFrom(tolerances[j]));
            if (this.robotTool.isInfiniteRevolutionsWrist3Allowed() && jointType == JointType.WRIST3) {
                this.rangeLabels.get(j).setText(this.textResource.unlimitedLimits());
            } else {
                this.rangeLabels.get(j).setText(this.textResource.minimumAndMaximumValue((long)minimumConverted[j], (long)maximumConverted[j], DEG_CONVERTER.getUnit()));
            }
            this.toleranceFields.get(j).setText(String.valueOf(this.textResource.plusToleranceNoDecimals(toleranceConverted, DEG_CONVERTER.getUnit())) + " / " + this.textResource.minusToleranceNoDecimals(toleranceConverted, DEG_CONVERTER.getUnit()));
            ++n2;
        }
    }

    public void bindFormValidation(FormValidation.FormListener<JComponent> ... listeners) {
        this.updateMinAndMax();
        SafetySetup safetySetup = this.safetySettingsLookupService.getSafetySetup();
        SafetyLimits normalMode = ((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class)).getNormalLimits();
        SafetyLimits reducedMode = ((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class)).getReducedLimits();
        Q minNormalModeVec = normalMode.getMinJointVector();
        Q maxNormalModeVec = normalMode.getMaxJointVector();
        Q minReducedModeVec = reducedMode.getMinJointVector();
        Q maxReducedModeVec = reducedMode.getMaxJointVector();
        this.compoundRegistration.removeRegistration();
        this.formValidation.clearForm();
        for (BindingRegistration br : this.validatorBindingRegistrations) {
            if (br == null) continue;
            br.removeRegistration();
        }
        this.validatorBindingRegistrations.clear();
        FormValidation.FormListener<JComponent>[] formListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            FormValidation.FormListener<JComponent> each = formListenerArray[n2];
            this.formValidation.addFormListener(each);
            ++n2;
        }
        this.bindFormValidation(this.formValidation);
        this.compoundRegistration.add(this.massBindToQVector(this.minNormalFields, minNormalModeVec, DEG_CONVERTER, PrimitiveUtils.WHOLE_NUMBER_FORMAT, this.changeListener));
        this.compoundRegistration.add(this.massBindToQVector(this.maxNormalFields, maxNormalModeVec, DEG_CONVERTER, PrimitiveUtils.WHOLE_NUMBER_FORMAT, this.changeListener));
        this.compoundRegistration.add(this.massBindToQVector(this.minReducedFields, minReducedModeVec, DEG_CONVERTER, PrimitiveUtils.WHOLE_NUMBER_FORMAT, this.changeListener));
        this.compoundRegistration.add(this.massBindToQVector(this.maxReducedFields, maxReducedModeVec, DEG_CONVERTER, PrimitiveUtils.WHOLE_NUMBER_FORMAT, this.changeListener));
        this.compoundRegistration.add(TextFieldUtils.bindChangeListenersToForm((FormValidation)this.formValidation, this.minNormalFields));
        this.compoundRegistration.add(TextFieldUtils.bindChangeListenersToForm((FormValidation)this.formValidation, this.maxNormalFields));
        this.compoundRegistration.add(TextFieldUtils.bindChangeListenersToForm((FormValidation)this.formValidation, this.minReducedFields));
        this.compoundRegistration.add(TextFieldUtils.bindChangeListenersToForm((FormValidation)this.formValidation, this.maxReducedFields));
        this.compoundRegistration.add(TextFieldUtils.resetValueOnError(this.minNormalFields));
        this.compoundRegistration.add(TextFieldUtils.resetValueOnError(this.maxNormalFields));
        this.compoundRegistration.add(TextFieldUtils.resetValueOnError(this.minReducedFields));
        this.compoundRegistration.add(TextFieldUtils.resetValueOnError(this.maxReducedFields));
        this.formValidation.validate();
    }

    public BindingRegistration massBindToQVector(final Collection<JTextField> fields, final Q model, UnitsConverter converter, final DecimalFormat formatter, final PropertyChangeListener changeListener) {
        Defense.isLength(fields, (int)6);
        final ValueConverter.DoubleConverter valueConverter = new ValueConverter.DoubleConverter(converter, (NumberFormat)formatter);
        BindingRegistration[] registrations = new BindingRegistration[fields.size()];
        final JTextField[] fieldsAsArray = fields.toArray(new JTextField[0]);
        int i = 0;
        while (i < fields.size()) {
            final int index = i;
            DocumentUpdateListener listener = new DocumentUpdateListener(){

                public void update() {
                    Log.trace((String)"update bindings");
                    try {
                        Revolution oldValue = model.getJoint(JointType.fromJointNumber((int)index));
                        String text = fieldsAsArray[index].getText();
                        Revolution newValue = JointPositionLimitsPanel.this.getJointRevolution(text, valueConverter);
                        if (!oldValue.equals((Object)newValue)) {
                            model.setJoint(JointType.fromJointNumber((int)index), newValue);
                            changeListener.propertyChange(new PropertyChangeEvent(fields.toArray()[index], "", oldValue.getTotalAngle(), newValue.getTotalAngle()));
                        }
                    }
                    catch (Throwable throwable) {}
                }
            };
            FocusAdapter formatOnExitListener = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        String valueAsString = fieldsAsArray[index].getText();
                        double value = PrimitiveUtils.parseDouble((String)valueAsString);
                        String formattedValue = formatter.format(value);
                        if (!EqualsUtil.equals((Object)formattedValue, (Object)valueAsString)) {
                            fieldsAsArray[index].setText(formattedValue);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            };
            this.setJointValueText(fieldsAsArray[i], model, i, valueConverter);
            fieldsAsArray[i].getDocument().addDocumentListener((DocumentListener)listener);
            fieldsAsArray[i].addFocusListener(formatOnExitListener);
            registrations[i] = () -> {
                fieldsAsArray[index].removeFocusListener(formatOnExitListener);
                fieldsAsArray[index].getDocument().removeDocumentListener((DocumentListener)listener);
            };
            ++i;
        }
        return new CompoundRegistration(registrations);
    }

    private Revolution getJointRevolution(String text, ValueConverter.DoubleConverter valueConverter) {
        if (text.equals("-" + this.textResource.unlimitedLimits())) {
            return new Revolution(Integer.MIN_VALUE, 0.0);
        }
        if (text.equals("+" + this.textResource.unlimitedLimits())) {
            return new Revolution(Integer.MAX_VALUE, 0.0);
        }
        return new Revolution(valueConverter.fromGui(text).doubleValue());
    }

    private void setJointValueText(JTextField textField, Q model, int joint, ValueConverter.DoubleConverter valueConverter) {
        int revolutions = model.getRevolutions()[joint];
        if (revolutions == Integer.MAX_VALUE) {
            textField.setText("+" + this.textResource.unlimitedLimits());
        } else if (revolutions == Integer.MIN_VALUE) {
            textField.setText("-" + this.textResource.unlimitedLimits());
        } else {
            textField.setText(valueConverter.fromModel(Double.valueOf(model.getTotalAngles()[joint])));
        }
    }

    private void bindFormValidation(SwingFormValidation formValidation) {
        double minJointRangeIntervalSizeInDegrees = DEG_CONVERTER.convertFrom(SafetyLimits.MIN_JOINT_RANGE_INTERVAL_SIZE);
        String reducedValueLargerThanNormalValueMessage = this.textResource.valueIsLargerThanInNormalMode();
        String reducedValueSmallerThanNormalValueMessage = this.textResource.valueIsSmallerThanInNormalMode();
        String normalValueLargerThanReducedValueMessage = this.textResource.valueIsSmallerThanInReducedMode();
        String normalValueSmallerThanReducedValueMessage = this.textResource.valueIsLargerThanInReducedMode();
        String valueCannotBeLessThanMinimum = this.textResource.valueCannotBeLessThanMinimum();
        String valueCannotBeGreaterThanMaximum = this.textResource.valueCannotBeGreaterThanMaximum();
        String rangeIntervalTooSmallMessage = this.textResource.intervalToSmall((long)minJointRangeIntervalSizeInDegrees, DEG_CONVERTER.getUnit());
        Pair bounds = this.getVerificationBoundsInDegrees();
        double[] minimumConverted = (double[])bounds.getFirst();
        double[] maximumConverted = (double[])bounds.getSecond();
        int i = 0;
        while (i < this.minNormalFields.size()) {
            JTextField minNormalField = this.minNormalFields.get(i);
            JTextField maxNormalField = this.maxNormalFields.get(i);
            JTextField minReducedField = this.minReducedFields.get(i);
            JTextField maxReducedField = this.maxReducedFields.get(i);
            minNormalField.setFocusable(false);
            maxNormalField.setFocusable(false);
            minReducedField.setFocusable(false);
            maxReducedField.setFocusable(false);
            if (((SafetyLimitsComponent)this.safetySettingsLookupService.getSafetySetup().getComponent(SafetyLimitsComponent.class)).getWithPositionLimits(JointType.fromJointNumber((int)i))) {
                String valueOutOfRange = this.textResource.wholeNumberOutOfRange((long)minimumConverted[i], DEG_CONVERTER.getUnit(), (long)maximumConverted[i]);
                ValidationStrategy errorRangeValidator = ValidationFactory.getRangeValidator((double)minimumConverted[i], (double)maximumConverted[i], (String)valueOutOfRange);
                JTextFieldValidatorWithStrategy minNormalFieldRangeValidator = new JTextFieldValidatorWithStrategy(minNormalField, errorRangeValidator, FormValidation.ValidationLevel.Error);
                JTextFieldValidatorWithStrategy maxNormalFieldRangeValidator = new JTextFieldValidatorWithStrategy(maxNormalField, errorRangeValidator, FormValidation.ValidationLevel.Error);
                formValidation.addErrorValidation((JComponent)minNormalField, (FormValidation.Validator)minNormalFieldRangeValidator);
                formValidation.addErrorValidation((JComponent)maxNormalField, (FormValidation.Validator)maxNormalFieldRangeValidator);
                ValidationStrategy minLessThanMaxCheckNormal = ValidationFactory.getLessThanValidator((JTextField)maxNormalField, (String)"text", (String)valueCannotBeGreaterThanMaximum);
                ValidationStrategy insideIntervalValidatorMinNormal = ValidationFactory.getMinDistanceValidator((JTextField)maxNormalField, (String)"text", (double)minJointRangeIntervalSizeInDegrees, (String)rangeIntervalTooSmallMessage);
                JTtextFieldValidationWithPreConditions minLessThanMaxAndInsideIntervalValidatorNormal = new JTtextFieldValidationWithPreConditions(minNormalField, maxNormalField, minLessThanMaxCheckNormal, true, false, FormValidation.ValidationLevel.Error, minNormalFieldRangeValidator, maxNormalFieldRangeValidator);
                minLessThanMaxAndInsideIntervalValidatorNormal.addValidationStrategy(insideIntervalValidatorMinNormal);
                formValidation.addErrorValidation((JComponent)minNormalField, (FormValidation.Validator)minLessThanMaxAndInsideIntervalValidatorNormal);
                this.validatorBindingRegistrations.add(NumberFieldUtils.bindErrorValidator((JTextField)minNormalField, (ValidationStrategy)new ValidationStrategy.Composite(new ValidationStrategy[]{errorRangeValidator, minLessThanMaxCheckNormal, insideIntervalValidatorMinNormal})));
                ValidationStrategy maxGreaterThanMinCheckNormal = ValidationFactory.getGreaterThanValidator((JTextField)minNormalField, (String)"text", (String)valueCannotBeLessThanMinimum);
                ValidationStrategy insideIntervalValidatorMaxNormal = ValidationFactory.getMinDistanceValidator((JTextField)minNormalField, (String)"text", (double)minJointRangeIntervalSizeInDegrees, (String)rangeIntervalTooSmallMessage);
                JTtextFieldValidationWithPreConditions maxGreaterThanMinAndInsideIntervalValidatorNormal = new JTtextFieldValidationWithPreConditions(maxNormalField, minNormalField, maxGreaterThanMinCheckNormal, true, false, FormValidation.ValidationLevel.Error, maxNormalFieldRangeValidator, minNormalFieldRangeValidator);
                maxGreaterThanMinAndInsideIntervalValidatorNormal.addValidationStrategy(insideIntervalValidatorMaxNormal);
                formValidation.addErrorValidation((JComponent)maxNormalField, (FormValidation.Validator)maxGreaterThanMinAndInsideIntervalValidatorNormal);
                this.validatorBindingRegistrations.add(NumberFieldUtils.bindErrorValidator((JTextField)maxNormalField, (ValidationStrategy)new ValidationStrategy.Composite(new ValidationStrategy[]{errorRangeValidator, maxGreaterThanMinCheckNormal, insideIntervalValidatorMaxNormal})));
                this.validatorBindingRegistrations.add(NumberFieldUtils.bindWarningValidator((JTextField)maxNormalField, (ValidationStrategy)new ValidationStrategy.AlwaysValid()));
                this.validatorBindingRegistrations.add(NumberFieldUtils.bindWarningValidator((JTextField)minNormalField, (ValidationStrategy)new ValidationStrategy.AlwaysValid()));
                if (this.safetySettingsLookupService.getSafetySetup().isReducedModeDefined()) {
                    JTextFieldValidatorWithStrategy minReducedFieldRangeValidator = new JTextFieldValidatorWithStrategy(minReducedField, errorRangeValidator, FormValidation.ValidationLevel.Error);
                    JTextFieldValidatorWithStrategy maxReducedFieldRangeValidator = new JTextFieldValidatorWithStrategy(maxReducedField, errorRangeValidator, FormValidation.ValidationLevel.Error);
                    formValidation.addErrorValidation((JComponent)minReducedField, (FormValidation.Validator)minReducedFieldRangeValidator);
                    formValidation.addErrorValidation((JComponent)maxReducedField, (FormValidation.Validator)maxReducedFieldRangeValidator);
                    ValidationStrategy minLessThanMaxCheckReduced = ValidationFactory.getLessThanValidator((JTextField)maxReducedField, (String)"text", (String)valueCannotBeGreaterThanMaximum);
                    ValidationStrategy insideIntervalValidatorMinReduced = ValidationFactory.getMinDistanceValidator((JTextField)maxReducedField, (String)"text", (double)minJointRangeIntervalSizeInDegrees, (String)rangeIntervalTooSmallMessage);
                    JTtextFieldValidationWithPreConditions minLessThanMaxAndInsideIntervalValidatorReduced = new JTtextFieldValidationWithPreConditions(minReducedField, maxReducedField, minLessThanMaxCheckReduced, true, false, FormValidation.ValidationLevel.Error, minReducedFieldRangeValidator, maxReducedFieldRangeValidator);
                    minLessThanMaxAndInsideIntervalValidatorReduced.addValidationStrategy(insideIntervalValidatorMinReduced);
                    formValidation.addErrorValidation((JComponent)minReducedField, (FormValidation.Validator)minLessThanMaxAndInsideIntervalValidatorReduced);
                    ValidationStrategy maxGreaterThanMinCheckReduced = ValidationFactory.getGreaterThanValidator((JTextField)minReducedField, (String)"text", (String)valueCannotBeLessThanMinimum);
                    ValidationStrategy insideIntervalValidatorMaxReduced = ValidationFactory.getMinDistanceValidator((JTextField)minReducedField, (String)"text", (double)minJointRangeIntervalSizeInDegrees, (String)rangeIntervalTooSmallMessage);
                    JTtextFieldValidationWithPreConditions maxGreaterThanMinAndInsideIntervalValidatorReduced = new JTtextFieldValidationWithPreConditions(maxReducedField, minReducedField, maxGreaterThanMinCheckReduced, true, false, FormValidation.ValidationLevel.Error, maxReducedFieldRangeValidator, minReducedFieldRangeValidator);
                    maxGreaterThanMinAndInsideIntervalValidatorReduced.addValidationStrategy(insideIntervalValidatorMaxReduced);
                    formValidation.addErrorValidation((JComponent)maxReducedField, (FormValidation.Validator)maxGreaterThanMinAndInsideIntervalValidatorReduced);
                    ValidationStrategy minReducedWarningLimitCheck = ValidationFactory.getGreaterThanValidator((JTextField)minNormalField, (String)"text", (String)reducedValueSmallerThanNormalValueMessage);
                    JTtextFieldValidationWithPreConditions reducedMinLessThanNormalMinValidator = new JTtextFieldValidationWithPreConditions(minReducedField, minNormalField, minReducedWarningLimitCheck, true, true, FormValidation.ValidationLevel.Warning, minReducedFieldRangeValidator, minNormalFieldRangeValidator, minLessThanMaxAndInsideIntervalValidatorNormal);
                    formValidation.addWarningValidation((JComponent)minReducedField, (FormValidation.Validator)reducedMinLessThanNormalMinValidator);
                    ValidationStrategy maxReducedWarningLimitCheck = ValidationFactory.getLessThanValidator((JTextField)maxNormalField, (String)"text", (String)reducedValueLargerThanNormalValueMessage);
                    JTtextFieldValidationWithPreConditions reducedMaxGreaterThanNormalMaxValidator = new JTtextFieldValidationWithPreConditions(maxReducedField, maxNormalField, maxReducedWarningLimitCheck, true, true, FormValidation.ValidationLevel.Warning, maxReducedFieldRangeValidator, maxNormalFieldRangeValidator, maxGreaterThanMinAndInsideIntervalValidatorNormal);
                    formValidation.addWarningValidation((JComponent)maxReducedField, (FormValidation.Validator)reducedMaxGreaterThanNormalMaxValidator);
                    ValidationStrategy minNormalWarningLimitCheck = ValidationFactory.getLessThanValidator((JTextField)minReducedField, (String)"text", (String)normalValueSmallerThanReducedValueMessage);
                    ValidationStrategy maxNormalWarningLimitCheck = ValidationFactory.getGreaterThanValidator((JTextField)maxReducedField, (String)"text", (String)normalValueLargerThanReducedValueMessage);
                    this.validatorBindingRegistrations.add(NumberFieldUtils.bindValidator((JTextField)minNormalField, (ValidationStrategy)new ValidationStrategy.Composite(new ValidationStrategy[]{errorRangeValidator, minLessThanMaxCheckNormal, insideIntervalValidatorMinNormal}), (ValidationStrategy)minNormalWarningLimitCheck));
                    this.validatorBindingRegistrations.add(NumberFieldUtils.bindValidator((JTextField)maxNormalField, (ValidationStrategy)new ValidationStrategy.Composite(new ValidationStrategy[]{errorRangeValidator, maxGreaterThanMinCheckNormal, insideIntervalValidatorMaxNormal}), (ValidationStrategy)maxNormalWarningLimitCheck));
                    this.validatorBindingRegistrations.add(NumberFieldUtils.bindValidator((JTextField)minReducedField, (ValidationStrategy)new ValidationStrategy.Composite(new ValidationStrategy[]{errorRangeValidator, minLessThanMaxCheckReduced, insideIntervalValidatorMinReduced}), (ValidationStrategy)minReducedWarningLimitCheck));
                    this.validatorBindingRegistrations.add(NumberFieldUtils.bindValidator((JTextField)maxReducedField, (ValidationStrategy)new ValidationStrategy.Composite(new ValidationStrategy[]{errorRangeValidator, maxGreaterThanMinCheckReduced, insideIntervalValidatorMaxReduced}), (ValidationStrategy)maxReducedWarningLimitCheck));
                }
            } else {
                formValidation.clearStrategiesFor((JComponent)minNormalField);
                formValidation.clearStrategiesFor((JComponent)maxNormalField);
                formValidation.clearStrategiesFor((JComponent)minReducedField);
                formValidation.clearStrategiesFor((JComponent)maxReducedField);
                for (BindingRegistration br : this.validatorBindingRegistrations) {
                    br.removeRegistration();
                }
                this.validatorBindingRegistrations.clear();
            }
            ++i;
        }
    }

    private boolean isReducedModeGhosted() {
        SafetySetup safetySetup = this.safetySettingsLookupService.getSafetySetup();
        return !safetySetup.isReducedModeDefined() || this.safetyLock.isLocked();
    }

    private void ghostReducedModeWhenReducedModeUnavailable() {
        int i = 0;
        while (i < 6) {
            this.minReducedFields.get(i).setEnabled(!this.isReducedModeGhosted());
            this.maxReducedFields.get(i).setEnabled(!this.isReducedModeGhosted());
            ++i;
        }
    }

    private void initComponents() {
        this.jointsHeader = new JLabel();
        this.defaultValueHeader = new JLabel();
        this.normalModeHeader = new JLabel();
        this.reducedModeHeader = new JLabel();
        this.maxPositionJointName0 = new JLabel();
        this.minPositionNormalMode0 = new JTextField();
        this.minPositionReducedMode0 = new JTextField();
        this.maxPositionJointName1 = new JLabel();
        this.minPositionNormalMode1 = new JTextField();
        this.minPositionReducedMode1 = new JTextField();
        this.maxPositionJointName2 = new JLabel();
        this.minPositionNormalMode2 = new JTextField();
        this.minPositionReducedMode2 = new JTextField();
        this.maxPositionJointName3 = new JLabel();
        this.minPositionNormalMode3 = new JTextField();
        this.minPositionReducedMode3 = new JTextField();
        this.maxPositionJointName4 = new JLabel();
        this.minPositionNormalMode4 = new JTextField();
        this.minPositionReducedMode4 = new JTextField();
        this.maxPositionJointName5 = new JLabel();
        this.minPositionNormalMode5 = new JTextField();
        this.minPositionReducedMode5 = new JTextField();
        this.maxPositionUnitLabel0 = new JLabel();
        this.maxPositionUnitLabel1 = new JLabel();
        this.maxPositionUnitLabel2 = new JLabel();
        this.maxPositionUnitLabel3 = new JLabel();
        this.maxPositionUnitLabel4 = new JLabel();
        this.maxPositionUnitLabel5 = new JLabel();
        this.tolerance1 = new JLabel();
        this.tolerance2 = new JLabel();
        this.tolerance3 = new JLabel();
        this.tolerance4 = new JLabel();
        this.tolerance5 = new JLabel();
        this.tolerance6 = new JLabel();
        JSeparator jSeparator2 = new JSeparator();
        this.maxPositionNormalMode0 = new JTextField();
        this.maxPositionNormalMode1 = new JTextField();
        this.maxPositionNormalMode2 = new JTextField();
        this.maxPositionNormalMode3 = new JTextField();
        this.maxPositionNormalMode4 = new JTextField();
        this.maxPositionNormalMode5 = new JTextField();
        this.maxPositionReducedMode0 = new JTextField();
        this.maxPositionReducedMode1 = new JTextField();
        this.maxPositionReducedMode2 = new JTextField();
        this.maxPositionReducedMode3 = new JTextField();
        this.maxPositionReducedMode4 = new JTextField();
        this.maxPositionReducedMode5 = new JTextField();
        this.minimumForNormalMode = new JLabel();
        this.maximumForNormalMode = new JLabel();
        this.minimumForReducedMode = new JLabel();
        this.maximumForReducedMode = new JLabel();
        this.setMinimumSize(new Dimension(600, 380));
        this.setPreferredSize(new Dimension(1000, 380));
        this.setLayout(new GridBagLayout());
        this.jointsHeader.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
        this.jointsHeader.setText("Joints");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 25, 0, 0);
        this.add((Component)this.jointsHeader, gridBagConstraints);
        this.defaultValueHeader.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
        this.defaultValueHeader.setHorizontalAlignment(0);
        this.defaultValueHeader.setText("Range");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 0, 0, 5);
        this.add((Component)this.defaultValueHeader, gridBagConstraints);
        this.normalModeHeader.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
        this.normalModeHeader.setHorizontalAlignment(0);
        this.normalModeHeader.setText("Normal Mode");
        this.normalModeHeader.setPreferredSize(new Dimension(180, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 10, 0, 5);
        this.add((Component)this.normalModeHeader, gridBagConstraints);
        this.reducedModeHeader.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
        this.reducedModeHeader.setHorizontalAlignment(0);
        this.reducedModeHeader.setText("Reduced Mode");
        this.reducedModeHeader.setPreferredSize(new Dimension(180, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 10, 0, 5);
        this.add((Component)this.reducedModeHeader, gridBagConstraints);
        this.maxPositionJointName0.setHorizontalAlignment(2);
        this.maxPositionJointName0.setText("Joint_0_name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 25, 0, 4);
        this.add((Component)this.maxPositionJointName0, gridBagConstraints);
        this.minPositionNormalMode0.setColumns(6);
        this.minPositionNormalMode0.setHorizontalAlignment(11);
        this.minPositionNormalMode0.setText("10");
        this.minPositionNormalMode0.setMaximumSize(new Dimension(120, 28));
        this.minPositionNormalMode0.setMinimumSize(new Dimension(10, 28));
        this.minPositionNormalMode0.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 10, 0, 2);
        this.add((Component)this.minPositionNormalMode0, gridBagConstraints);
        this.minPositionReducedMode0.setColumns(6);
        this.minPositionReducedMode0.setHorizontalAlignment(11);
        this.minPositionReducedMode0.setText("2");
        this.minPositionReducedMode0.setMaximumSize(new Dimension(120, 28));
        this.minPositionReducedMode0.setMinimumSize(new Dimension(80, 28));
        this.minPositionReducedMode0.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 10, 0, 2);
        this.add((Component)this.minPositionReducedMode0, gridBagConstraints);
        this.maxPositionJointName1.setHorizontalAlignment(2);
        this.maxPositionJointName1.setText("Joint_1_name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 25, 0, 4);
        this.add((Component)this.maxPositionJointName1, gridBagConstraints);
        this.minPositionNormalMode1.setColumns(6);
        this.minPositionNormalMode1.setHorizontalAlignment(11);
        this.minPositionNormalMode1.setText("10");
        this.minPositionNormalMode1.setMaximumSize(new Dimension(120, 28));
        this.minPositionNormalMode1.setMinimumSize(new Dimension(80, 28));
        this.minPositionNormalMode1.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 10, 0, 2);
        this.add((Component)this.minPositionNormalMode1, gridBagConstraints);
        this.minPositionReducedMode1.setColumns(6);
        this.minPositionReducedMode1.setHorizontalAlignment(11);
        this.minPositionReducedMode1.setText("2");
        this.minPositionReducedMode1.setMaximumSize(new Dimension(120, 28));
        this.minPositionReducedMode1.setMinimumSize(new Dimension(80, 28));
        this.minPositionReducedMode1.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 10, 0, 2);
        this.add((Component)this.minPositionReducedMode1, gridBagConstraints);
        this.maxPositionJointName2.setHorizontalAlignment(2);
        this.maxPositionJointName2.setText("Joint_2_name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 25, 0, 4);
        this.add((Component)this.maxPositionJointName2, gridBagConstraints);
        this.minPositionNormalMode2.setColumns(6);
        this.minPositionNormalMode2.setHorizontalAlignment(11);
        this.minPositionNormalMode2.setText("10");
        this.minPositionNormalMode2.setMaximumSize(new Dimension(120, 28));
        this.minPositionNormalMode2.setMinimumSize(new Dimension(80, 28));
        this.minPositionNormalMode2.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 10, 0, 2);
        this.add((Component)this.minPositionNormalMode2, gridBagConstraints);
        this.minPositionReducedMode2.setColumns(6);
        this.minPositionReducedMode2.setHorizontalAlignment(11);
        this.minPositionReducedMode2.setText("2");
        this.minPositionReducedMode2.setMaximumSize(new Dimension(120, 28));
        this.minPositionReducedMode2.setMinimumSize(new Dimension(80, 28));
        this.minPositionReducedMode2.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 10, 0, 2);
        this.add((Component)this.minPositionReducedMode2, gridBagConstraints);
        this.maxPositionJointName3.setHorizontalAlignment(2);
        this.maxPositionJointName3.setText("Joint_3_name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 25, 0, 4);
        this.add((Component)this.maxPositionJointName3, gridBagConstraints);
        this.minPositionNormalMode3.setColumns(6);
        this.minPositionNormalMode3.setHorizontalAlignment(11);
        this.minPositionNormalMode3.setText("10");
        this.minPositionNormalMode3.setMaximumSize(new Dimension(120, 28));
        this.minPositionNormalMode3.setMinimumSize(new Dimension(80, 28));
        this.minPositionNormalMode3.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 10, 0, 2);
        this.add((Component)this.minPositionNormalMode3, gridBagConstraints);
        this.minPositionReducedMode3.setColumns(6);
        this.minPositionReducedMode3.setHorizontalAlignment(11);
        this.minPositionReducedMode3.setText("2");
        this.minPositionReducedMode3.setMaximumSize(new Dimension(120, 28));
        this.minPositionReducedMode3.setMinimumSize(new Dimension(80, 28));
        this.minPositionReducedMode3.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 10, 0, 2);
        this.add((Component)this.minPositionReducedMode3, gridBagConstraints);
        this.maxPositionJointName4.setHorizontalAlignment(2);
        this.maxPositionJointName4.setText("Joint_4_name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 25, 0, 4);
        this.add((Component)this.maxPositionJointName4, gridBagConstraints);
        this.minPositionNormalMode4.setColumns(6);
        this.minPositionNormalMode4.setHorizontalAlignment(11);
        this.minPositionNormalMode4.setText("10");
        this.minPositionNormalMode4.setMaximumSize(new Dimension(120, 28));
        this.minPositionNormalMode4.setMinimumSize(new Dimension(80, 28));
        this.minPositionNormalMode4.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 10, 0, 2);
        this.add((Component)this.minPositionNormalMode4, gridBagConstraints);
        this.minPositionReducedMode4.setColumns(6);
        this.minPositionReducedMode4.setHorizontalAlignment(11);
        this.minPositionReducedMode4.setText("2");
        this.minPositionReducedMode4.setMaximumSize(new Dimension(120, 28));
        this.minPositionReducedMode4.setMinimumSize(new Dimension(80, 28));
        this.minPositionReducedMode4.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 10, 0, 2);
        this.add((Component)this.minPositionReducedMode4, gridBagConstraints);
        this.maxPositionJointName5.setHorizontalAlignment(2);
        this.maxPositionJointName5.setText("Joint_5_name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 25, 0, 4);
        this.add((Component)this.maxPositionJointName5, gridBagConstraints);
        this.minPositionNormalMode5.setColumns(6);
        this.minPositionNormalMode5.setHorizontalAlignment(11);
        this.minPositionNormalMode5.setText("10");
        this.minPositionNormalMode5.setMaximumSize(new Dimension(120, 28));
        this.minPositionNormalMode5.setMinimumSize(new Dimension(80, 28));
        this.minPositionNormalMode5.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 10, 0, 2);
        this.add((Component)this.minPositionNormalMode5, gridBagConstraints);
        this.minPositionReducedMode5.setColumns(6);
        this.minPositionReducedMode5.setHorizontalAlignment(11);
        this.minPositionReducedMode5.setText("2");
        this.minPositionReducedMode5.setMaximumSize(new Dimension(120, 28));
        this.minPositionReducedMode5.setMinimumSize(new Dimension(80, 28));
        this.minPositionReducedMode5.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 10, 0, 2);
        this.add((Component)this.minPositionReducedMode5, gridBagConstraints);
        this.maxPositionUnitLabel0.setText("[unit]");
        this.maxPositionUnitLabel0.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 10, 0, 5);
        this.add((Component)this.maxPositionUnitLabel0, gridBagConstraints);
        this.maxPositionUnitLabel1.setHorizontalAlignment(0);
        this.maxPositionUnitLabel1.setText("[unit]");
        this.maxPositionUnitLabel1.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 10, 0, 5);
        this.add((Component)this.maxPositionUnitLabel1, gridBagConstraints);
        this.maxPositionUnitLabel2.setHorizontalAlignment(0);
        this.maxPositionUnitLabel2.setText("[unit]");
        this.maxPositionUnitLabel2.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 10, 0, 5);
        this.add((Component)this.maxPositionUnitLabel2, gridBagConstraints);
        this.maxPositionUnitLabel3.setHorizontalAlignment(0);
        this.maxPositionUnitLabel3.setText("[unit]");
        this.maxPositionUnitLabel3.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 10, 0, 5);
        this.add((Component)this.maxPositionUnitLabel3, gridBagConstraints);
        this.maxPositionUnitLabel4.setHorizontalAlignment(0);
        this.maxPositionUnitLabel4.setText("[unit]");
        this.maxPositionUnitLabel4.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 10, 0, 5);
        this.add((Component)this.maxPositionUnitLabel4, gridBagConstraints);
        this.maxPositionUnitLabel5.setHorizontalAlignment(0);
        this.maxPositionUnitLabel5.setText("[unit]");
        this.maxPositionUnitLabel5.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 10, 0, 5);
        this.add((Component)this.maxPositionUnitLabel5, gridBagConstraints);
        this.tolerance1.setText("<tolerance>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 16;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 4, 0, 0);
        this.add((Component)this.tolerance1, gridBagConstraints);
        this.tolerance2.setText("<tolerance>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 16;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 4, 0, 0);
        this.add((Component)this.tolerance2, gridBagConstraints);
        this.tolerance3.setText("<tolerance>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 16;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 4, 0, 0);
        this.add((Component)this.tolerance3, gridBagConstraints);
        this.tolerance4.setText("<tolerance>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 16;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 4, 0, 0);
        this.add((Component)this.tolerance4, gridBagConstraints);
        this.tolerance5.setText("<tolerance>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 16;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 4, 0, 0);
        this.add((Component)this.tolerance5, gridBagConstraints);
        this.tolerance6.setText("<tolerance>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 16;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 4, 0, 0);
        this.add((Component)this.tolerance6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 25, 10, 0);
        this.add((Component)jSeparator2, gridBagConstraints);
        this.maxPositionNormalMode0.setColumns(6);
        this.maxPositionNormalMode0.setHorizontalAlignment(11);
        this.maxPositionNormalMode0.setText("10");
        this.maxPositionNormalMode0.setMaximumSize(new Dimension(120, 28));
        this.maxPositionNormalMode0.setMinimumSize(new Dimension(10, 28));
        this.maxPositionNormalMode0.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 5);
        this.add((Component)this.maxPositionNormalMode0, gridBagConstraints);
        this.maxPositionNormalMode1.setColumns(6);
        this.maxPositionNormalMode1.setHorizontalAlignment(11);
        this.maxPositionNormalMode1.setText("10");
        this.maxPositionNormalMode1.setMaximumSize(new Dimension(120, 28));
        this.maxPositionNormalMode1.setMinimumSize(new Dimension(80, 28));
        this.maxPositionNormalMode1.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 5);
        this.add((Component)this.maxPositionNormalMode1, gridBagConstraints);
        this.maxPositionNormalMode2.setColumns(6);
        this.maxPositionNormalMode2.setHorizontalAlignment(11);
        this.maxPositionNormalMode2.setText("10");
        this.maxPositionNormalMode2.setMaximumSize(new Dimension(120, 28));
        this.maxPositionNormalMode2.setMinimumSize(new Dimension(80, 28));
        this.maxPositionNormalMode2.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 5);
        this.add((Component)this.maxPositionNormalMode2, gridBagConstraints);
        this.maxPositionNormalMode3.setColumns(6);
        this.maxPositionNormalMode3.setHorizontalAlignment(11);
        this.maxPositionNormalMode3.setText("10");
        this.maxPositionNormalMode3.setMaximumSize(new Dimension(120, 28));
        this.maxPositionNormalMode3.setMinimumSize(new Dimension(80, 28));
        this.maxPositionNormalMode3.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 5);
        this.add((Component)this.maxPositionNormalMode3, gridBagConstraints);
        this.maxPositionNormalMode4.setColumns(6);
        this.maxPositionNormalMode4.setHorizontalAlignment(11);
        this.maxPositionNormalMode4.setText("10");
        this.maxPositionNormalMode4.setMaximumSize(new Dimension(120, 28));
        this.maxPositionNormalMode4.setMinimumSize(new Dimension(80, 28));
        this.maxPositionNormalMode4.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 5);
        this.add((Component)this.maxPositionNormalMode4, gridBagConstraints);
        this.maxPositionNormalMode5.setColumns(6);
        this.maxPositionNormalMode5.setHorizontalAlignment(11);
        this.maxPositionNormalMode5.setText("10");
        this.maxPositionNormalMode5.setMaximumSize(new Dimension(120, 28));
        this.maxPositionNormalMode5.setMinimumSize(new Dimension(80, 28));
        this.maxPositionNormalMode5.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 5);
        this.add((Component)this.maxPositionNormalMode5, gridBagConstraints);
        this.maxPositionReducedMode0.setColumns(6);
        this.maxPositionReducedMode0.setHorizontalAlignment(11);
        this.maxPositionReducedMode0.setText("10");
        this.maxPositionReducedMode0.setMaximumSize(new Dimension(120, 28));
        this.maxPositionReducedMode0.setMinimumSize(new Dimension(10, 28));
        this.maxPositionReducedMode0.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 5);
        this.add((Component)this.maxPositionReducedMode0, gridBagConstraints);
        this.maxPositionReducedMode1.setColumns(6);
        this.maxPositionReducedMode1.setHorizontalAlignment(11);
        this.maxPositionReducedMode1.setText("10");
        this.maxPositionReducedMode1.setMaximumSize(new Dimension(120, 28));
        this.maxPositionReducedMode1.setMinimumSize(new Dimension(80, 28));
        this.maxPositionReducedMode1.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 5);
        this.add((Component)this.maxPositionReducedMode1, gridBagConstraints);
        this.maxPositionReducedMode2.setColumns(6);
        this.maxPositionReducedMode2.setHorizontalAlignment(11);
        this.maxPositionReducedMode2.setText("10");
        this.maxPositionReducedMode2.setMaximumSize(new Dimension(120, 28));
        this.maxPositionReducedMode2.setMinimumSize(new Dimension(80, 28));
        this.maxPositionReducedMode2.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 5);
        this.add((Component)this.maxPositionReducedMode2, gridBagConstraints);
        this.maxPositionReducedMode3.setColumns(6);
        this.maxPositionReducedMode3.setHorizontalAlignment(11);
        this.maxPositionReducedMode3.setText("10");
        this.maxPositionReducedMode3.setMaximumSize(new Dimension(120, 28));
        this.maxPositionReducedMode3.setMinimumSize(new Dimension(80, 28));
        this.maxPositionReducedMode3.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 5);
        this.add((Component)this.maxPositionReducedMode3, gridBagConstraints);
        this.maxPositionReducedMode4.setColumns(6);
        this.maxPositionReducedMode4.setHorizontalAlignment(11);
        this.maxPositionReducedMode4.setText("10");
        this.maxPositionReducedMode4.setMaximumSize(new Dimension(120, 28));
        this.maxPositionReducedMode4.setMinimumSize(new Dimension(80, 28));
        this.maxPositionReducedMode4.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 5);
        this.add((Component)this.maxPositionReducedMode4, gridBagConstraints);
        this.maxPositionReducedMode5.setColumns(6);
        this.maxPositionReducedMode5.setHorizontalAlignment(11);
        this.maxPositionReducedMode5.setText("10");
        this.maxPositionReducedMode5.setMaximumSize(new Dimension(120, 28));
        this.maxPositionReducedMode5.setMinimumSize(new Dimension(80, 28));
        this.maxPositionReducedMode5.setPreferredSize(new Dimension(120, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 5);
        this.add((Component)this.maxPositionReducedMode5, gridBagConstraints);
        this.minimumForNormalMode.setHorizontalAlignment(0);
        this.minimumForNormalMode.setText("minimum");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 10, 0, 2);
        this.add((Component)this.minimumForNormalMode, gridBagConstraints);
        this.maximumForNormalMode.setText("maximum");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 0, 0, 5);
        this.add((Component)this.maximumForNormalMode, gridBagConstraints);
        this.minimumForReducedMode.setText("minimum");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 10, 0, 2);
        this.add((Component)this.minimumForReducedMode, gridBagConstraints);
        this.maximumForReducedMode.setText("maximum");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 0, 0, 5);
        this.add((Component)this.maximumForReducedMode, gridBagConstraints);
    }

    @Override
    public void activate() {
        this.ghostReducedModeWhenReducedModeUnavailable();
        int joint = JointType.WRIST3.getJointNumber();
        if (this.robotTool.isInfiniteRevolutionsWrist3Allowed()) {
            if (((SafetyLimitsComponent)this.safetySettingsLookupService.getSafetySetup().getComponent(SafetyLimitsComponent.class)).getWithPositionLimits(JointType.WRIST3)) {
                this.minNormalFields.get(joint).setEnabled(!this.safetyLock.isLocked());
                this.maxNormalFields.get(joint).setEnabled(!this.safetyLock.isLocked());
                this.minReducedFields.get(joint).setEnabled(!this.isReducedModeGhosted());
                this.maxReducedFields.get(joint).setEnabled(!this.isReducedModeGhosted());
            } else {
                String unlimitedLimits = this.textResource.unlimitedLimits();
                Font font = this.fontFactory.getRelativeFont(unlimitedLimits.length() > 9 ? URFontFactory.Size.SMALL : URFontFactory.Size.MEDIUM);
                this.minNormalFields.get(joint).setEnabled(false);
                this.maxNormalFields.get(joint).setEnabled(false);
                this.minNormalFields.get(joint).setText("-" + unlimitedLimits);
                this.maxNormalFields.get(joint).setText("+" + unlimitedLimits);
                this.minNormalFields.get(joint).setFont(font);
                this.maxNormalFields.get(joint).setFont(font);
                this.minReducedFields.get(joint).setEnabled(false);
                this.maxReducedFields.get(joint).setEnabled(false);
                this.minReducedFields.get(joint).setText("-" + unlimitedLimits);
                this.maxReducedFields.get(joint).setText("+" + unlimitedLimits);
                this.minReducedFields.get(joint).setFont(font);
                this.maxReducedFields.get(joint).setFont(font);
            }
        }
    }

    public void defaultLimitsWrist3() {
        String minNormal = PrimitiveUtils.WHOLE_NUMBER_FORMAT.format(PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)DEG_CONVERTER.convertFrom(-JointConfigurationSettings.WHEN_NO_DEFAULT_INSTALLATION_FILE_JOINT_POSITION_LIMIT)));
        String maxNormal = PrimitiveUtils.WHOLE_NUMBER_FORMAT.format(PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)DEG_CONVERTER.convertFrom(JointConfigurationSettings.WHEN_NO_DEFAULT_INSTALLATION_FILE_JOINT_POSITION_LIMIT)));
        String minReduced = PrimitiveUtils.WHOLE_NUMBER_FORMAT.format(PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)DEG_CONVERTER.convertFrom(-JointConfigurationSettings.WHEN_NO_DEFAULT_INSTALLATION_FILE_JOINT_POSITION_LIMIT)));
        String maxReduced = PrimitiveUtils.WHOLE_NUMBER_FORMAT.format(PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)DEG_CONVERTER.convertFrom(JointConfigurationSettings.WHEN_NO_DEFAULT_INSTALLATION_FILE_JOINT_POSITION_LIMIT)));
        int joint = JointType.WRIST3.getJointNumber();
        this.minNormalFields.get(joint).setText(minNormal);
        this.maxNormalFields.get(joint).setText(maxNormal);
        this.minReducedFields.get(joint).setText(minReduced);
        this.maxReducedFields.get(joint).setText(maxReduced);
    }

    @Override
    public void deactivate() {
    }

    class ChangeListener
    implements PropertyChangeListener {
        ChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SafetySetup safetySetup = JointPositionLimitsPanel.this.safetySettingsLookupService.getSafetySetup();
            if (safetySetup != null) {
                safetySetup.fireEvent(evt);
            }
        }
    }
}

