/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.jointlimits;

import com.ur.lang.Defense;
import com.ur.lang.EqualsUtil;
import com.ur.lang.PrimitiveUtils;
import com.ur.lang.adt.Pair;
import com.ur.math.Revolution;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.robot.configuration.RobotTool;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.DefaultSafetyLockListener;
import com.ur.safety.EnableJointPositionLimitLockListener;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.generallimits.core.SafetyLimits;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.safety.impl.JTextFieldValidatorWithStrategy;
import com.ur.safety.impl.JTtextFieldValidationWithPreConditions;
import com.ur.safety.jointlimits.JointLimitsPanel;
import com.ur.safety.jointlimits.JointLimitsPanelImpl;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.util.domain.Activatable;
import com.ur.safety.util.domain.Q;
import com.ur.swing.BindingRegistration;
import com.ur.swing.CompoundRegistration;
import com.ur.swing.DocumentUpdateListener;
import com.ur.swing.FormBuilder;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberFieldUtils;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.units.ValueConverter;
import com.ur.swing.validation.FormValidation;
import com.ur.swing.validation.SwingFormValidation;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.logging.Log;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentListener;

public class JointPositionRangePanel
extends JPanel
implements Activatable {
    private static final UnitsConverter DEG_CONVERTER = Units.getDegreesConverter();
    private static final double WRIST3_LIMIT = 1.3493037697238832E10;
    private final URFontFactory fontFactory;
    private final List<JLabel> rangeLabels = new ArrayList<JLabel>();
    private final List<JTextField> minNormalFields = new ArrayList<JTextField>();
    private final List<JTextField> maxNormalFields = new ArrayList<JTextField>();
    private final List<JTextField> minReducedFields = new ArrayList<JTextField>();
    private final List<JTextField> maxReducedFields = new ArrayList<JTextField>();
    private final List<JLabel> toleranceFields = new ArrayList<JLabel>();
    private final SwingFormValidation formValidation = new SwingFormValidation();
    private final CompoundRegistration compoundRegistration = new CompoundRegistration();
    private final ChangeListener changeListener = new ChangeListener();
    private final SafetyTextResource textResource;
    private final SafetySettingsLookupService safetySettingsLookupService;
    private final EnableJointPositionLimitLockListener safetyLockListener;
    private final JointConfigurationSettings jointConfigurationSettings;
    private final SafetyLock safetyLock;
    private final HelpIdAssigner helpIdAssigner;
    private final RobotTool robotTool;
    private JointLimitsPanelImpl parentPanel;
    private ViewContext viewContext;
    private ArrayList<BindingRegistration> validatorBindingRegistrations = new ArrayList();
    private JCheckBox infiniteRevolutionForWrist3;
    private JLabel defaultValueHeader;
    private JLabel jointsHeader;
    private JTextField maxPositionNormalMode0;
    private JTextField maxPositionNormalMode1;
    private JTextField maxPositionNormalMode2;
    private JTextField maxPositionNormalMode3;
    private JTextField maxPositionNormalMode4;
    private JTextField maxPositionNormalMode5;
    private JTextField maxPositionReducedMode0;
    private JTextField maxPositionReducedMode1;
    private JTextField maxPositionReducedMode2;
    private JTextField maxPositionReducedMode3;
    private JTextField maxPositionReducedMode4;
    private JTextField maxPositionReducedMode5;
    private JLabel maxPositionUnitLabel0;
    private JLabel maxPositionUnitLabel1;
    private JLabel maxPositionUnitLabel2;
    private JLabel maxPositionUnitLabel3;
    private JLabel maxPositionUnitLabel4;
    private JLabel maxPositionUnitLabel5;
    private JTextField minPositionNormalMode0;
    private JTextField minPositionNormalMode1;
    private JTextField minPositionNormalMode2;
    private JTextField minPositionNormalMode3;
    private JTextField minPositionNormalMode4;
    private JTextField minPositionNormalMode5;
    private JTextField minPositionReducedMode0;
    private JTextField minPositionReducedMode1;
    private JTextField minPositionReducedMode2;
    private JTextField minPositionReducedMode3;
    private JTextField minPositionReducedMode4;
    private JTextField minPositionReducedMode5;
    private JLabel normalModeHeader;
    private JLabel reducedModeHeader;
    private JLabel tolerance1;
    private JLabel tolerance2;
    private JLabel tolerance3;
    private JLabel tolerance4;
    private JLabel tolerance5;
    private JLabel tolerance6;

    JointPositionRangePanel(JointLimitsPanelImpl parentPanel, ViewContext viewContext, SafetySettingsLookupService safetySettingsLookupService, SafetyLock lock, RobotTool robotTool, JointConfigurationSettings jointConfigurationSettings) {
        this.parentPanel = parentPanel;
        this.viewContext = viewContext;
        this.safetySettingsLookupService = safetySettingsLookupService;
        this.safetyLock = lock;
        this.fontFactory = viewContext.getFontFactory();
        this.textResource = (SafetyTextResource)viewContext.getTextResource(SafetyTextResource.class);
        this.safetyLockListener = new EnableJointPositionLimitLockListener(this.safetyLock, safetySettingsLookupService);
        this.jointConfigurationSettings = jointConfigurationSettings;
        this.safetyLock.addSafetyLockListener(this.safetyLockListener);
        this.robotTool = robotTool;
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
        this.initComponents();
        this.translateGUILabels();
        this.createLists();
        this.initTable();
        this.bindNames();
        DefaultSafetyLockListener infiniteRevoluteCheckboxSafetyLockListener = new DefaultSafetyLockListener(lock, safetySettingsLookupService, new JComponent[0]);
        lock.addSafetyLockListener(infiniteRevoluteCheckboxSafetyLockListener);
        infiniteRevoluteCheckboxSafetyLockListener.addComponent(this.infiniteRevolutionForWrist3);
        this.ghostReducedModeWhenReducedModeUnavailable();
    }

    private void bindNames() {
        this.minPositionNormalMode0.setName(JointLimitsPanel.BASE_NORMAL_MODE[1]);
        this.minPositionNormalMode1.setName(JointLimitsPanel.SHOULDER_NORMAL_MODE[1]);
        this.minPositionNormalMode2.setName(JointLimitsPanel.ELBOW_NORMAL_MODE[1]);
        this.minPositionNormalMode3.setName(JointLimitsPanel.WRIST_1_NORMAL_MODE[1]);
        this.minPositionNormalMode4.setName(JointLimitsPanel.WRIST_2_NORMAL_MODE[1]);
        this.minPositionNormalMode5.setName(JointLimitsPanel.WRIST_3_NORMAL_MODE[1]);
        this.maxPositionNormalMode0.setName(JointLimitsPanel.BASE_NORMAL_MODE[2]);
        this.maxPositionNormalMode1.setName(JointLimitsPanel.SHOULDER_NORMAL_MODE[2]);
        this.maxPositionNormalMode2.setName(JointLimitsPanel.ELBOW_NORMAL_MODE[2]);
        this.maxPositionNormalMode3.setName(JointLimitsPanel.WRIST_1_NORMAL_MODE[2]);
        this.maxPositionNormalMode4.setName(JointLimitsPanel.WRIST_2_NORMAL_MODE[2]);
        this.maxPositionNormalMode5.setName(JointLimitsPanel.WRIST_3_NORMAL_MODE[2]);
        this.minPositionReducedMode0.setName(JointLimitsPanel.BASE_REDUCED_MODE[1]);
        this.minPositionReducedMode1.setName(JointLimitsPanel.SHOULDER_REDUCED_MODE[1]);
        this.minPositionReducedMode2.setName(JointLimitsPanel.ELBOW_REDUCED_MODE[1]);
        this.minPositionReducedMode3.setName(JointLimitsPanel.WRIST_1_REDUCED_MODE[1]);
        this.minPositionReducedMode4.setName(JointLimitsPanel.WRIST_2_REDUCED_MODE[1]);
        this.minPositionReducedMode5.setName(JointLimitsPanel.WRIST_3_REDUCED_MODE[1]);
        this.maxPositionReducedMode0.setName(JointLimitsPanel.BASE_REDUCED_MODE[2]);
        this.maxPositionReducedMode1.setName(JointLimitsPanel.SHOULDER_REDUCED_MODE[2]);
        this.maxPositionReducedMode2.setName(JointLimitsPanel.ELBOW_REDUCED_MODE[2]);
        this.maxPositionReducedMode3.setName(JointLimitsPanel.WRIST_1_REDUCED_MODE[2]);
        this.maxPositionReducedMode4.setName(JointLimitsPanel.WRIST_2_REDUCED_MODE[2]);
        this.maxPositionReducedMode5.setName(JointLimitsPanel.WRIST_3_REDUCED_MODE[2]);
    }

    private void createLists() {
        this.rangeLabels.add(this.maxPositionUnitLabel0);
        this.rangeLabels.add(this.maxPositionUnitLabel1);
        this.rangeLabels.add(this.maxPositionUnitLabel2);
        this.rangeLabels.add(this.maxPositionUnitLabel3);
        this.rangeLabels.add(this.maxPositionUnitLabel4);
        this.rangeLabels.add(this.maxPositionUnitLabel5);
        this.minNormalFields.add(this.minPositionNormalMode0);
        this.minNormalFields.add(this.minPositionNormalMode1);
        this.minNormalFields.add(this.minPositionNormalMode2);
        this.minNormalFields.add(this.minPositionNormalMode3);
        this.minNormalFields.add(this.minPositionNormalMode4);
        this.minNormalFields.add(this.minPositionNormalMode5);
        this.maxNormalFields.add(this.maxPositionNormalMode0);
        this.maxNormalFields.add(this.maxPositionNormalMode1);
        this.maxNormalFields.add(this.maxPositionNormalMode2);
        this.maxNormalFields.add(this.maxPositionNormalMode3);
        this.maxNormalFields.add(this.maxPositionNormalMode4);
        this.maxNormalFields.add(this.maxPositionNormalMode5);
        this.minReducedFields.add(this.minPositionReducedMode0);
        this.minReducedFields.add(this.minPositionReducedMode1);
        this.minReducedFields.add(this.minPositionReducedMode2);
        this.minReducedFields.add(this.minPositionReducedMode3);
        this.minReducedFields.add(this.minPositionReducedMode4);
        this.minReducedFields.add(this.minPositionReducedMode5);
        this.maxReducedFields.add(this.maxPositionReducedMode0);
        this.maxReducedFields.add(this.maxPositionReducedMode1);
        this.maxReducedFields.add(this.maxPositionReducedMode2);
        this.maxReducedFields.add(this.maxPositionReducedMode3);
        this.maxReducedFields.add(this.maxPositionReducedMode4);
        this.maxReducedFields.add(this.maxPositionReducedMode5);
        this.toleranceFields.add(this.tolerance1);
        this.toleranceFields.add(this.tolerance2);
        this.toleranceFields.add(this.tolerance3);
        this.toleranceFields.add(this.tolerance4);
        this.toleranceFields.add(this.tolerance5);
        this.toleranceFields.add(this.tolerance6);
        for (JTextField each : this.minNormalFields) {
            each.setHorizontalAlignment(4);
        }
        for (JTextField each : this.maxNormalFields) {
            each.setHorizontalAlignment(4);
        }
        for (JTextField each : this.minReducedFields) {
            each.setHorizontalAlignment(4);
        }
        for (JTextField each : this.maxReducedFields) {
            each.setHorizontalAlignment(4);
        }
    }

    private void translateGUILabels() {
        this.jointsHeader.setText(this.textResource.jointColumnHeader());
        this.defaultValueHeader.setText(this.textResource.rangeColumnHeader());
        this.normalModeHeader.setText(this.textResource.normalModeColumnHeader());
        this.reducedModeHeader.setText(this.textResource.reducedModeColumnHeader());
        this.helpIdAssigner.assignHelpId((JComponent)this.infiniteRevolutionForWrist3, "gui:installation_safety_joint_limits_position_range");
    }

    private void initTable() {
        int i = 0;
        while (i < this.minNormalFields.size()) {
            JTextField minNormalField = this.minNormalFields.get(i);
            JTextField maxNormalField = this.maxNormalFields.get(i);
            JTextField minReducedField = this.minReducedFields.get(i);
            JTextField maxReducedField = this.maxReducedFields.get(i);
            this.safetyLockListener.addComponent(minNormalField, JointType.fromJointNumber((int)i));
            this.safetyLockListener.addComponent(maxNormalField, JointType.fromJointNumber((int)i));
            this.safetyLockListener.addReducedModeComponent(minReducedField, JointType.fromJointNumber((int)i));
            this.safetyLockListener.addReducedModeComponent(maxReducedField, JointType.fromJointNumber((int)i));
            NumberFieldUtils.bindNumberPicker((JTextField)minNormalField, (Mode)Mode.WholeNumbers);
            NumberFieldUtils.bindNumberPicker((JTextField)maxNormalField, (Mode)Mode.WholeNumbers);
            NumberFieldUtils.bindNumberPicker((JTextField)minReducedField, (Mode)Mode.WholeNumbers);
            NumberFieldUtils.bindNumberPicker((JTextField)maxReducedField, (Mode)Mode.WholeNumbers);
            ++i;
        }
        this.updateMinAndMax();
    }

    private Pair getVerificationBoundsInDegrees() {
        double[] minimum = this.jointConfigurationSettings.getJointMinLimit();
        double[] maximum = this.jointConfigurationSettings.getJointMaxLimit();
        double[] minimumConverted = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] maximumConverted = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        JointType[] jointTypeArray = JointType.values();
        int n = jointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JointType jointType = jointTypeArray[n2];
            int j = jointType.getJointNumber();
            if (this.robotTool.isInfiniteRevolutionsWrist3Allowed() && jointType == JointType.WRIST3) {
                double wristLimit = PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)DEG_CONVERTER.convertFrom(1.3493037697238832E10));
                minimumConverted[j] = -wristLimit;
                maximumConverted[j] = wristLimit;
            } else {
                minimumConverted[j] = PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)DEG_CONVERTER.convertFrom(minimum[j]));
                maximumConverted[j] = PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)DEG_CONVERTER.convertFrom(maximum[j]));
            }
            ++n2;
        }
        return new Pair((Object)minimumConverted, (Object)maximumConverted);
    }

    private void updateMinAndMax() {
        Pair bounds = this.getVerificationBoundsInDegrees();
        double[] minimumConverted = (double[])bounds.getFirst();
        double[] maximumConverted = (double[])bounds.getSecond();
        double[] tolerances = this.safetySettingsLookupService.getSafetyComplianceTolerances().getJointPositionTolerance();
        JointType[] jointTypeArray = JointType.values();
        int n = jointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JointType each = jointTypeArray[n2];
            int jointNumber = each.getJointNumber();
            double toleranceConverted = PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)DEG_CONVERTER.convertFrom(tolerances[jointNumber]));
            if (this.robotTool.isInfiniteRevolutionsWrist3Allowed() && each == JointType.WRIST3) {
                this.rangeLabels.get(jointNumber).setText(this.textResource.unlimitedLimits());
            } else {
                this.rangeLabels.get(jointNumber).setText(this.textResource.minimumAndMaximumValue((long)minimumConverted[jointNumber], (long)maximumConverted[jointNumber], DEG_CONVERTER.getUnit()));
            }
            this.toleranceFields.get(jointNumber).setText(String.valueOf(this.textResource.plusToleranceNoDecimals(toleranceConverted, DEG_CONVERTER.getUnit())) + " / " + this.textResource.minusToleranceNoDecimals(toleranceConverted, DEG_CONVERTER.getUnit()));
            ++n2;
        }
    }

    public void bindFormValidation(FormValidation.FormListener<JComponent> ... listeners) {
        this.updateMinAndMax();
        SafetySetup safetySetup = this.safetySettingsLookupService.getSafetySetup();
        SafetyLimits normalMode = ((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class)).getNormalLimits();
        SafetyLimits reducedMode = ((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class)).getReducedLimits();
        Q minNormalModeVec = normalMode.getMinJointVector();
        Q maxNormalModeVec = normalMode.getMaxJointVector();
        Q minReducedModeVec = reducedMode.getMinJointVector();
        Q maxReducedModeVec = reducedMode.getMaxJointVector();
        this.compoundRegistration.removeRegistration();
        this.formValidation.clearForm();
        for (BindingRegistration br : this.validatorBindingRegistrations) {
            if (br == null) continue;
            br.removeRegistration();
        }
        this.validatorBindingRegistrations.clear();
        FormValidation.FormListener<JComponent>[] formListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            FormValidation.FormListener<JComponent> each = formListenerArray[n2];
            this.formValidation.addFormListener(each);
            ++n2;
        }
        this.bindFormValidation(this.formValidation);
        this.compoundRegistration.add(this.massBindToQVector(this.minNormalFields, minNormalModeVec, DEG_CONVERTER, PrimitiveUtils.WHOLE_NUMBER_FORMAT, this.changeListener));
        this.compoundRegistration.add(this.massBindToQVector(this.maxNormalFields, maxNormalModeVec, DEG_CONVERTER, PrimitiveUtils.WHOLE_NUMBER_FORMAT, this.changeListener));
        this.compoundRegistration.add(this.massBindToQVector(this.minReducedFields, minReducedModeVec, DEG_CONVERTER, PrimitiveUtils.WHOLE_NUMBER_FORMAT, this.changeListener));
        this.compoundRegistration.add(this.massBindToQVector(this.maxReducedFields, maxReducedModeVec, DEG_CONVERTER, PrimitiveUtils.WHOLE_NUMBER_FORMAT, this.changeListener));
        this.compoundRegistration.add(TextFieldUtils.bindChangeListenersToForm((FormValidation)this.formValidation, this.minNormalFields));
        this.compoundRegistration.add(TextFieldUtils.bindChangeListenersToForm((FormValidation)this.formValidation, this.maxNormalFields));
        this.compoundRegistration.add(TextFieldUtils.bindChangeListenersToForm((FormValidation)this.formValidation, this.minReducedFields));
        this.compoundRegistration.add(TextFieldUtils.bindChangeListenersToForm((FormValidation)this.formValidation, this.maxReducedFields));
        this.compoundRegistration.add(TextFieldUtils.resetValueOnError(this.minNormalFields));
        this.compoundRegistration.add(TextFieldUtils.resetValueOnError(this.maxNormalFields));
        this.compoundRegistration.add(TextFieldUtils.resetValueOnError(this.minReducedFields));
        this.compoundRegistration.add(TextFieldUtils.resetValueOnError(this.maxReducedFields));
        this.formValidation.validate();
    }

    public BindingRegistration massBindToQVector(final Collection<JTextField> fields, final Q model, UnitsConverter converter, final DecimalFormat formatter, final PropertyChangeListener changeListener) {
        Defense.isLength(fields, (int)6);
        final ValueConverter.DoubleConverter valueConverter = new ValueConverter.DoubleConverter(converter, (NumberFormat)formatter);
        BindingRegistration[] registrations = new BindingRegistration[fields.size()];
        final JTextField[] fieldsAsArray = fields.toArray(new JTextField[0]);
        int i = 0;
        while (i < fields.size()) {
            final int index = i;
            DocumentUpdateListener listener = new DocumentUpdateListener(){

                public void update() {
                    Log.trace((String)"update bindings");
                    try {
                        Revolution oldValue = model.getJoint(JointType.fromJointNumber((int)index));
                        String text = fieldsAsArray[index].getText();
                        Revolution newValue = JointPositionRangePanel.this.getJointRevolution(text, valueConverter);
                        if (!oldValue.equals((Object)newValue)) {
                            model.setJoint(JointType.fromJointNumber((int)index), newValue);
                            changeListener.propertyChange(new PropertyChangeEvent(fields.toArray()[index], "", oldValue.getTotalAngle(), newValue.getTotalAngle()));
                        }
                    }
                    catch (Throwable throwable) {}
                }
            };
            FocusAdapter formatOnExitListener = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        String valueAsString = fieldsAsArray[index].getText();
                        double value = PrimitiveUtils.parseDouble((String)valueAsString);
                        String formattedValue = formatter.format(value);
                        if (!EqualsUtil.equals((Object)formattedValue, (Object)valueAsString)) {
                            fieldsAsArray[index].setText(formattedValue);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            };
            this.setJointValueText(fieldsAsArray[i], model, i, valueConverter);
            fieldsAsArray[i].getDocument().addDocumentListener((DocumentListener)listener);
            fieldsAsArray[i].addFocusListener(formatOnExitListener);
            registrations[i] = () -> {
                fieldsAsArray[index].removeFocusListener(formatOnExitListener);
                fieldsAsArray[index].getDocument().removeDocumentListener((DocumentListener)listener);
            };
            ++i;
        }
        return new CompoundRegistration(registrations);
    }

    private Revolution getJointRevolution(String text, ValueConverter.DoubleConverter valueConverter) {
        if (text.equals("-" + this.textResource.unlimitedLimits())) {
            return new Revolution(Integer.MIN_VALUE, 0.0);
        }
        if (text.equals("+" + this.textResource.unlimitedLimits())) {
            return new Revolution(Integer.MAX_VALUE, 0.0);
        }
        return new Revolution(valueConverter.fromGui(text).doubleValue());
    }

    private void setJointValueText(JTextField textField, Q model, int joint, ValueConverter.DoubleConverter valueConverter) {
        int revolutions = model.getRevolutions()[joint];
        if (revolutions == Integer.MAX_VALUE) {
            textField.setText("+" + this.textResource.unlimitedLimits());
        } else if (revolutions == Integer.MIN_VALUE) {
            textField.setText("-" + this.textResource.unlimitedLimits());
        } else {
            textField.setText(valueConverter.fromModel(Double.valueOf(model.getTotalAngles()[joint])));
        }
    }

    private void bindFormValidation(SwingFormValidation formValidation) {
        double minJointRangeIntervalSizeInDegrees = DEG_CONVERTER.convertFrom(SafetyLimits.MIN_JOINT_RANGE_INTERVAL_SIZE);
        String reducedValueLargerThanNormalValueMessage = this.textResource.valueIsLargerThanInNormalMode();
        String reducedValueSmallerThanNormalValueMessage = this.textResource.valueIsSmallerThanInNormalMode();
        String normalValueLargerThanReducedValueMessage = this.textResource.valueIsSmallerThanInReducedMode();
        String normalValueSmallerThanReducedValueMessage = this.textResource.valueIsLargerThanInReducedMode();
        String valueCannotBeLessThanMinimum = this.textResource.valueCannotBeLessThanMinimum();
        String valueCannotBeGreaterThanMaximum = this.textResource.valueCannotBeGreaterThanMaximum();
        String rangeIntervalTooSmallMessage = this.textResource.intervalToSmall((long)minJointRangeIntervalSizeInDegrees, DEG_CONVERTER.getUnit());
        Pair bounds = this.getVerificationBoundsInDegrees();
        double[] minimumConverted = (double[])bounds.getFirst();
        double[] maximumConverted = (double[])bounds.getSecond();
        int i = 0;
        while (i < this.minNormalFields.size()) {
            JTextField minNormalField = this.minNormalFields.get(i);
            JTextField maxNormalField = this.maxNormalFields.get(i);
            JTextField minReducedField = this.minReducedFields.get(i);
            JTextField maxReducedField = this.maxReducedFields.get(i);
            minNormalField.setFocusable(false);
            maxNormalField.setFocusable(false);
            minReducedField.setFocusable(false);
            maxReducedField.setFocusable(false);
            if (!((SafetyLimitsComponent)this.safetySettingsLookupService.getSafetySetup().getComponent(SafetyLimitsComponent.class)).getWithPositionLimits(JointType.fromJointNumber((int)i))) {
                formValidation.clearStrategiesFor((JComponent)minNormalField);
                formValidation.clearStrategiesFor((JComponent)maxNormalField);
                formValidation.clearStrategiesFor((JComponent)minReducedField);
                formValidation.clearStrategiesFor((JComponent)maxReducedField);
                for (BindingRegistration br : this.validatorBindingRegistrations) {
                    br.removeRegistration();
                }
                this.validatorBindingRegistrations.clear();
                Log.debug((String)("Removed validations for " + JointType.fromJointNumber((int)i)));
            } else {
                String valueOutOfRange = this.textResource.wholeNumberOutOfRange((long)minimumConverted[i], DEG_CONVERTER.getUnit(), (long)maximumConverted[i]);
                ValidationStrategy errorRangeValidator = ValidationFactory.getRangeValidator((double)minimumConverted[i], (double)maximumConverted[i], (String)valueOutOfRange);
                JTextFieldValidatorWithStrategy minNormalFieldRangeValidator = new JTextFieldValidatorWithStrategy(minNormalField, errorRangeValidator, FormValidation.ValidationLevel.Error);
                JTextFieldValidatorWithStrategy maxNormalFieldRangeValidator = new JTextFieldValidatorWithStrategy(maxNormalField, errorRangeValidator, FormValidation.ValidationLevel.Error);
                formValidation.addErrorValidation((JComponent)minNormalField, (FormValidation.Validator)minNormalFieldRangeValidator);
                formValidation.addErrorValidation((JComponent)maxNormalField, (FormValidation.Validator)maxNormalFieldRangeValidator);
                ValidationStrategy minLessThanMaxCheckNormal = ValidationFactory.getLessThanValidator((JTextField)maxNormalField, (String)"text", (String)valueCannotBeGreaterThanMaximum);
                ValidationStrategy insideIntervalValidatorMinNormal = ValidationFactory.getMinDistanceValidator((JTextField)maxNormalField, (String)"text", (double)minJointRangeIntervalSizeInDegrees, (String)rangeIntervalTooSmallMessage);
                JTtextFieldValidationWithPreConditions minLessThanMaxAndInsideIntervalValidatorNormal = new JTtextFieldValidationWithPreConditions(minNormalField, maxNormalField, minLessThanMaxCheckNormal, true, false, FormValidation.ValidationLevel.Error, minNormalFieldRangeValidator, maxNormalFieldRangeValidator);
                minLessThanMaxAndInsideIntervalValidatorNormal.addValidationStrategy(insideIntervalValidatorMinNormal);
                formValidation.addErrorValidation((JComponent)minNormalField, (FormValidation.Validator)minLessThanMaxAndInsideIntervalValidatorNormal);
                this.validatorBindingRegistrations.add(NumberFieldUtils.bindErrorValidator((JTextField)minNormalField, (ValidationStrategy)new ValidationStrategy.Composite(new ValidationStrategy[]{errorRangeValidator, minLessThanMaxCheckNormal, insideIntervalValidatorMinNormal})));
                ValidationStrategy maxGreaterThanMinCheckNormal = ValidationFactory.getGreaterThanValidator((JTextField)minNormalField, (String)"text", (String)valueCannotBeLessThanMinimum);
                ValidationStrategy insideIntervalValidatorMaxNormal = ValidationFactory.getMinDistanceValidator((JTextField)minNormalField, (String)"text", (double)minJointRangeIntervalSizeInDegrees, (String)rangeIntervalTooSmallMessage);
                JTtextFieldValidationWithPreConditions maxGreaterThanMinAndInsideIntervalValidatorNormal = new JTtextFieldValidationWithPreConditions(maxNormalField, minNormalField, maxGreaterThanMinCheckNormal, true, false, FormValidation.ValidationLevel.Error, maxNormalFieldRangeValidator, minNormalFieldRangeValidator);
                maxGreaterThanMinAndInsideIntervalValidatorNormal.addValidationStrategy(insideIntervalValidatorMaxNormal);
                formValidation.addErrorValidation((JComponent)maxNormalField, (FormValidation.Validator)maxGreaterThanMinAndInsideIntervalValidatorNormal);
                this.validatorBindingRegistrations.add(NumberFieldUtils.bindErrorValidator((JTextField)maxNormalField, (ValidationStrategy)new ValidationStrategy.Composite(new ValidationStrategy[]{errorRangeValidator, maxGreaterThanMinCheckNormal, insideIntervalValidatorMaxNormal})));
                this.validatorBindingRegistrations.add(NumberFieldUtils.bindWarningValidator((JTextField)maxNormalField, (ValidationStrategy)new ValidationStrategy.AlwaysValid()));
                this.validatorBindingRegistrations.add(NumberFieldUtils.bindWarningValidator((JTextField)minNormalField, (ValidationStrategy)new ValidationStrategy.AlwaysValid()));
                if (this.safetySettingsLookupService.getSafetySetup().isReducedModeDefined()) {
                    JTextFieldValidatorWithStrategy minReducedFieldRangeValidator = new JTextFieldValidatorWithStrategy(minReducedField, errorRangeValidator, FormValidation.ValidationLevel.Error);
                    JTextFieldValidatorWithStrategy maxReducedFieldRangeValidator = new JTextFieldValidatorWithStrategy(maxReducedField, errorRangeValidator, FormValidation.ValidationLevel.Error);
                    formValidation.addErrorValidation((JComponent)minReducedField, (FormValidation.Validator)minReducedFieldRangeValidator);
                    formValidation.addErrorValidation((JComponent)maxReducedField, (FormValidation.Validator)maxReducedFieldRangeValidator);
                    ValidationStrategy minLessThanMaxCheckReduced = ValidationFactory.getLessThanValidator((JTextField)maxReducedField, (String)"text", (String)valueCannotBeGreaterThanMaximum);
                    ValidationStrategy insideIntervalValidatorMinReduced = ValidationFactory.getMinDistanceValidator((JTextField)maxReducedField, (String)"text", (double)minJointRangeIntervalSizeInDegrees, (String)rangeIntervalTooSmallMessage);
                    JTtextFieldValidationWithPreConditions minLessThanMaxAndInsideIntervalValidatorReduced = new JTtextFieldValidationWithPreConditions(minReducedField, maxReducedField, minLessThanMaxCheckReduced, true, false, FormValidation.ValidationLevel.Error, minReducedFieldRangeValidator, maxReducedFieldRangeValidator);
                    minLessThanMaxAndInsideIntervalValidatorReduced.addValidationStrategy(insideIntervalValidatorMinReduced);
                    formValidation.addErrorValidation((JComponent)minReducedField, (FormValidation.Validator)minLessThanMaxAndInsideIntervalValidatorReduced);
                    ValidationStrategy maxGreaterThanMinCheckReduced = ValidationFactory.getGreaterThanValidator((JTextField)minReducedField, (String)"text", (String)valueCannotBeLessThanMinimum);
                    ValidationStrategy insideIntervalValidatorMaxReduced = ValidationFactory.getMinDistanceValidator((JTextField)minReducedField, (String)"text", (double)minJointRangeIntervalSizeInDegrees, (String)rangeIntervalTooSmallMessage);
                    JTtextFieldValidationWithPreConditions maxGreaterThanMinAndInsideIntervalValidatorReduced = new JTtextFieldValidationWithPreConditions(maxReducedField, minReducedField, maxGreaterThanMinCheckReduced, true, false, FormValidation.ValidationLevel.Error, maxReducedFieldRangeValidator, minReducedFieldRangeValidator);
                    maxGreaterThanMinAndInsideIntervalValidatorReduced.addValidationStrategy(insideIntervalValidatorMaxReduced);
                    formValidation.addErrorValidation((JComponent)maxReducedField, (FormValidation.Validator)maxGreaterThanMinAndInsideIntervalValidatorReduced);
                    ValidationStrategy minReducedWarningLimitCheck = ValidationFactory.getGreaterThanValidator((JTextField)minNormalField, (String)"text", (String)reducedValueSmallerThanNormalValueMessage);
                    JTtextFieldValidationWithPreConditions reducedMinLessThanNormalMinValidator = new JTtextFieldValidationWithPreConditions(minReducedField, minNormalField, minReducedWarningLimitCheck, true, true, FormValidation.ValidationLevel.Warning, minReducedFieldRangeValidator, minNormalFieldRangeValidator, minLessThanMaxAndInsideIntervalValidatorNormal);
                    formValidation.addWarningValidation((JComponent)minReducedField, (FormValidation.Validator)reducedMinLessThanNormalMinValidator);
                    ValidationStrategy maxReducedWarningLimitCheck = ValidationFactory.getLessThanValidator((JTextField)maxNormalField, (String)"text", (String)reducedValueLargerThanNormalValueMessage);
                    JTtextFieldValidationWithPreConditions reducedMaxGreaterThanNormalMaxValidator = new JTtextFieldValidationWithPreConditions(maxReducedField, maxNormalField, maxReducedWarningLimitCheck, true, true, FormValidation.ValidationLevel.Warning, maxReducedFieldRangeValidator, maxNormalFieldRangeValidator, maxGreaterThanMinAndInsideIntervalValidatorNormal);
                    formValidation.addWarningValidation((JComponent)maxReducedField, (FormValidation.Validator)reducedMaxGreaterThanNormalMaxValidator);
                    ValidationStrategy minNormalWarningLimitCheck = ValidationFactory.getLessThanValidator((JTextField)minReducedField, (String)"text", (String)normalValueSmallerThanReducedValueMessage);
                    ValidationStrategy maxNormalWarningLimitCheck = ValidationFactory.getGreaterThanValidator((JTextField)maxReducedField, (String)"text", (String)normalValueLargerThanReducedValueMessage);
                    this.validatorBindingRegistrations.add(NumberFieldUtils.bindValidator((JTextField)minNormalField, (ValidationStrategy)new ValidationStrategy.Composite(new ValidationStrategy[]{errorRangeValidator, minLessThanMaxCheckNormal, insideIntervalValidatorMinNormal}), (ValidationStrategy)minNormalWarningLimitCheck));
                    this.validatorBindingRegistrations.add(NumberFieldUtils.bindValidator((JTextField)maxNormalField, (ValidationStrategy)new ValidationStrategy.Composite(new ValidationStrategy[]{errorRangeValidator, maxGreaterThanMinCheckNormal, insideIntervalValidatorMaxNormal}), (ValidationStrategy)maxNormalWarningLimitCheck));
                    this.validatorBindingRegistrations.add(NumberFieldUtils.bindValidator((JTextField)minReducedField, (ValidationStrategy)new ValidationStrategy.Composite(new ValidationStrategy[]{errorRangeValidator, minLessThanMaxCheckReduced, insideIntervalValidatorMinReduced}), (ValidationStrategy)minReducedWarningLimitCheck));
                    this.validatorBindingRegistrations.add(NumberFieldUtils.bindValidator((JTextField)maxReducedField, (ValidationStrategy)new ValidationStrategy.Composite(new ValidationStrategy[]{errorRangeValidator, maxGreaterThanMinCheckReduced, insideIntervalValidatorMaxReduced}), (ValidationStrategy)maxReducedWarningLimitCheck));
                }
            }
            ++i;
        }
    }

    private boolean isReducedModeGhosted() {
        SafetySetup safetySetup = this.safetySettingsLookupService.getSafetySetup();
        return !safetySetup.isReducedModeDefined() || this.safetyLock.isLocked();
    }

    private void ghostReducedModeWhenReducedModeUnavailable() {
        int i = 0;
        while (i < 6) {
            this.minReducedFields.get(i).setEnabled(!this.isReducedModeGhosted());
            this.maxReducedFields.get(i).setEnabled(!this.isReducedModeGhosted());
            ++i;
        }
    }

    private void initComponents() {
        this.jointsHeader = new JLabel();
        this.defaultValueHeader = new JLabel();
        this.normalModeHeader = new JLabel();
        this.reducedModeHeader = new JLabel();
        this.minPositionNormalMode0 = new JTextField();
        this.minPositionReducedMode0 = new JTextField();
        this.minPositionNormalMode1 = new JTextField();
        this.minPositionReducedMode1 = new JTextField();
        this.minPositionNormalMode2 = new JTextField();
        this.minPositionReducedMode2 = new JTextField();
        this.minPositionNormalMode3 = new JTextField();
        this.minPositionReducedMode3 = new JTextField();
        this.minPositionNormalMode4 = new JTextField();
        this.minPositionReducedMode4 = new JTextField();
        this.minPositionNormalMode5 = new JTextField();
        this.minPositionReducedMode5 = new JTextField();
        this.minPositionReducedMode0.setFocusable(false);
        this.minPositionReducedMode1.setFocusable(false);
        this.minPositionReducedMode2.setFocusable(false);
        this.minPositionReducedMode3.setFocusable(false);
        this.minPositionReducedMode4.setFocusable(false);
        this.minPositionReducedMode5.setFocusable(false);
        this.minPositionNormalMode0.setFocusable(false);
        this.minPositionNormalMode1.setFocusable(false);
        this.minPositionNormalMode2.setFocusable(false);
        this.minPositionNormalMode3.setFocusable(false);
        this.minPositionNormalMode4.setFocusable(false);
        this.minPositionNormalMode5.setFocusable(false);
        this.maxPositionUnitLabel0 = new JLabel();
        this.maxPositionUnitLabel1 = new JLabel();
        this.maxPositionUnitLabel2 = new JLabel();
        this.maxPositionUnitLabel3 = new JLabel();
        this.maxPositionUnitLabel4 = new JLabel();
        this.maxPositionUnitLabel5 = new JLabel();
        this.tolerance1 = new JLabel();
        this.tolerance2 = new JLabel();
        this.tolerance3 = new JLabel();
        this.tolerance4 = new JLabel();
        this.tolerance5 = new JLabel();
        this.tolerance6 = new JLabel();
        this.maxPositionNormalMode0 = new JTextField();
        this.maxPositionNormalMode1 = new JTextField();
        this.maxPositionNormalMode2 = new JTextField();
        this.maxPositionNormalMode3 = new JTextField();
        this.maxPositionNormalMode4 = new JTextField();
        this.maxPositionNormalMode5 = new JTextField();
        this.maxPositionReducedMode0 = new JTextField();
        this.maxPositionReducedMode1 = new JTextField();
        this.maxPositionReducedMode2 = new JTextField();
        this.maxPositionReducedMode3 = new JTextField();
        this.maxPositionReducedMode4 = new JTextField();
        this.maxPositionReducedMode5 = new JTextField();
        this.jointsHeader.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
        this.defaultValueHeader.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
        this.defaultValueHeader.setHorizontalAlignment(0);
        this.normalModeHeader.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
        this.normalModeHeader.setHorizontalAlignment(0);
        this.reducedModeHeader.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
        this.reducedModeHeader.setHorizontalAlignment(0);
        this.maxPositionUnitLabel0.setHorizontalAlignment(0);
        this.maxPositionUnitLabel0.setText("[unit]");
        this.maxPositionUnitLabel1.setHorizontalAlignment(0);
        this.maxPositionUnitLabel1.setText("[unit]");
        this.maxPositionUnitLabel2.setHorizontalAlignment(0);
        this.maxPositionUnitLabel2.setText("[unit]");
        this.maxPositionUnitLabel3.setHorizontalAlignment(0);
        this.maxPositionUnitLabel3.setText("[unit]");
        this.maxPositionUnitLabel4.setHorizontalAlignment(0);
        this.maxPositionUnitLabel4.setText("[unit]");
        this.maxPositionUnitLabel5.setText("[unit]");
        this.maxPositionUnitLabel5.setHorizontalAlignment(0);
        this.tolerance1.setText("<tolerance>");
        this.tolerance2.setText("<tolerance>");
        this.tolerance3.setText("<tolerance>");
        this.tolerance4.setText("<tolerance>");
        this.tolerance5.setText("<tolerance>");
        this.tolerance6.setText("<tolerance>");
        this.infiniteRevolutionForWrist3 = new JCheckBox();
        this.infiniteRevolutionForWrist3.setText(this.textResource.safetyInfiniteRevoluteWrist3());
        this.infiniteRevolutionForWrist3.addActionListener(evt -> {
            Log.debug((String)"Start Action invoked");
            SafetySetup safetySetup = this.safetySettingsLookupService.getSafetySetup();
            ((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class)).setWithPositionLimits(JointType.WRIST3, !this.infiniteRevolutionForWrist3.isSelected());
            if (!this.infiniteRevolutionForWrist3.isSelected()) {
                this.defaultLimitsWrist3();
            }
            this.parentPanel.activate();
            this.parentPanel.deactivate();
        });
        this.viewContext.createFormBuilder().label(this.jointsHeader, new FormBuilder.PanelConstraints[0]).label(this.defaultValueHeader, new FormBuilder.PanelConstraints[0]).label(this.normalModeHeader, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).label(this.reducedModeHeader, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).spacer(2).end().spacer(2).label(this.textResource.minimumColumnHeader(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).label(this.textResource.maximumColumnHeader(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).label(this.textResource.minimumColumnHeader(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).label(this.textResource.maximumColumnHeader(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.joint0Name(), new FormBuilder.PanelConstraints[0]).label(this.maxPositionUnitLabel0, new FormBuilder.PanelConstraints[0]).component((JComponent)this.minPositionNormalMode0, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionNormalMode0, new FormBuilder.PanelConstraints[0]).component((JComponent)this.minPositionReducedMode0, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionReducedMode0, new FormBuilder.PanelConstraints[0]).label(this.tolerance1, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.joint1Name(), new FormBuilder.PanelConstraints[0]).label(this.maxPositionUnitLabel1, new FormBuilder.PanelConstraints[0]).component((JComponent)this.minPositionNormalMode1, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionNormalMode1, new FormBuilder.PanelConstraints[0]).component((JComponent)this.minPositionReducedMode1, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionReducedMode1, new FormBuilder.PanelConstraints[0]).label(this.tolerance2, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.joint2Name(), new FormBuilder.PanelConstraints[0]).label(this.maxPositionUnitLabel2, new FormBuilder.PanelConstraints[0]).component((JComponent)this.minPositionNormalMode2, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionNormalMode2, new FormBuilder.PanelConstraints[0]).component((JComponent)this.minPositionReducedMode2, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionReducedMode2, new FormBuilder.PanelConstraints[0]).label(this.tolerance3, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.joint3Name(), new FormBuilder.PanelConstraints[0]).label(this.maxPositionUnitLabel3, new FormBuilder.PanelConstraints[0]).component((JComponent)this.minPositionNormalMode3, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionNormalMode3, new FormBuilder.PanelConstraints[0]).component((JComponent)this.minPositionReducedMode3, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionReducedMode3, new FormBuilder.PanelConstraints[0]).label(this.tolerance4, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.joint4Name(), new FormBuilder.PanelConstraints[0]).label(this.maxPositionUnitLabel4, new FormBuilder.PanelConstraints[0]).component((JComponent)this.minPositionNormalMode4, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionNormalMode4, new FormBuilder.PanelConstraints[0]).component((JComponent)this.minPositionReducedMode4, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionReducedMode4, new FormBuilder.PanelConstraints[0]).label(this.tolerance5, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.joint5Name(), new FormBuilder.PanelConstraints[0]).label(this.maxPositionUnitLabel5, new FormBuilder.PanelConstraints[0]).component((JComponent)this.minPositionNormalMode5, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionNormalMode5, new FormBuilder.PanelConstraints[0]).component((JComponent)this.minPositionReducedMode5, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionReducedMode5, new FormBuilder.PanelConstraints[0]).label(this.tolerance6, new FormBuilder.PanelConstraints[0]).end().component((JComponent)this.infiniteRevolutionForWrist3, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).setOnPanel((JPanel)this);
        this.setBorder(new CompoundBorder((Border)new CardBorder(this.textResource.safetyLimitsRangeJointPos()), this.getBorder()));
    }

    @Override
    public void activate() {
        this.ghostReducedModeWhenReducedModeUnavailable();
        int joint = JointType.WRIST3.getJointNumber();
        this.infiniteRevolutionForWrist3.setVisible(false);
        if (this.robotTool.isInfiniteRevolutionsWrist3Allowed()) {
            if (((SafetyLimitsComponent)this.safetySettingsLookupService.getSafetySetup().getComponent(SafetyLimitsComponent.class)).getWithPositionLimits(JointType.WRIST3)) {
                this.minNormalFields.get(joint).setEnabled(!this.safetyLock.isLocked());
                this.maxNormalFields.get(joint).setEnabled(!this.safetyLock.isLocked());
                this.minReducedFields.get(joint).setEnabled(!this.isReducedModeGhosted());
                this.maxReducedFields.get(joint).setEnabled(!this.isReducedModeGhosted());
                this.infiniteRevolutionForWrist3.setSelected(false);
            } else {
                this.minNormalFields.get(joint).setEnabled(false);
                this.maxNormalFields.get(joint).setEnabled(false);
                this.minNormalFields.get(joint).setText("-" + this.textResource.unlimitedLimits());
                this.maxNormalFields.get(joint).setText("+" + this.textResource.unlimitedLimits());
                this.minReducedFields.get(joint).setEnabled(false);
                this.maxReducedFields.get(joint).setEnabled(false);
                this.minReducedFields.get(joint).setText("-" + this.textResource.unlimitedLimits());
                this.maxReducedFields.get(joint).setText("+" + this.textResource.unlimitedLimits());
                this.infiniteRevolutionForWrist3.setSelected(true);
            }
            this.infiniteRevolutionForWrist3.setVisible(true);
        }
    }

    public void defaultLimitsWrist3() {
        String minNormal = PrimitiveUtils.WHOLE_NUMBER_FORMAT.format(PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)DEG_CONVERTER.convertFrom(-JointConfigurationSettings.WHEN_NO_DEFAULT_INSTALLATION_FILE_JOINT_POSITION_LIMIT)));
        String maxNormal = PrimitiveUtils.WHOLE_NUMBER_FORMAT.format(PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)DEG_CONVERTER.convertFrom(JointConfigurationSettings.WHEN_NO_DEFAULT_INSTALLATION_FILE_JOINT_POSITION_LIMIT)));
        String minReduced = PrimitiveUtils.WHOLE_NUMBER_FORMAT.format(PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)DEG_CONVERTER.convertFrom(-JointConfigurationSettings.WHEN_NO_DEFAULT_INSTALLATION_FILE_JOINT_POSITION_LIMIT)));
        String maxReduced = PrimitiveUtils.WHOLE_NUMBER_FORMAT.format(PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)DEG_CONVERTER.convertFrom(JointConfigurationSettings.WHEN_NO_DEFAULT_INSTALLATION_FILE_JOINT_POSITION_LIMIT)));
        int joint = JointType.WRIST3.getJointNumber();
        this.minNormalFields.get(joint).setText(minNormal);
        this.maxNormalFields.get(joint).setText(maxNormal);
        this.minReducedFields.get(joint).setText(minReduced);
        this.maxReducedFields.get(joint).setText(maxReduced);
    }

    @Override
    public void deactivate() {
    }

    class ChangeListener
    implements PropertyChangeListener {
        ChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SafetySetup safetySetup = JointPositionRangePanel.this.safetySettingsLookupService.getSafetySetup();
            if (safetySetup != null) {
                safetySetup.fireEvent(evt);
            }
        }
    }
}

