/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.jointlimits;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.HTMLPage;
import com.ur.safety.SafetySetupPanesLookAndFeel;
import com.ur.safety.SafetySetupToHtmlContribution;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.generallimits.core.SafetyLimits;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.safety.util.domain.AlternatingBackgroundRowGenerator;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.util.swing.HTML;
import java.text.DecimalFormat;
import javax.inject.Inject;

public class JointPositionToHtmlRenderer
implements SafetySetupToHtmlContribution {
    private final SafetyTextResource translation;
    private final SafetySetupPanesLookAndFeel lookAndFeel;
    private UnitsConverter jointPositionConverter;
    private DecimalFormat degFormat;
    private AlternatingBackgroundRowGenerator rowGenerator;

    @Inject
    public JointPositionToHtmlRenderer(SafetyTextResource translation, SafetySetupPanesLookAndFeel lookAndFeel) {
        this.translation = translation;
        this.lookAndFeel = lookAndFeel;
    }

    @Override
    public HTMLPage createContributedPage(SafetySetup safetySetup, boolean useSIUnits) {
        this.degFormat = useSIUnits ? DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.0000") : PrimitiveUtils.WHOLE_NUMBER_FORMAT;
        this.jointPositionConverter = useSIUnits ? Units.getRadiansConverter() : Units.getDegreesConverter();
        this.rowGenerator = new AlternatingBackgroundRowGenerator();
        SafetyLimits normalMode = ((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class)).getNormalLimits();
        SafetyLimits reducedMode = ((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class)).getReducedLimits();
        if (safetySetup.isReducedModeDefined() || useSIUnits) {
            return new HTMLPage(this.translation.jointPosition(), this.generateJointLimits(normalMode, reducedMode));
        }
        return new HTMLPage(this.translation.jointPosition(), this.generateJointLimits(normalMode));
    }

    private String generateJointLimits(SafetyLimits normalMode, SafetyLimits reducedMode) {
        return HTML.table((int)this.lookAndFeel.panelWidth, (String[])new String[]{HTML.tableRow((String[])new String[]{HTML.tableHeaderWithProperties((String)"align=left", (String)this.translation.jointColumnHeader()), HTML.tableHeaderWithProperties((String)"align=center", (String)this.translation.normalModeColumnHeader()), HTML.tableHeaderWithProperties((String)"align=center colspan=2", (String)this.translation.reducedModeColumnHeader())}), this.jointLimitRow(this.translation.joint0Name(), normalMode, reducedMode, 0, this.translation), this.jointLimitRow(this.translation.joint1Name(), normalMode, reducedMode, 1, this.translation), this.jointLimitRow(this.translation.joint2Name(), normalMode, reducedMode, 2, this.translation), this.jointLimitRow(this.translation.joint3Name(), normalMode, reducedMode, 3, this.translation), this.jointLimitRow(this.translation.joint4Name(), normalMode, reducedMode, 4, this.translation), this.jointLimitRow(this.translation.joint5Name(), normalMode, reducedMode, 5, this.translation)});
    }

    private String generateJointLimits(SafetyLimits normalMode) {
        return HTML.table((int)this.lookAndFeel.panelWidth, (String[])new String[]{HTML.tableRow((String[])new String[]{HTML.tableHeaderWithProperties((String)"align=left", (String)this.translation.jointColumnHeader()), HTML.tableHeaderWithProperties((String)"align=center", (String)this.translation.position())}), this.jointLimitRow(this.translation.joint0Name(), normalMode, 0, this.translation), this.jointLimitRow(this.translation.joint1Name(), normalMode, 1, this.translation), this.jointLimitRow(this.translation.joint2Name(), normalMode, 2, this.translation), this.jointLimitRow(this.translation.joint3Name(), normalMode, 3, this.translation), this.jointLimitRow(this.translation.joint4Name(), normalMode, 4, this.translation), this.jointLimitRow(this.translation.joint5Name(), normalMode, 5, this.translation)});
    }

    private boolean isInfinite(int i) {
        return i == Integer.MAX_VALUE || i == Integer.MIN_VALUE;
    }

    private String jointLimitRow(String jointName, SafetyLimits normalMode, int jointId, SafetyTextResource safetyTextResource) {
        JointType jointType = JointType.fromJointNumber((int)jointId);
        String minPositionFormatted = this.degFormat.format(this.jointPositionConverter.convertFrom(normalMode.getMinJointPosition(jointType).getTotalAngle()));
        String maxPositionFormatted = this.degFormat.format(this.jointPositionConverter.convertFrom(normalMode.getMaxJointPosition(jointType).getTotalAngle()));
        String positionRange = String.format("[%s:%s] %s", minPositionFormatted, maxPositionFormatted, this.jointPositionConverter.getUnit());
        if (this.isInfinite(normalMode.getMinJointPosition(jointType).getRevolutions()) && this.isInfinite(normalMode.getMaxJointPosition(jointType).getRevolutions())) {
            positionRange = safetyTextResource.unlimitedLimits();
        }
        return this.rowGenerator.generate(HTML.tableCell((String)jointName), HTML.tableCellWithProperties((String)"align=center", (String)positionRange));
    }

    private String jointLimitRow(String jointName, SafetyLimits normalMode, SafetyLimits reducedMode, int jointId, SafetyTextResource tr) {
        JointType jointType = JointType.fromJointNumber((int)jointId);
        String minPositionNormalFormatted = this.degFormat.format(this.jointPositionConverter.convertFrom(normalMode.getMinJointPosition(jointType).getTotalAngle()));
        String maxPositionNormalFormatted = this.degFormat.format(this.jointPositionConverter.convertFrom(normalMode.getMaxJointPosition(jointType).getTotalAngle()));
        String minPositionReducedFormatted = this.degFormat.format(this.jointPositionConverter.convertFrom(reducedMode.getMinJointPosition(jointType).getTotalAngle()));
        String maxPositionReducedFormatted = this.degFormat.format(this.jointPositionConverter.convertFrom(reducedMode.getMaxJointPosition(jointType).getTotalAngle()));
        String normalPositionRange = String.format(" [%s : %s]", minPositionNormalFormatted, maxPositionNormalFormatted);
        String reducedPositionRange = String.format("[%s : %s]", minPositionReducedFormatted, maxPositionReducedFormatted);
        if (this.isInfinite(normalMode.getMinJointPosition(jointType).getRevolutions()) && this.isInfinite(normalMode.getMaxJointPosition(jointType).getRevolutions())) {
            normalPositionRange = tr.unlimitedLimits();
        }
        if (this.isInfinite(reducedMode.getMinJointPosition(jointType).getRevolutions()) && this.isInfinite(reducedMode.getMaxJointPosition(jointType).getRevolutions())) {
            reducedPositionRange = tr.unlimitedLimits();
        }
        return this.rowGenerator.generate(HTML.tableCell((String)jointName), HTML.tableCellWithProperties((String)"align=center", (String)normalPositionRange), HTML.tableCellNumber((String)reducedPositionRange), HTML.tableCell((String)this.jointPositionConverter.getUnit()));
    }
}

