/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.jointlimits;

import com.ur.lang.PrimitiveUtils;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.EnableJointSpeedLimitLockListener;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.generallimits.core.SafetyLimits;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.safety.impl.JTextFieldValidatorWithStrategy;
import com.ur.safety.impl.JTtextFieldValidationWithPreConditions;
import com.ur.safety.jointlimits.JointLimitsPanel;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.util.domain.Activatable;
import com.ur.swing.BindingRegistration;
import com.ur.swing.CompletedListener;
import com.ur.swing.CompoundRegistration;
import com.ur.swing.FormBuilder;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberFieldUtils;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.validation.FormValidation;
import com.ur.swing.validation.SwingFormValidation;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class JointSpeedLimitsPanel
extends JPanel
implements Activatable {
    private final URFontFactory fontFactory;
    private final List<JLabel> unitLabels = new ArrayList<JLabel>();
    private final List<JTextField> normalFields = new ArrayList<JTextField>();
    private final List<JTextField> reducedFields = new ArrayList<JTextField>();
    private final List<JLabel> toleranceFields = new ArrayList<JLabel>();
    private final SwingFormValidation formValidation = new SwingFormValidation();
    private final CompoundRegistration compoundRegistration = new CompoundRegistration();
    private final ChangeListener changeListener = new ChangeListener();
    private final double[] minimum = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private final UnitsConverter converter = Units.getDegreesPerSecondConverter();
    private final SafetyTextResource textResource;
    private final SafetySettingsLookupService safetySettingsLookupService;
    private final EnableJointSpeedLimitLockListener safetyLockListener;
    private final SafetyLock safetyLock;
    private double[] maximum;
    private final ValidationStrategy[] errorRangeValidators;
    private final BindingRegistration[] normalFieldErrorRangeValidatorBindingRegistrations;
    private final BindingRegistration[] reducedFieldErrorRangeValidatorBindingRegistrations;
    private ViewContext viewContext;
    private JLabel defaultValueHeader;
    private JLabel jointsHeader;
    private JTextField maxPositionNormalMode0;
    private JTextField maxPositionNormalMode1;
    private JTextField maxPositionNormalMode2;
    private JTextField maxPositionNormalMode3;
    private JTextField maxPositionNormalMode4;
    private JTextField maxPositionNormalMode5;
    private JTextField maxPositionReducedMode0;
    private JTextField maxPositionReducedMode1;
    private JTextField maxPositionReducedMode2;
    private JTextField maxPositionReducedMode3;
    private JTextField maxPositionReducedMode4;
    private JTextField maxPositionReducedMode5;
    private JLabel maxPositionUnitLabel0;
    private JLabel maxPositionUnitLabel1;
    private JLabel maxPositionUnitLabel2;
    private JLabel maxPositionUnitLabel3;
    private JLabel maxPositionUnitLabel4;
    private JLabel maxPositionUnitLabel5;
    private JLabel normalModeHeader;
    private JLabel reducedModeHeader;
    private JLabel tolerance1;
    private JLabel tolerance2;
    private JLabel tolerance3;
    private JLabel tolerance4;
    private JLabel tolerance5;
    private JLabel tolerance6;
    private final JointConfigurationSettings jointConfigurationSettings;

    public JointSpeedLimitsPanel(ViewContext viewContext, SafetySettingsLookupService safetySettingsLookupService, SafetyLock safetyLock, JointConfigurationSettings jointConfigurationSettings) {
        this.viewContext = viewContext;
        this.safetySettingsLookupService = safetySettingsLookupService;
        this.safetyLock = safetyLock;
        this.fontFactory = viewContext.getFontFactory();
        this.textResource = (SafetyTextResource)viewContext.getTextResource(SafetyTextResource.class);
        this.safetyLockListener = new EnableJointSpeedLimitLockListener(safetyLock, safetySettingsLookupService);
        this.jointConfigurationSettings = jointConfigurationSettings;
        this.maximum = jointConfigurationSettings.getJointMaxSpeed();
        this.errorRangeValidators = new ValidationStrategy[this.maximum.length];
        this.normalFieldErrorRangeValidatorBindingRegistrations = new BindingRegistration[this.maximum.length];
        this.reducedFieldErrorRangeValidatorBindingRegistrations = new BindingRegistration[this.maximum.length];
        safetyLock.addSafetyLockListener(this.safetyLockListener);
        this.initComponents();
        this.translateGUILabels();
        Arrays.fill(this.minimum, SafetyLimits.MIN_JOINT_SPEED);
        this.bindNames();
        this.createLists();
        this.initTable();
    }

    private void bindNames() {
        this.maxPositionNormalMode0.setName(JointLimitsPanel.BASE_NORMAL_MODE[0]);
        this.maxPositionNormalMode1.setName(JointLimitsPanel.SHOULDER_NORMAL_MODE[0]);
        this.maxPositionNormalMode2.setName(JointLimitsPanel.ELBOW_NORMAL_MODE[0]);
        this.maxPositionNormalMode3.setName(JointLimitsPanel.WRIST_1_NORMAL_MODE[0]);
        this.maxPositionNormalMode4.setName(JointLimitsPanel.WRIST_2_NORMAL_MODE[0]);
        this.maxPositionNormalMode5.setName(JointLimitsPanel.WRIST_3_NORMAL_MODE[0]);
        this.maxPositionReducedMode0.setName(JointLimitsPanel.BASE_REDUCED_MODE[0]);
        this.maxPositionReducedMode1.setName(JointLimitsPanel.SHOULDER_REDUCED_MODE[0]);
        this.maxPositionReducedMode2.setName(JointLimitsPanel.ELBOW_REDUCED_MODE[0]);
        this.maxPositionReducedMode3.setName(JointLimitsPanel.WRIST_1_REDUCED_MODE[0]);
        this.maxPositionReducedMode4.setName(JointLimitsPanel.WRIST_2_REDUCED_MODE[0]);
        this.maxPositionReducedMode5.setName(JointLimitsPanel.WRIST_3_REDUCED_MODE[0]);
    }

    private void createLists() {
        this.unitLabels.add(this.maxPositionUnitLabel0);
        this.unitLabels.add(this.maxPositionUnitLabel1);
        this.unitLabels.add(this.maxPositionUnitLabel2);
        this.unitLabels.add(this.maxPositionUnitLabel3);
        this.unitLabels.add(this.maxPositionUnitLabel4);
        this.unitLabels.add(this.maxPositionUnitLabel5);
        this.normalFields.add(this.maxPositionNormalMode0);
        this.normalFields.add(this.maxPositionNormalMode1);
        this.normalFields.add(this.maxPositionNormalMode2);
        this.normalFields.add(this.maxPositionNormalMode3);
        this.normalFields.add(this.maxPositionNormalMode4);
        this.normalFields.add(this.maxPositionNormalMode5);
        this.reducedFields.add(this.maxPositionReducedMode0);
        this.reducedFields.add(this.maxPositionReducedMode1);
        this.reducedFields.add(this.maxPositionReducedMode2);
        this.reducedFields.add(this.maxPositionReducedMode3);
        this.reducedFields.add(this.maxPositionReducedMode4);
        this.reducedFields.add(this.maxPositionReducedMode5);
        this.toleranceFields.add(this.tolerance1);
        this.toleranceFields.add(this.tolerance2);
        this.toleranceFields.add(this.tolerance3);
        this.toleranceFields.add(this.tolerance4);
        this.toleranceFields.add(this.tolerance5);
        this.toleranceFields.add(this.tolerance6);
    }

    private void translateGUILabels() {
        this.jointsHeader.setText(this.textResource.jointColumnHeader());
        this.defaultValueHeader.setText(this.textResource.maximumColumnHeader());
        this.normalModeHeader.setText(this.textResource.normalModeColumnHeader());
        this.reducedModeHeader.setText(this.textResource.reducedModeColumnHeader());
    }

    private void initTable() {
        int i = 0;
        while (i < this.normalFields.size()) {
            final JTextField normalField = this.normalFields.get(i);
            final JTextField reducedField = this.reducedFields.get(i);
            this.safetyLockListener.addComponent(normalField, JointType.fromJointNumber((int)i));
            this.safetyLockListener.addReducedModeComponent(reducedField, JointType.fromJointNumber((int)i));
            normalField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    NumberFieldUtils.updateFollowerWhenEnabled((JTextField)normalField, (JTextField)reducedField);
                }
            });
            NumberFieldUtils.bindNumberPicker((JTextField)normalField, (CompletedListener)new CompletedListener.Template(){

                public void requestApply() {
                    NumberFieldUtils.updateFollowerWhenEnabled((JTextField)normalField, (JTextField)reducedField);
                }
            }, (Mode)Mode.PositiveWholeNumbers);
            NumberFieldUtils.bindNumberPicker((JTextField)reducedField, (Mode)Mode.PositiveWholeNumbers);
            ++i;
        }
        this.updateMinAndMax();
    }

    private void updateMinAndMax() {
        double[] tolerances = this.safetySettingsLookupService.getSafetyComplianceTolerances().getJointSpeedTolerance();
        this.maximum = this.jointConfigurationSettings.getJointMaxSpeed();
        double[] minimumConverted = new double[6];
        double[] maximumConverted = new double[6];
        int i = 0;
        while (i < this.normalFields.size()) {
            minimumConverted[i] = PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)this.converter.convertFrom(this.minimum[i]));
            maximumConverted[i] = PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)this.converter.convertFrom(this.maximum[i]));
            double toleranceConverted = PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)this.converter.convertFrom(tolerances[i]));
            String valueOutOfRange = this.textResource.wholeNumberOutOfRange((long)minimumConverted[i], this.converter.getUnit(), (long)maximumConverted[i]);
            double minI = minimumConverted[i];
            double maxI = maximumConverted[i];
            this.errorRangeValidators[i] = ValidationFactory.getRangeValidator((double)minI, (double)maxI, (String)valueOutOfRange);
            this.unitLabels.get(i).setText(this.textResource.maximumNumericValue(maximumConverted[i], this.converter.getUnit()));
            this.toleranceFields.get(i).setText(this.textResource.minusToleranceNoDecimals(toleranceConverted, this.converter.getUnit()));
            ++i;
        }
    }

    public void bindFormValidation(FormValidation.FormListener<JComponent> ... listeners) {
        BindingRegistration br;
        this.updateMinAndMax();
        SafetySetup safetySetup = this.safetySettingsLookupService.getSafetySetup();
        double[] normalMode = ((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class)).getNormalLimits().getMaxJointSpeeds();
        double[] reducedMode = ((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class)).getReducedLimits().getMaxJointSpeeds();
        this.compoundRegistration.removeRegistration();
        this.formValidation.clearForm();
        BindingRegistration[] bindingRegistrationArray = this.normalFieldErrorRangeValidatorBindingRegistrations;
        int n = this.normalFieldErrorRangeValidatorBindingRegistrations.length;
        int n2 = 0;
        while (n2 < n) {
            br = bindingRegistrationArray[n2];
            if (br != null) {
                br.removeRegistration();
            }
            ++n2;
        }
        bindingRegistrationArray = this.reducedFieldErrorRangeValidatorBindingRegistrations;
        n = this.reducedFieldErrorRangeValidatorBindingRegistrations.length;
        n2 = 0;
        while (n2 < n) {
            br = bindingRegistrationArray[n2];
            if (br != null) {
                br.removeRegistration();
            }
            ++n2;
        }
        bindingRegistrationArray = listeners;
        n = listeners.length;
        n2 = 0;
        while (n2 < n) {
            BindingRegistration each = bindingRegistrationArray[n2];
            this.formValidation.addFormListener((FormValidation.FormListener)each);
            ++n2;
        }
        this.bindFormValidation(this.formValidation);
        this.compoundRegistration.add(TextFieldUtils.massBindToDoubleArray(this.normalFields, (double[])normalMode, (UnitsConverter)this.converter, (DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (PropertyChangeListener)this.changeListener));
        this.compoundRegistration.add(TextFieldUtils.massBindToDoubleArray(this.reducedFields, (double[])reducedMode, (UnitsConverter)this.converter, (DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (PropertyChangeListener)this.changeListener));
        this.compoundRegistration.add(TextFieldUtils.bindChangeListenersToForm((FormValidation)this.formValidation, (JTextField[])new JTextField[]{this.maxPositionNormalMode0, this.maxPositionNormalMode1, this.maxPositionNormalMode2, this.maxPositionNormalMode3, this.maxPositionNormalMode4, this.maxPositionNormalMode5}));
        this.compoundRegistration.add(TextFieldUtils.bindChangeListenersToForm((FormValidation)this.formValidation, (JTextField[])new JTextField[]{this.maxPositionReducedMode0, this.maxPositionReducedMode1, this.maxPositionReducedMode2, this.maxPositionReducedMode3, this.maxPositionReducedMode4, this.maxPositionReducedMode5}));
        this.compoundRegistration.add(TextFieldUtils.resetValueOnError((JTextField[])new JTextField[]{this.maxPositionNormalMode0, this.maxPositionNormalMode1, this.maxPositionNormalMode2, this.maxPositionNormalMode3, this.maxPositionNormalMode4, this.maxPositionNormalMode5}));
        this.compoundRegistration.add(TextFieldUtils.resetValueOnError((JTextField[])new JTextField[]{this.maxPositionReducedMode0, this.maxPositionReducedMode1, this.maxPositionReducedMode2, this.maxPositionReducedMode3, this.maxPositionReducedMode4, this.maxPositionReducedMode5}));
        this.formValidation.validate();
    }

    private void bindFormValidation(SwingFormValidation formValidation) {
        String reducedValueInformationMessage = this.textResource.valueIsLargerThanInNormalMode();
        String normalValueInformationMessage = this.textResource.valueIsSmallerThanInReducedMode();
        int i = 0;
        while (i < this.normalFields.size()) {
            JTextField normalField = this.normalFields.get(i);
            JTextField reducedField = this.reducedFields.get(i);
            JTextFieldValidatorWithStrategy normalValidRangeValidator = new JTextFieldValidatorWithStrategy(normalField, this.errorRangeValidators[i], FormValidation.ValidationLevel.Error);
            this.normalFieldErrorRangeValidatorBindingRegistrations[i] = NumberFieldUtils.bindErrorValidator((JTextField)normalField, (ValidationStrategy)this.errorRangeValidators[i]);
            formValidation.addErrorValidation((JComponent)normalField, (FormValidation.Validator)normalValidRangeValidator);
            if (this.safetySettingsLookupService.getSafetySetup().isReducedModeDefined()) {
                JTextFieldValidatorWithStrategy reducedValidRangeValidator = new JTextFieldValidatorWithStrategy(reducedField, this.errorRangeValidators[i], FormValidation.ValidationLevel.Error);
                formValidation.addErrorValidation((JComponent)reducedField, (FormValidation.Validator)reducedValidRangeValidator);
                double maximumConverted = PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)this.converter.convertFrom(this.maximum[i]));
                ValidationStrategy normalNotLowerThanReducedLimitCheck = ValidationFactory.getRangeValidator((Object)reducedField, (String)"text", (double)maximumConverted, (String)normalValueInformationMessage);
                JTtextFieldValidationWithPreConditions normalNotLowerThanReducedValidator = new JTtextFieldValidationWithPreConditions(normalField, reducedField, normalNotLowerThanReducedLimitCheck, true, true, FormValidation.ValidationLevel.Error, reducedValidRangeValidator, normalValidRangeValidator);
                double minimumconverted = PrimitiveUtils.applyDecimalFormat((DecimalFormat)PrimitiveUtils.WHOLE_NUMBER_FORMAT, (double)this.converter.convertFrom(this.minimum[i]));
                ValidationStrategy reducedNotHigherThanNormalLimitCheck = ValidationFactory.getRangeValidator((double)minimumconverted, (Object)normalField, (String)"text", (String)reducedValueInformationMessage);
                JTtextFieldValidationWithPreConditions reducedNotHigherThanNormalValidator = new JTtextFieldValidationWithPreConditions(reducedField, normalField, reducedNotHigherThanNormalLimitCheck, true, true, FormValidation.ValidationLevel.Error, reducedValidRangeValidator, normalValidRangeValidator);
                formValidation.addErrorValidation((JComponent)normalField, (FormValidation.Validator)normalNotLowerThanReducedValidator);
                formValidation.addErrorValidation((JComponent)reducedField, (FormValidation.Validator)reducedNotHigherThanNormalValidator);
                this.normalFieldErrorRangeValidatorBindingRegistrations[i] = NumberFieldUtils.bindErrorValidator((JTextField)normalField, (ValidationStrategy)new ValidationStrategy.Composite(new ValidationStrategy[]{this.errorRangeValidators[i], normalNotLowerThanReducedLimitCheck}));
                this.reducedFieldErrorRangeValidatorBindingRegistrations[i] = NumberFieldUtils.bindErrorValidator((JTextField)reducedField, (ValidationStrategy)new ValidationStrategy.Composite(new ValidationStrategy[]{this.errorRangeValidators[i], reducedNotHigherThanNormalLimitCheck}));
            }
            ++i;
        }
    }

    private void ghostReducedModeWhenReducedModeUnavailable() {
        SafetySetup safetySetup = this.safetySettingsLookupService.getSafetySetup();
        boolean isEnabled = safetySetup.isReducedModeDefined() && !this.safetyLock.isLocked();
        for (JTextField each : this.reducedFields) {
            each.setEnabled(isEnabled);
        }
    }

    private void initComponents() {
        this.jointsHeader = new JLabel();
        this.defaultValueHeader = new JLabel();
        this.normalModeHeader = new JLabel();
        this.reducedModeHeader = new JLabel();
        this.maxPositionNormalMode0 = new JTextField();
        this.maxPositionReducedMode0 = new JTextField();
        this.maxPositionNormalMode1 = new JTextField();
        this.maxPositionReducedMode1 = new JTextField();
        this.maxPositionNormalMode2 = new JTextField();
        this.maxPositionReducedMode2 = new JTextField();
        this.maxPositionNormalMode3 = new JTextField();
        this.maxPositionReducedMode3 = new JTextField();
        this.maxPositionNormalMode4 = new JTextField();
        this.maxPositionReducedMode4 = new JTextField();
        this.maxPositionNormalMode5 = new JTextField();
        this.maxPositionReducedMode5 = new JTextField();
        this.maxPositionNormalMode0.setFocusable(false);
        this.maxPositionNormalMode1.setFocusable(false);
        this.maxPositionNormalMode2.setFocusable(false);
        this.maxPositionNormalMode3.setFocusable(false);
        this.maxPositionNormalMode4.setFocusable(false);
        this.maxPositionNormalMode5.setFocusable(false);
        this.maxPositionReducedMode0.setFocusable(false);
        this.maxPositionReducedMode1.setFocusable(false);
        this.maxPositionReducedMode2.setFocusable(false);
        this.maxPositionReducedMode3.setFocusable(false);
        this.maxPositionReducedMode4.setFocusable(false);
        this.maxPositionReducedMode5.setFocusable(false);
        this.maxPositionUnitLabel0 = new JLabel();
        this.maxPositionUnitLabel1 = new JLabel();
        this.maxPositionUnitLabel2 = new JLabel();
        this.maxPositionUnitLabel3 = new JLabel();
        this.maxPositionUnitLabel4 = new JLabel();
        this.maxPositionUnitLabel5 = new JLabel();
        this.tolerance1 = new JLabel();
        this.tolerance2 = new JLabel();
        this.tolerance3 = new JLabel();
        this.tolerance4 = new JLabel();
        this.tolerance5 = new JLabel();
        this.tolerance6 = new JLabel();
        this.jointsHeader.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
        this.defaultValueHeader.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
        this.defaultValueHeader.setHorizontalAlignment(0);
        this.normalModeHeader.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
        this.normalModeHeader.setHorizontalAlignment(0);
        this.reducedModeHeader.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
        this.reducedModeHeader.setHorizontalAlignment(0);
        this.maxPositionUnitLabel0.setText("[unit]");
        this.maxPositionUnitLabel1.setText("[unit]");
        this.maxPositionUnitLabel2.setText("[unit]");
        this.maxPositionUnitLabel3.setText("[unit]");
        this.maxPositionUnitLabel4.setText("[unit]");
        this.maxPositionUnitLabel5.setText("[unit]");
        this.tolerance1.setText("<tolerance>");
        this.tolerance2.setText("<tolerance>");
        this.tolerance3.setText("<tolerance>");
        this.tolerance4.setText("<tolerance>");
        this.tolerance5.setText("<tolerance>");
        this.tolerance6.setText("<tolerance>");
        this.viewContext.createFormBuilder().label(this.jointsHeader, new FormBuilder.PanelConstraints[0]).label(this.defaultValueHeader, new FormBuilder.PanelConstraints[0]).label(this.normalModeHeader, new FormBuilder.PanelConstraints[0]).label(this.reducedModeHeader, new FormBuilder.PanelConstraints[0]).spacer(2).end().label(this.textResource.joint0Name(), new FormBuilder.PanelConstraints[0]).label(this.maxPositionUnitLabel0, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionNormalMode0, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionReducedMode0, new FormBuilder.PanelConstraints[0]).label(this.tolerance1, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.joint1Name(), new FormBuilder.PanelConstraints[0]).label(this.maxPositionUnitLabel1, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionNormalMode1, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionReducedMode1, new FormBuilder.PanelConstraints[0]).label(this.tolerance2, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.joint2Name(), new FormBuilder.PanelConstraints[0]).label(this.maxPositionUnitLabel2, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionNormalMode2, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionReducedMode2, new FormBuilder.PanelConstraints[0]).label(this.tolerance3, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.joint3Name(), new FormBuilder.PanelConstraints[0]).label(this.maxPositionUnitLabel3, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionNormalMode3, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionReducedMode3, new FormBuilder.PanelConstraints[0]).label(this.tolerance4, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.joint4Name(), new FormBuilder.PanelConstraints[0]).label(this.maxPositionUnitLabel4, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionNormalMode4, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionReducedMode4, new FormBuilder.PanelConstraints[0]).label(this.tolerance5, new FormBuilder.PanelConstraints[0]).end().label(this.textResource.joint5Name(), new FormBuilder.PanelConstraints[0]).label(this.maxPositionUnitLabel5, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionNormalMode5, new FormBuilder.PanelConstraints[0]).component((JComponent)this.maxPositionReducedMode5, new FormBuilder.PanelConstraints[0]).label(this.tolerance6, new FormBuilder.PanelConstraints[0]).end().setOnPanel((JPanel)this);
        this.setBorder(new CompoundBorder((Border)new CardBorder(this.textResource.safetyLimitsMaxJointSpeed()), this.getBorder()));
    }

    @Override
    public void activate() {
        this.ghostReducedModeWhenReducedModeUnavailable();
    }

    @Override
    public void deactivate() {
    }

    class ChangeListener
    implements PropertyChangeListener {
        ChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SafetySetup safetySetup = JointSpeedLimitsPanel.this.safetySettingsLookupService.getSafetySetup();
            if (safetySetup != null) {
                safetySetup.fireEvent(evt);
            }
        }
    }
}

