/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.jointlimits;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.HTMLPage;
import com.ur.safety.SafetySetupPanesLookAndFeel;
import com.ur.safety.SafetySetupToHtmlContribution;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.generallimits.core.SafetyLimits;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import com.ur.safety.util.domain.AlternatingBackgroundRowGenerator;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.util.swing.HTML;
import java.text.DecimalFormat;
import javax.inject.Inject;

public class JointSpeedToHtmlRenderer
implements SafetySetupToHtmlContribution {
    private final SafetyTextResource translation;
    private final SafetySetupPanesLookAndFeel lookAndFeel;
    private UnitsConverter jointSpeedConverter;
    private DecimalFormat degFormat;
    private AlternatingBackgroundRowGenerator rowGenerator;

    @Inject
    public JointSpeedToHtmlRenderer(SafetyTextResource translation, SafetySetupPanesLookAndFeel lookAndFeel) {
        this.translation = translation;
        this.lookAndFeel = lookAndFeel;
    }

    @Override
    public HTMLPage createContributedPage(SafetySetup safetySetup, boolean useSIUnits) {
        this.degFormat = useSIUnits ? DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.0000") : PrimitiveUtils.WHOLE_NUMBER_FORMAT;
        this.jointSpeedConverter = useSIUnits ? Units.getRadiansPerSecondConverterSI() : Units.getDegreesPerSecondConverter();
        this.rowGenerator = new AlternatingBackgroundRowGenerator();
        SafetyLimits normalMode = ((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class)).getNormalLimits();
        SafetyLimits reducedMode = ((SafetyLimitsComponent)safetySetup.getComponent(SafetyLimitsComponent.class)).getReducedLimits();
        if (safetySetup.isReducedModeDefined() || useSIUnits) {
            return new HTMLPage(this.translation.jointSpeed(), this.generateJointLimits(normalMode, reducedMode));
        }
        return new HTMLPage(this.translation.jointSpeed(), this.generateJointLimits(normalMode));
    }

    private String generateJointLimits(SafetyLimits normalMode, SafetyLimits reducedMode) {
        return HTML.table((int)this.lookAndFeel.panelWidth, (String[])new String[]{HTML.tableRow((String[])new String[]{HTML.tableHeaderWithProperties((String)"align=left", (String)this.translation.jointColumnHeader()), HTML.tableHeaderWithProperties((String)"align=center", (String)this.translation.normalModeColumnHeader()), HTML.tableHeaderWithProperties((String)"align=center colspan=2", (String)this.translation.reducedModeColumnHeader())}), this.jointLimitRow(this.translation.joint0Name(), normalMode, reducedMode, 0), this.jointLimitRow(this.translation.joint1Name(), normalMode, reducedMode, 1), this.jointLimitRow(this.translation.joint2Name(), normalMode, reducedMode, 2), this.jointLimitRow(this.translation.joint3Name(), normalMode, reducedMode, 3), this.jointLimitRow(this.translation.joint4Name(), normalMode, reducedMode, 4), this.jointLimitRow(this.translation.joint5Name(), normalMode, reducedMode, 5)});
    }

    private String generateJointLimits(SafetyLimits normalMode) {
        return HTML.table((int)this.lookAndFeel.panelWidth, (String[])new String[]{HTML.tableRow((String[])new String[]{HTML.tableHeaderWithProperties((String)"align=left", (String)this.translation.jointColumnHeader()), HTML.tableHeaderWithProperties((String)"align=center", (String)this.translation.maxSpeed())}), this.jointLimitRow(this.translation.joint0Name(), normalMode, 0), this.jointLimitRow(this.translation.joint1Name(), normalMode, 1), this.jointLimitRow(this.translation.joint2Name(), normalMode, 2), this.jointLimitRow(this.translation.joint3Name(), normalMode, 3), this.jointLimitRow(this.translation.joint4Name(), normalMode, 4), this.jointLimitRow(this.translation.joint5Name(), normalMode, 5)});
    }

    private String jointLimitRow(String jointName, SafetyLimits normalMode, int jointId) {
        String maxSpeedFormatted = this.degFormat.format(this.jointSpeedConverter.convertFrom(normalMode.getMaxJointSpeeds()[jointId]));
        String maxSpeed = String.format("%s %s", maxSpeedFormatted, this.jointSpeedConverter.getUnit());
        return this.rowGenerator.generate(HTML.tableCell((String)jointName), HTML.tableCellWithProperties((String)"align=center", (String)maxSpeed));
    }

    private String jointLimitRow(String jointName, SafetyLimits normalMode, SafetyLimits reducedMode, int jointId) {
        String maxSpeedNormalFormatted = this.degFormat.format(this.jointSpeedConverter.convertFrom(normalMode.getMaxJointSpeeds()[jointId]));
        String maxSpeedReducedFormatted = this.degFormat.format(this.jointSpeedConverter.convertFrom(reducedMode.getMaxJointSpeeds()[jointId]));
        String normalMaxSpeed = String.format("%s", maxSpeedNormalFormatted);
        String reducedMaxSpeed = String.format("%s", maxSpeedReducedFormatted);
        return this.rowGenerator.generate(HTML.tableCell((String)jointName), HTML.tableCellWithProperties((String)"align=center", (String)normalMaxSpeed), HTML.tableCellNumber((String)reducedMaxSpeed), HTML.tableCell((String)this.jointSpeedConverter.getUnit()));
    }
}

