/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.jointlimits;

import com.ur.monitor.model.JointType;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.robot.configuration.joint.JointPositionRangeProvider;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.generallimits.core.SafetyLimits;
import com.ur.safety.generallimits.core.SafetyLimitsComponent;
import javax.inject.Inject;

public class SafetyJointPositionRangeProvider
implements JointPositionRangeProvider {
    private final SafetySettingsLookupService safetySettingsLookupService;
    private final JointConfigurationSettings configurationService;
    private ControllerInterface controllerInterface;

    @Inject
    protected SafetyJointPositionRangeProvider(SafetySettingsLookupService safetySettingsLookupService, JointConfigurationSettings configurationService, ControllerInterface controllerInterface) {
        this.safetySettingsLookupService = safetySettingsLookupService;
        this.configurationService = configurationService;
        this.controllerInterface = controllerInterface;
    }

    public boolean withPositionLimits(JointType each) {
        return this.getSafetyLimitsComponent().getWithPositionLimits(each);
    }

    public double getMaximumCombinedPosition(JointType each) {
        return this.getSafetyLimitsComponent().getMaximumCombinedJointLimit(each);
    }

    public double getMinimumCombinedPosition(JointType each) {
        return this.getSafetyLimitsComponent().getMinimumCombinedJointLimit(each);
    }

    public double getMaximumPosition(JointType each, boolean reducedMode) {
        return this.getSafetyLimitsComponent().getMaximumJointLimit(each, reducedMode);
    }

    public double getMinimumPosition(JointType each, boolean reducedMode) {
        return this.getSafetyLimitsComponent().getMinimumJointLimit(each, reducedMode);
    }

    public boolean isJointInsideRange(JointType jointType, double value) {
        return this.getSafetyLimitsComponent().isJointInsideCombinedSafetyLimit(jointType, value);
    }

    public boolean hasRestrictions() {
        return this.controllerInterface.isControllerAvailable() && this.hasSafetyLimitsComponent();
    }

    public boolean isRestricted(JointType jointType, boolean reducedMode) {
        if (!this.hasSafetyLimitsComponent()) {
            return true;
        }
        if (!this.getSafetyLimitsComponent().getWithPositionLimits(jointType)) {
            return false;
        }
        if (JointType.WRIST3 == jointType && this.configurationService.infiniteRevolutionsForWrist3()) {
            return false;
        }
        SafetyLimits safetyLimits = this.getSafetyLimitsComponent().getSafetyLimits(reducedMode);
        double minimumPosition = safetyLimits.getMinJointVector().getJoint(jointType).getTotalAngle();
        double maximumPosition = safetyLimits.getMaxJointVector().getJoint(jointType).getTotalAngle();
        return Math.toRadians(-364.0) <= minimumPosition && maximumPosition <= Math.toRadians(364.0);
    }

    private boolean hasSafetyLimitsComponent() {
        return this.safetySettingsLookupService.getControllerComponent(SafetyLimitsComponent.class).isPresent();
    }

    private SafetyLimitsComponent getSafetyLimitsComponent() {
        return (SafetyLimitsComponent)this.safetySettingsLookupService.getControllerComponent(SafetyLimitsComponent.class).get();
    }
}

