/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.misc;

import com.ur.lang.persist.WriteableModuleSettings;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.misc.core.SafetyMiscConfiguration;
import com.ur.view.constants.dev.TPType;
import gui.installation.InitialInstallationComponentContribution;
import javax.inject.Inject;
import javax.inject.Provider;

public class InitialTeachPendantInstallationComponentContribution
implements InitialInstallationComponentContribution {
    private static final WriteableModuleSettings initialTPType = new WriteableModuleSettings("oem.properties");
    private final Provider<SafetySetup> safetySetupProvider;

    @Inject
    public InitialTeachPendantInstallationComponentContribution(Provider<SafetySetup> safetySetupProvider) {
        this.safetySetupProvider = safetySetupProvider;
    }

    public InstallationComponent getInitialInstallation() {
        SafetySetup safetySetup = (SafetySetup)this.safetySetupProvider.get();
        SafetyMiscConfiguration safetyMiscConfiguration = (SafetyMiscConfiguration)safetySetup.getComponent(SafetyMiscConfiguration.class);
        TPType tpType = this.getInitialTPType();
        if (tpType != null) {
            safetyMiscConfiguration.setTeachPendant(tpType);
        }
        return safetySetup;
    }

    private TPType getInitialTPType() {
        int tpTypeId = initialTPType.properties().getInteger("initialTPType", -1);
        if (tpTypeId == -1) {
            return null;
        }
        return TPType.byId((int)tpTypeId);
    }
}

