/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.misc;

import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.HTMLPage;
import com.ur.safety.SafetySetupPanesLookAndFeel;
import com.ur.safety.SafetySetupToHtmlContribution;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.misc.core.SafetyMiscConfiguration;
import com.ur.safety.util.domain.AlternatingBackgroundRowGenerator;
import com.ur.util.swing.HTML;
import com.ur.view.constants.dev.TPType;
import com.ur.view.constants.immi.ImmiType;
import javax.inject.Inject;

public class MiscConfigurationToHtmlRenderer
implements SafetySetupToHtmlContribution {
    private final SafetyTextResource text;
    private final SafetySetupPanesLookAndFeel lookAndFeel;

    @Inject
    MiscConfigurationToHtmlRenderer(SafetyTextResource text, SafetySetupPanesLookAndFeel lookAndFeel) {
        this.text = text;
        this.lookAndFeel = lookAndFeel;
    }

    @Override
    public HTMLPage createContributedPage(SafetySetup safetySetup, boolean useSIUnits) {
        return new HTMLPage(this.text.safetyTabHardware(), this.generateMiscFunctions((SafetyMiscConfiguration)safetySetup.getComponent(SafetyMiscConfiguration.class)));
    }

    private String generateMiscFunctions(SafetyMiscConfiguration safetyMiscConfiguration) {
        AlternatingBackgroundRowGenerator rowGenerator = new AlternatingBackgroundRowGenerator();
        return HTML.table((int)this.lookAndFeel.panelWidth, (String[])new String[]{HTML.tableRow((String[])new String[]{HTML.tableHeaderWithProperties((String)"align=left", (String)this.text.safetyHeaderFunction()), HTML.tableHeaderWithProperties((String)"align=left", (String)this.text.Enabled())}), this.getTeachPendantRow(rowGenerator, safetyMiscConfiguration), this.getEuromap67Row(rowGenerator, safetyMiscConfiguration)});
    }

    protected String getEuromap67Row(AlternatingBackgroundRowGenerator rowGenerator, SafetyMiscConfiguration safetyMiscConfiguration) {
        return rowGenerator.generate(HTML.tableCell((String)this.text.injectionMoldingMachineInterface()), HTML.tableCell((String)this.getIMMIName(safetyMiscConfiguration.getImmiType())));
    }

    protected String getTeachPendantRow(AlternatingBackgroundRowGenerator rowGenerator, SafetyMiscConfiguration safetyMiscConfiguration) {
        return rowGenerator.generate(HTML.tableCell((String)this.text.teachPendant()), HTML.tableCell((String)this.getTeachPendantName(safetyMiscConfiguration.getTeachPendant())));
    }

    private String getIMMIName(ImmiType immiType) {
        switch (immiType) {
            case NOT_PRESENT: {
                return this.text.None();
            }
            case E67: {
                return this.text.euromap67();
            }
            case E12: {
                return this.text.euromap12();
            }
            case SPI_AN_146: {
                return this.text.spiAn146();
            }
            case SPI_AN_116: {
                return this.text.spiAn116();
            }
        }
        throw new IllegalStateException("Unexpected value: " + immiType);
    }

    private String getTeachPendantName(TPType tpType) {
        switch (tpType) {
            case NONE: {
                return this.text.No();
            }
            case STANDARD: {
                return this.text.standard();
            }
            case THREE_POSITION_ENABLING: {
                return this.text.threePositionEnabled();
            }
        }
        throw new IllegalStateException("Unexpected value: " + tpType);
    }
}

