/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.misc;

import com.ur.polyscope.robot.configuration.teachpendent.TPCapable;
import com.ur.polyscope.robot.configuration.teachpendent.TPCapableProvider;
import com.ur.resources.ViewImageResource;
import com.ur.safety.DefaultSafetyLockListener;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.misc.TeachPendantComboBoxRenderer;
import com.ur.safety.misc.TeachPendantLabelProvider;
import com.ur.safety.misc.TeachPendantService;
import com.ur.safety.misc.TeachPendantValidator;
import com.ur.safety.misc.core.SafetyMiscConfiguration;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.util.domain.UpdateParentWithFormState;
import com.ur.swing.ComboBox;
import com.ur.swing.EnumComboBoxModel;
import com.ur.swing.EnumListCellRenderer;
import com.ur.swing.FontFactory;
import com.ur.swing.FormBuilder;
import com.ur.swing.LabelProvider;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.validation.FormValidation;
import com.ur.swing.validation.SwingFormValidation;
import com.ur.util.event.EventNotificationService;
import com.ur.view.constants.dev.TPType;
import com.ur.view.constants.immi.ImmiType;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.jdesktop.swingx.JXLabel;

@Singleton
public class MiscSetupPanel
extends JPanel {
    public static final String TP_COMBOBOX = "TPCombobox." + MiscSetupPanel.class.getSimpleName();
    public static final String IMMI_COMBOBOX = "ImmiCombobox." + MiscSetupPanel.class.getSimpleName();
    private final ViewContext viewContext;
    private final SafetyTextResource textResource;
    private final TPCapableProvider tpCapableProvider;
    private final TeachPendantService teachPendantService;
    private final SwingFormValidation safetyFormValidation;
    private final SafetySettingsLookupService provider;
    private final TeachPendantComboBoxRenderer teachPendantComboBoxRenderer;
    private ComboBox<TPType> tpTypeComboBox;
    private ComboBox<ImmiType> immiComboBox;

    @Inject
    public MiscSetupPanel(SafetyLock safetyLock, SafetySettingsLookupService provider, ViewContext viewContext, TPCapableProvider tpCapableProvider, TeachPendantService teachPendantService) {
        this.provider = provider;
        this.viewContext = viewContext;
        this.tpCapableProvider = tpCapableProvider;
        this.teachPendantService = teachPendantService;
        this.textResource = (SafetyTextResource)viewContext.getTextResource(SafetyTextResource.class);
        this.safetyFormValidation = new SwingFormValidation();
        this.teachPendantComboBoxRenderer = new TeachPendantComboBoxRenderer(teachPendantService);
        this.initComponents();
        this.initHelp();
        this.bindToSafetyLock(safetyLock, provider);
    }

    private void initHelp() {
        this.viewContext.getHelpIdAssigner().assignHelpId(this.immiComboBox, "gui:immi_hardware");
    }

    private void initComponents() {
        WidgetFactory factory = this.viewContext.createWidgetFactory();
        TeachPendantLabelProvider teachPendantLabelProvider = new TeachPendantLabelProvider();
        this.tpTypeComboBox = factory.createComboBoxWithErrorBorder((LabelProvider)teachPendantLabelProvider, (Object[])this.getTeachPendantTypesForComboBox());
        this.tpTypeComboBox.setName(TP_COMBOBOX);
        this.immiComboBox = new ComboBox();
        this.immiComboBox.setName(IMMI_COMBOBOX);
        JLabel immiLabel = new JLabel(this.textResource.injectionMoldingMachineInterface());
        this.initTPComboBox();
        this.initImmiComboBox();
        FormBuilder formBuilder = this.viewContext.createFormBuilder();
        formBuilder.component((JComponent)new JLabel(this.textResource.TeachPendant()), new FormBuilder.PanelConstraints[0]).component(this.tpTypeComboBox, new FormBuilder.PanelConstraints[0]).end().component((JComponent)immiLabel, new FormBuilder.PanelConstraints[0]).component(this.immiComboBox, new FormBuilder.PanelConstraints[0]).end().spacer().end();
        formBuilder.label(ViewImageResource.formWarning(), this.textResource.teachPendantAndEuromap67Description(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.SPAN_3_ROWS}).end().end();
        JLabel jComponent = new JLabel();
        jComponent.setBorder(new EmptyBorder(15, 0, 15, 0));
        formBuilder.component((JComponent)jComponent, new FormBuilder.PanelConstraints[0]).end();
        this.tpCapableProvider.getTPCapable().ifPresent(tpCapable -> {
            if (tpCapable.requires3PEConfigured()) {
                formBuilder.component((JComponent)this.createNoneTPWarning(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end().end();
            }
        });
        JPanel hardwarePanel = formBuilder.getCardPanel(this.textResource.teachPendantAndEuromap67Label());
        this.setLayout(new BoxLayout(this, 2));
        this.setAlignmentX(0.0f);
        this.add(hardwarePanel);
        this.tpTypeComboBox.addActionListener(actionEvent -> {
            TPType selectedItem = (TPType)this.tpTypeComboBox.getSelectedItem();
            this.getConfiguration().setTeachPendant(selectedItem);
            EventNotificationService.notify(SafetyChangeListener.class, listener -> listener.safetyModified(this.provider.getSafetySetup()));
            this.safetyFormValidation.validate();
        });
        this.immiComboBox.addActionListener(actionEvent -> this.getConfiguration().setImmiType((ImmiType)this.immiComboBox.getSelectedItem()));
    }

    private JXLabel createNoneTPWarning() {
        JXLabel warning = new JXLabel();
        warning.setLineWrap(true);
        warning.setText(this.textResource.noneTeachPendentSelected());
        warning.setIcon(ViewImageResource.formWarning());
        warning.setFont(new FontFactory().getRelativeFont(URFontFactory.Style.ITALIC));
        return warning;
    }

    private void initTPComboBox() {
        EnumComboBoxModel comboBoxModel = new EnumComboBoxModel((Enum[])this.getTeachPendantTypesForComboBox());
        this.tpTypeComboBox.setModel((ComboBoxModel)comboBoxModel);
        this.teachPendantComboBoxRenderer.setTeachPendantService(this.teachPendantService);
        this.tpTypeComboBox.setRenderer((ListCellRenderer)((Object)this.teachPendantComboBoxRenderer));
    }

    private TPType[] getTeachPendantTypesForComboBox() {
        List<TPType> supportedTpTypes = Arrays.stream(this.tpCapableProvider.getTPCapable().map(TPCapable::getSupportedTeachPendents).orElse(new TPType[0])).collect(Collectors.toList());
        this.addSelectedTpTypeIfUnsupported(supportedTpTypes);
        return supportedTpTypes.toArray(new TPType[0]);
    }

    private void addSelectedTpTypeIfUnsupported(List<TPType> supportedTpTypes) {
        SafetyMiscConfiguration configuration = this.getConfiguration();
        TPType selectedTpType = configuration.getTeachPendant();
        boolean teachPendantTypeUnsupported = this.teachPendantService.isTeachPendantTypeUnsupported(selectedTpType);
        if (teachPendantTypeUnsupported) {
            supportedTpTypes.add(selectedTpType.getId(), selectedTpType);
        }
    }

    private void initImmiComboBox() {
        this.immiComboBox.setModel(this.createImmiModel());
        this.immiComboBox.setRenderer(this.createImmiCellRenderer());
    }

    private EnumComboBoxModel<ImmiType> createImmiModel() {
        return new EnumComboBoxModel(ImmiType.class, (Enum[])new ImmiType[]{ImmiType.E12, ImmiType.SPI_AN_116});
    }

    private EnumListCellRenderer<ImmiType> createImmiCellRenderer() {
        EnumMap<ImmiType, String> map = new EnumMap<ImmiType, String>(ImmiType.class);
        map.put(ImmiType.NOT_PRESENT, this.textResource.None());
        map.put(ImmiType.E67, this.textResource.euromap67());
        map.put(ImmiType.E12, this.textResource.euromap12());
        map.put(ImmiType.SPI_AN_146, this.textResource.spiAn146());
        map.put(ImmiType.SPI_AN_116, this.textResource.spiAn116());
        return new EnumListCellRenderer(map);
    }

    private void bindToSafetyLock(SafetyLock lock, SafetySettingsLookupService provider) {
        DefaultSafetyLockListener safetyLockListener = new DefaultSafetyLockListener(lock, provider, new JComponent[0]);
        safetyLockListener.addComponent((JComponent)this.tpTypeComboBox);
        safetyLockListener.addComponent((JComponent)this.immiComboBox);
        lock.addSafetyLockListener(safetyLockListener);
    }

    private SafetyMiscConfiguration getConfiguration() {
        return this.provider.getSafetyComponent(SafetyMiscConfiguration.class);
    }

    private void updateComboBoxes() {
        SafetyMiscConfiguration configuration = this.getConfiguration();
        this.initTPComboBox();
        this.tpTypeComboBox.setSelectedItem((Object)configuration.getTeachPendant());
        this.initImmiComboBox();
        this.immiComboBox.setSelectedItem((Object)configuration.getImmiType());
    }

    ComboBox<TPType> getTpTypeComboBox() {
        return this.tpTypeComboBox;
    }

    ComboBox<ImmiType> getImmiComboBox() {
        return this.immiComboBox;
    }

    public void bindFormValidation(UpdateParentWithFormState formStatus) {
        this.safetyFormValidation.clearForm();
        this.safetyFormValidation.addFormListener((FormValidation.FormListener)formStatus);
        this.addTeachPendantValidation();
        this.safetyFormValidation.validate();
    }

    private void addTeachPendantValidation() {
        TeachPendantValidator teachPendantValidator = new TeachPendantValidator(this.tpTypeComboBox, this.textResource, this.teachPendantService);
        this.safetyFormValidation.addErrorValidation(this.tpTypeComboBox, (FormValidation.Validator)teachPendantValidator);
    }

    public void resetUI(UpdateParentWithFormState formStatus) {
        this.updateComboBoxes();
        this.bindFormValidation(formStatus);
    }
}

