/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.misc;

import com.ur.safety.SafetyTextResource;
import com.ur.safety.misc.TeachPendantService;
import com.ur.swing.renderers.ElementCellRenderer;
import com.ur.view.constants.dev.TPType;
import javax.inject.Inject;
import javax.swing.JLabel;
import javax.swing.JList;

public class TeachPendantCellRenderer
implements ElementCellRenderer<TPType> {
    private final SafetyTextResource safetyTextResource;
    private final TeachPendantService teachPendantService;

    @Inject
    public TeachPendantCellRenderer(SafetyTextResource safetyTextResource, TeachPendantService teachPendantService) {
        this.safetyTextResource = safetyTextResource;
        this.teachPendantService = teachPendantService;
    }

    public boolean supportsType(Object value) {
        return value instanceof TPType;
    }

    public void renderElement(JLabel renderTo, JList containingList, TPType element) {
        String teachPendantType = this.getCorrectTPText(element);
        renderTo.setText(teachPendantType);
    }

    public boolean hasError(TPType value) {
        return this.teachPendantService.isTeachPendantTypeUnsupported(value);
    }

    private String getCorrectTPText(TPType tpType) {
        switch (tpType) {
            case STANDARD: {
                return this.safetyTextResource.standard();
            }
            case THREE_POSITION_ENABLING: {
                return this.safetyTextResource.threePositionEnabled();
            }
        }
        return this.safetyTextResource.None();
    }
}

