/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.misc.infrastructure;

import com.ur.lang.EqualsUtil;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageListener;
import com.ur.view.constants.comm.RobotMessageType;
import javax.inject.Inject;

public class ErrorCodeRobotMessageListener
implements RobotMessageListener {
    public static final int CODE_50A16 = 16;
    public static final int CODE_50A17 = 17;
    public static final int CODE_4A8 = 8;
    public static final int CODE_4A9 = 9;
    public static final int CODE_4A10 = 10;
    public static final int CODE_4A11 = 11;
    private ErrorCodeMessageListenerFacade listenerFacade;

    @Inject
    ErrorCodeRobotMessageListener(ErrorCodeMessageListenerFacade errorCodeMessageListenerFacade) {
        this.listenerFacade = errorCodeMessageListenerFacade;
    }

    public void handleRobotMessage(RobotMessage robotMessage) {
        if (robotMessage.type == RobotMessageType.ERROR_CODE) {
            switch (robotMessage.errorCode) {
                case ROBOT_POWERUP_FAILURE: {
                    if (!EqualsUtil.equalsOneOf((Object)robotMessage.errorArgument, (Object[])new Integer[]{16, 17})) break;
                    this.listenerFacade.showMiscSetupTab();
                    break;
                }
                case BROKEN_COMMUNICATION_ERROR: {
                    if (!EqualsUtil.equalsOneOf((Object)robotMessage.errorArgument, (Object[])new Integer[]{8, 9, 10, 11})) break;
                    this.listenerFacade.showMiscSetupTab();
                    break;
                }
                case GUI_SAFETY_PARAMETERS_MISMATCH: {
                    this.listenerFacade.informUserOfErrorState(robotMessage);
                    break;
                }
            }
        }
    }

    public static interface ErrorCodeMessageListenerFacade {
        public void informUserOfErrorState(RobotMessage var1);

        public void showMiscSetupTab();
    }
}

